package arrow.validation.refinedTypes.numeric.either.less

import arrow.core.Either
import arrow.core.Either.Companion
import arrow.core.NonEmptyList
import arrow.typeclasses.Order
import arrow.validation.RefinedPredicateException
import arrow.validation.refinedTypes.numeric.EitherLess
import kotlin.Boolean
import kotlin.Function1
import kotlin.Number
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

@JvmName("refinement")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <A : Number> A.refinement(ORD: Order<A>, max: A): Boolean =
    arrow.core.Either.less<A>(ORD, max).run {
  this@refinement.refinement() as kotlin.Boolean
}

@JvmName("less")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <A : Number> A.less(ORD: Order<A>, max: A): Either<NonEmptyList<RefinedPredicateException>, A> =
    arrow.core.Either.less<A>(ORD, max).run {
  this@less.less() as
    arrow.core.Either<arrow.core.NonEmptyList<arrow.validation.RefinedPredicateException>, A>
}

@JvmName("less")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <A : Number, B> A.less(
  ORD: Order<A>,
  max: A,
  f: Function1<A, B>
): Either<NonEmptyList<RefinedPredicateException>, B> = arrow.core.Either.less<A>(ORD, max).run {
  this@less.less<B>(f) as
    arrow.core.Either<arrow.core.NonEmptyList<arrow.validation.RefinedPredicateException>, B>
}

@JvmName("invalidValueMsg")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <A : Number> invalidValueMsg(
  ORD: Order<A>,
  max: A,
  a: A
): String = arrow.core.Either
   .less<A>(ORD, max)
   .invalidValueMsg(a) as kotlin.String

@JvmName("ORD")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <A : Number> ORD(ORD: Order<A>, max: A): Order<A> = arrow.core.Either
   .less<A>(ORD, max)
   .ORD() as arrow.typeclasses.Order<A>

@JvmName("max")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <A : Number> max(ORD: Order<A>, max: A): A = arrow.core.Either
   .less<A>(ORD, max)
   .max() as A

@Suppress(
    "UNCHECKED_CAST",
    "NOTHING_TO_INLINE"
)
inline fun <A : Number> Companion.less(ORD: Order<A>, max: A): EitherLess<A> = object :
    arrow.validation.refinedTypes.numeric.EitherLess<A> { override fun ORD():
    arrow.typeclasses.Order<A> = ORD

  override fun max(): A = max }