package arrow.validation.refinedTypes.numeric.either.negative

import arrow.core.Either
import arrow.core.Either.Companion
import arrow.core.NonEmptyList
import arrow.typeclasses.Order
import arrow.validation.RefinedPredicateException
import arrow.validation.refinedTypes.numeric.EitherNegative
import kotlin.Boolean
import kotlin.Function1
import kotlin.Number
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

@JvmName("refinement")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <A : Number> A.refinement(ORD: Order<A>): Boolean = arrow.core.Either.negative<A>(ORD).run {
  this@refinement.refinement() as kotlin.Boolean
}

@JvmName("negative")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <A : Number> A.negative(ORD: Order<A>): Either<NonEmptyList<RefinedPredicateException>, A> =
    arrow.core.Either.negative<A>(ORD).run {
  this@negative.negative() as
    arrow.core.Either<arrow.core.NonEmptyList<arrow.validation.RefinedPredicateException>, A>
}

@JvmName("negative")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <A : Number, B> A.negative(ORD: Order<A>, f: Function1<A, B>):
    Either<NonEmptyList<RefinedPredicateException>, B> = arrow.core.Either.negative<A>(ORD).run {
  this@negative.negative<B>(f) as
    arrow.core.Either<arrow.core.NonEmptyList<arrow.validation.RefinedPredicateException>, B>
}

@JvmName("invalidValueMsg")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <A : Number> invalidValueMsg(ORD: Order<A>, a: A): String = arrow.core.Either
   .negative<A>(ORD)
   .invalidValueMsg(a) as kotlin.String

@JvmName("ORD")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <A : Number> ORD(ORD: Order<A>): Order<A> = arrow.core.Either
   .negative<A>(ORD)
   .ORD() as arrow.typeclasses.Order<A>

@Suppress(
    "UNCHECKED_CAST",
    "NOTHING_TO_INLINE"
)
inline fun <A : Number> Companion.negative(ORD: Order<A>): EitherNegative<A> = object :
    arrow.validation.refinedTypes.numeric.EitherNegative<A> { override fun ORD():
    arrow.typeclasses.Order<A> = ORD }