package arrow.validation.refinedTypes.numeric.either.nonPositive

import arrow.core.Either
import arrow.core.Either.Companion
import arrow.core.NonEmptyList
import arrow.typeclasses.Order
import arrow.validation.RefinedPredicateException
import arrow.validation.refinedTypes.numeric.EitherNonPositive
import kotlin.Boolean
import kotlin.Function1
import kotlin.Number
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

@JvmName("refinement")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <A : Number> A.refinement(ORD: Order<A>): Boolean = arrow.core.Either.nonPositive<A>(ORD).run {
  this@refinement.refinement() as kotlin.Boolean
}

@JvmName("nonPositive")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <A : Number> A.nonPositive(ORD: Order<A>): Either<NonEmptyList<RefinedPredicateException>, A> =
    arrow.core.Either.nonPositive<A>(ORD).run {
  this@nonPositive.nonPositive() as
    arrow.core.Either<arrow.core.NonEmptyList<arrow.validation.RefinedPredicateException>, A>
}

@JvmName("nonPositive")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <A : Number, B> A.nonPositive(ORD: Order<A>, f: Function1<A, B>):
    Either<NonEmptyList<RefinedPredicateException>, B> = arrow.core.Either.nonPositive<A>(ORD).run {
  this@nonPositive.nonPositive<B>(f) as
    arrow.core.Either<arrow.core.NonEmptyList<arrow.validation.RefinedPredicateException>, B>
}

@JvmName("invalidValueMsg")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <A : Number> invalidValueMsg(ORD: Order<A>, a: A): String = arrow.core.Either
   .nonPositive<A>(ORD)
   .invalidValueMsg(a) as kotlin.String

@JvmName("ORD")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <A : Number> ORD(ORD: Order<A>): Order<A> = arrow.core.Either
   .nonPositive<A>(ORD)
   .ORD() as arrow.typeclasses.Order<A>

@Suppress(
    "UNCHECKED_CAST",
    "NOTHING_TO_INLINE"
)
inline fun <A : Number> Companion.nonPositive(ORD: Order<A>): EitherNonPositive<A> = object :
    arrow.validation.refinedTypes.numeric.EitherNonPositive<A> { override fun ORD():
    arrow.typeclasses.Order<A> = ORD }