package arrow.validation.refinedTypes.numeric.validated.greaterEqual

import arrow.core.NonEmptyList
import arrow.core.Validated
import arrow.core.Validated.Companion
import arrow.typeclasses.Order
import arrow.validation.RefinedPredicateException
import arrow.validation.refinedTypes.numeric.ValidatedGreaterEqual
import kotlin.Boolean
import kotlin.Function1
import kotlin.Number
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

@JvmName("refinement")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <A : Number> A.refinement(ORD: Order<A>, min: A): Boolean =
    arrow.core.Validated.greaterEqual<A>(ORD, min).run {
  this@refinement.refinement() as kotlin.Boolean
}

@JvmName("invalidValueMsg")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <A : Number> invalidValueMsg(
  ORD: Order<A>,
  min: A,
  a: A
): String = arrow.core.Validated
   .greaterEqual<A>(ORD, min)
   .invalidValueMsg(a) as kotlin.String

@JvmName("greaterEqual")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <A : Number> A.greaterEqual(ORD: Order<A>, min: A):
    Validated<NonEmptyList<RefinedPredicateException>, A> =
    arrow.core.Validated.greaterEqual<A>(ORD, min).run {
  this@greaterEqual.greaterEqual() as
    arrow.core.Validated<arrow.core.NonEmptyList<arrow.validation.RefinedPredicateException>, A>
}

@JvmName("greaterEqual")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <A : Number, B> A.greaterEqual(
  ORD: Order<A>,
  min: A,
  f: Function1<A, B>
): Validated<NonEmptyList<RefinedPredicateException>, B> =
    arrow.core.Validated.greaterEqual<A>(ORD, min).run {
  this@greaterEqual.greaterEqual<B>(f) as
    arrow.core.Validated<arrow.core.NonEmptyList<arrow.validation.RefinedPredicateException>, B>
}

@JvmName("ORD")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <A : Number> ORD(ORD: Order<A>, min: A): Order<A> = arrow.core.Validated
   .greaterEqual<A>(ORD, min)
   .ORD() as arrow.typeclasses.Order<A>

@JvmName("min")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <A : Number> min(ORD: Order<A>, min: A): A = arrow.core.Validated
   .greaterEqual<A>(ORD, min)
   .min() as A

@Suppress(
    "UNCHECKED_CAST",
    "NOTHING_TO_INLINE"
)
inline fun <A : Number> Companion.greaterEqual(ORD: Order<A>, min: A): ValidatedGreaterEqual<A> =
    object : arrow.validation.refinedTypes.numeric.ValidatedGreaterEqual<A> { override fun ORD():
    arrow.typeclasses.Order<A> = ORD

  override fun min(): A = min }