package arrow.validation.refinedTypes.numeric.validated.lessEqual

import arrow.core.NonEmptyList
import arrow.core.Validated
import arrow.core.Validated.Companion
import arrow.typeclasses.Order
import arrow.validation.RefinedPredicateException
import arrow.validation.refinedTypes.numeric.ValidatedLessEqual
import kotlin.Boolean
import kotlin.Function1
import kotlin.Number
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

@JvmName("refinement")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <A : Number> A.refinement(ORD: Order<A>, max: A): Boolean =
    arrow.core.Validated.lessEqual<A>(ORD, max).run {
  this@refinement.refinement() as kotlin.Boolean
}

@JvmName("invalidValueMsg")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <A : Number> invalidValueMsg(
  ORD: Order<A>,
  max: A,
  a: A
): String = arrow.core.Validated
   .lessEqual<A>(ORD, max)
   .invalidValueMsg(a) as kotlin.String

@JvmName("lessEqual")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <A : Number> A.lessEqual(ORD: Order<A>, max: A):
    Validated<NonEmptyList<RefinedPredicateException>, A> =
    arrow.core.Validated.lessEqual<A>(ORD, max).run {
  this@lessEqual.lessEqual() as
    arrow.core.Validated<arrow.core.NonEmptyList<arrow.validation.RefinedPredicateException>, A>
}

@JvmName("lessEqual")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <A : Number, B> A.lessEqual(
  ORD: Order<A>,
  max: A,
  f: Function1<A, B>
): Validated<NonEmptyList<RefinedPredicateException>, B> =
    arrow.core.Validated.lessEqual<A>(ORD, max).run {
  this@lessEqual.lessEqual<B>(f) as
    arrow.core.Validated<arrow.core.NonEmptyList<arrow.validation.RefinedPredicateException>, B>
}

@JvmName("ORD")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <A : Number> ORD(ORD: Order<A>, max: A): Order<A> = arrow.core.Validated
   .lessEqual<A>(ORD, max)
   .ORD() as arrow.typeclasses.Order<A>

@JvmName("max")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <A : Number> max(ORD: Order<A>, max: A): A = arrow.core.Validated
   .lessEqual<A>(ORD, max)
   .max() as A

@Suppress(
    "UNCHECKED_CAST",
    "NOTHING_TO_INLINE"
)
inline fun <A : Number> Companion.lessEqual(ORD: Order<A>, max: A): ValidatedLessEqual<A> = object :
    arrow.validation.refinedTypes.numeric.ValidatedLessEqual<A> { override fun ORD():
    arrow.typeclasses.Order<A> = ORD

  override fun max(): A = max }