package arrow.validation.refinedTypes.numeric.validated.positive

import arrow.core.NonEmptyList
import arrow.core.Validated
import arrow.core.Validated.Companion
import arrow.typeclasses.Order
import arrow.validation.RefinedPredicateException
import arrow.validation.refinedTypes.numeric.ValidatedPositive
import kotlin.Boolean
import kotlin.Function1
import kotlin.Number
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

@JvmName("refinement")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <A : Number> A.refinement(ORD: Order<A>): Boolean = arrow.core.Validated.positive<A>(ORD).run {
  this@refinement.refinement() as kotlin.Boolean
}

@JvmName("positive")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <A : Number> A.positive(ORD: Order<A>): Validated<NonEmptyList<RefinedPredicateException>, A> =
    arrow.core.Validated.positive<A>(ORD).run {
  this@positive.positive() as
    arrow.core.Validated<arrow.core.NonEmptyList<arrow.validation.RefinedPredicateException>, A>
}

@JvmName("positive")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <A : Number, B> A.positive(ORD: Order<A>, f: Function1<A, B>):
    Validated<NonEmptyList<RefinedPredicateException>, B> =
    arrow.core.Validated.positive<A>(ORD).run {
  this@positive.positive<B>(f) as
    arrow.core.Validated<arrow.core.NonEmptyList<arrow.validation.RefinedPredicateException>, B>
}

@JvmName("invalidValueMsg")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <A : Number> invalidValueMsg(ORD: Order<A>, a: A): String = arrow.core.Validated
   .positive<A>(ORD)
   .invalidValueMsg(a) as kotlin.String

@JvmName("ORD")
@Suppress(
    "UNCHECKED_CAST",
    "USELESS_CAST",
    "EXTENSION_SHADOWED_BY_MEMBER",
    "UNUSED_PARAMETER"
)
fun <A : Number> ORD(ORD: Order<A>): Order<A> = arrow.core.Validated
   .positive<A>(ORD)
   .ORD() as arrow.typeclasses.Order<A>

@Suppress(
    "UNCHECKED_CAST",
    "NOTHING_TO_INLINE"
)
inline fun <A : Number> Companion.positive(ORD: Order<A>): ValidatedPositive<A> = object :
    arrow.validation.refinedTypes.numeric.ValidatedPositive<A> { override fun ORD():
    arrow.typeclasses.Order<A> = ORD }