/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.servlet.internal;

import io.crnk.core.engine.http.HttpRequestContextBase;
import io.crnk.core.engine.internal.utils.IOUtils;
import io.crnk.core.engine.internal.utils.PreconditionUtil;
import io.crnk.core.engine.internal.utils.UrlUtils;
import io.crnk.core.utils.Nullable;
import io.crnk.legacy.internal.RepositoryMethodParameterProvider;
import io.crnk.servlet.internal.legacy.ServletParametersProvider;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ServletRequestContext
implements HttpRequestContextBase {
    private final HttpServletRequest request;
    private final HttpServletResponse response;
    private final ServletParametersProvider parameterProvider;
    private final ServletContext servletContext;
    private Map<String, Set<String>> parameters;
    private Nullable<byte[]> requestBody = Nullable.empty();
    private boolean hasResponse;
    private String pathPrefix;

    public ServletRequestContext(ServletContext servletContext, HttpServletRequest request, HttpServletResponse response, String pathPrefix) {
        this.pathPrefix = pathPrefix;
        this.servletContext = servletContext;
        this.request = request;
        this.response = response;
        this.parameterProvider = new ServletParametersProvider(servletContext, request, response);
        this.parameters = this.getParameters(request);
    }

    public boolean checkAbort() {
        return this.hasResponse;
    }

    private Map<String, Set<String>> getParameters(HttpServletRequest request) {
        HashMap<String, Set<String>> queryParameters = new HashMap<String, Set<String>>();
        for (Map.Entry queryEntry : request.getParameterMap().entrySet()) {
            queryParameters.put((String)queryEntry.getKey(), (Set<String>)new LinkedHashSet<Object>(Arrays.asList((Object[])queryEntry.getValue())));
        }
        return queryParameters;
    }

    public RepositoryMethodParameterProvider getRequestParameterProvider() {
        return this.parameterProvider;
    }

    public String getRequestHeader(String name) {
        return this.request.getHeader(name);
    }

    public Map<String, Set<String>> getRequestParameters() {
        return this.parameters;
    }

    public String getPath() {
        String path = this.request.getPathInfo();
        if (path == null) {
            path = this.request.getRequestURI().substring(this.request.getContextPath().length());
        }
        if (this.pathPrefix != null && path.startsWith(this.pathPrefix)) {
            path = path.substring(this.pathPrefix.length());
        }
        return path;
    }

    public String getBaseUrl() {
        String requestUrl = this.request.getRequestURL().toString();
        String servletPath = this.request.getServletPath();
        int sep = requestUrl.indexOf(servletPath);
        String url = requestUrl.substring(0, sep + servletPath.length());
        return UrlUtils.removeTrailingSlash((String)url);
    }

    public byte[] getRequestBody() throws IOException {
        if (!this.requestBody.isPresent()) {
            ServletInputStream is = this.request.getInputStream();
            this.requestBody = is != null ? Nullable.of((Object)IOUtils.readFully((InputStream)is)) : Nullable.nullValue();
        }
        return (byte[])this.requestBody.get();
    }

    public void setResponseHeader(String name, String value) {
        PreconditionUtil.assertFalse((String)"response set, cannot add further headers", (boolean)this.hasResponse);
        this.response.setHeader(name, value);
    }

    public void setResponse(int code, byte[] body) throws IOException {
        this.hasResponse = true;
        this.response.setStatus(code);
        if (body != null) {
            ServletOutputStream out = this.response.getOutputStream();
            out.write(body);
            out.close();
        }
    }

    public String getMethod() {
        return this.request.getMethod().toUpperCase();
    }

    public String getResponseHeader(String name) {
        return this.response.getHeader(name);
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }
}

