/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.pipeline.source.snapshot.incremental;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.connector.SourceInfoStructMaker;
import io.debezium.doc.FixFor;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.pipeline.notification.NotificationService;
import io.debezium.pipeline.source.snapshot.incremental.IncrementalSnapshotContext;
import io.debezium.pipeline.source.snapshot.incremental.SignalBasedIncrementalSnapshotChangeEventSource;
import io.debezium.pipeline.source.snapshot.incremental.SignalBasedIncrementalSnapshotContext;
import io.debezium.pipeline.source.spi.DataChangeEventListener;
import io.debezium.pipeline.source.spi.SnapshotProgressListener;
import io.debezium.relational.Column;
import io.debezium.relational.ColumnFilterMode;
import io.debezium.relational.RelationalDatabaseConnectorConfig;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class SignalBasedSnapshotChangeEventSourceTest {
    @Mock
    private NotificationService notificationService;

    protected RelationalDatabaseConnectorConfig config() {
        return this.buildConfig(((Configuration.Builder)((Configuration.Builder)Configuration.create().with(RelationalDatabaseConnectorConfig.SIGNAL_DATA_COLLECTION, "debezium.signal")).with(RelationalDatabaseConnectorConfig.TOPIC_PREFIX, "core")).build());
    }

    protected RelationalDatabaseConnectorConfig buildConfig(Configuration configuration) {
        return new RelationalDatabaseConnectorConfig(configuration, null, null, 0, ColumnFilterMode.CATALOG, true){

            protected SourceInfoStructMaker<?> getSourceInfoStructMaker(CommonConnectorConfig.Version version) {
                return null;
            }

            public String getContextName() {
                return null;
            }

            public String getConnectorName() {
                return null;
            }
        };
    }

    @Test
    public void testBuildQueryOnePkColumn() {
        SignalBasedIncrementalSnapshotChangeEventSource source = new SignalBasedIncrementalSnapshotChangeEventSource(this.config(), new JdbcConnection(this.config().getJdbcConfig(), config -> null, "\"", "\""), null, null, null, SnapshotProgressListener.NO_OP(), DataChangeEventListener.NO_OP(), this.notificationService);
        SignalBasedIncrementalSnapshotContext context = new SignalBasedIncrementalSnapshotContext();
        source.setContext((IncrementalSnapshotContext)context);
        Column pk1 = Column.editor().name("pk1").create();
        Column val1 = Column.editor().name("val1").create();
        Column val2 = Column.editor().name("val2").create();
        Table table = Table.editor().tableId(new TableId(null, "s1", "table1")).addColumn(pk1).addColumn(val1).addColumn(val2).setPrimaryKeyNames(new String[]{"pk1"}).create();
        Assertions.assertThat((String)source.buildChunkQuery(table, Optional.empty())).isEqualTo((Object)"SELECT * FROM \"s1\".\"table1\" ORDER BY \"pk1\" LIMIT 1024");
        context.nextChunkPosition(new Object[]{1, 5});
        context.maximumKey(new Object[]{10, 50});
        Assertions.assertThat((String)source.buildChunkQuery(table, Optional.empty())).isEqualTo((Object)"SELECT * FROM \"s1\".\"table1\" WHERE (\"pk1\" > ?) AND NOT (\"pk1\" > ?) ORDER BY \"pk1\" LIMIT 1024");
    }

    @Test
    public void testBuildQueryOnePkColumnWithAdditionalCondition() {
        SignalBasedIncrementalSnapshotChangeEventSource source = new SignalBasedIncrementalSnapshotChangeEventSource(this.config(), new JdbcConnection(this.config().getJdbcConfig(), config -> null, "\"", "\""), null, null, null, SnapshotProgressListener.NO_OP(), DataChangeEventListener.NO_OP(), this.notificationService);
        SignalBasedIncrementalSnapshotContext context = new SignalBasedIncrementalSnapshotContext();
        source.setContext((IncrementalSnapshotContext)context);
        Column pk1 = Column.editor().name("pk1").create();
        Column val1 = Column.editor().name("val1").create();
        Column val2 = Column.editor().name("val2").create();
        Table table = Table.editor().tableId(new TableId(null, "s1", "table1")).addColumn(pk1).addColumn(val1).addColumn(val2).setPrimaryKeyNames(new String[]{"pk1"}).create();
        Assertions.assertThat((String)source.buildChunkQuery(table, Optional.of("\"val1\"=foo"))).isEqualTo((Object)"SELECT * FROM \"s1\".\"table1\" WHERE \"val1\"=foo ORDER BY \"pk1\" LIMIT 1024");
        context.nextChunkPosition(new Object[]{1, 5});
        context.maximumKey(new Object[]{10, 50});
        Assertions.assertThat((String)source.buildChunkQuery(table, Optional.of("\"val1\"=foo"))).isEqualTo((Object)"SELECT * FROM \"s1\".\"table1\" WHERE (\"pk1\" > ?) AND NOT (\"pk1\" > ?) AND \"val1\"=foo ORDER BY \"pk1\" LIMIT 1024");
    }

    @Test
    public void testBuildQueryTwoPkColumnsWithAdditionalConditionWithSurrogateKey() {
        SignalBasedIncrementalSnapshotChangeEventSource source = new SignalBasedIncrementalSnapshotChangeEventSource(this.config(), new JdbcConnection(this.config().getJdbcConfig(), config -> null, "\"", "\""), null, null, null, SnapshotProgressListener.NO_OP(), DataChangeEventListener.NO_OP(), this.notificationService);
        SignalBasedIncrementalSnapshotContext context = new SignalBasedIncrementalSnapshotContext();
        source.setContext((IncrementalSnapshotContext)context);
        Column pk1 = Column.editor().name("pk1").create();
        Column pk2 = Column.editor().name("pk2").create();
        Column val1 = Column.editor().name("val1").create();
        Column val2 = Column.editor().name("val2").create();
        Table table = Table.editor().tableId(new TableId(null, "s1", "table1")).addColumn(pk1).addColumn(pk2).addColumn(val1).addColumn(val2).setPrimaryKeyNames(new String[]{"pk1", "pk2"}).create();
        context.addDataCollectionNamesToSnapshot(List.of(table.id().toString()), Optional.empty(), Optional.of("pk2"));
        Assertions.assertThat((String)source.buildChunkQuery(table, Optional.of("\"val1\"=foo"))).isEqualTo((Object)"SELECT * FROM \"s1\".\"table1\" WHERE \"val1\"=foo ORDER BY \"pk2\" LIMIT 1024");
        context.nextChunkPosition(new Object[]{1, 5});
        context.maximumKey(new Object[]{10, 50});
        Assertions.assertThat((String)source.buildChunkQuery(table, Optional.of("\"val1\"=foo"))).isEqualTo((Object)"SELECT * FROM \"s1\".\"table1\" WHERE (\"pk2\" > ?) AND NOT (\"pk2\" > ?) AND \"val1\"=foo ORDER BY \"pk2\" LIMIT 1024");
    }

    @Test
    public void testBuildQueryThreePkColumns() {
        SignalBasedIncrementalSnapshotChangeEventSource source = new SignalBasedIncrementalSnapshotChangeEventSource(this.config(), new JdbcConnection(this.config().getJdbcConfig(), config -> null, "\"", "\""), null, null, null, SnapshotProgressListener.NO_OP(), DataChangeEventListener.NO_OP(), this.notificationService);
        SignalBasedIncrementalSnapshotContext context = new SignalBasedIncrementalSnapshotContext();
        source.setContext((IncrementalSnapshotContext)context);
        Column pk1 = Column.editor().name("pk1").create();
        Column pk2 = Column.editor().name("pk2").create();
        Column pk3 = Column.editor().name("pk3").create();
        Column val1 = Column.editor().name("val1").create();
        Column val2 = Column.editor().name("val2").create();
        Table table = Table.editor().tableId(new TableId(null, "s1", "table1")).addColumn(pk1).addColumn(pk2).addColumn(pk3).addColumn(val1).addColumn(val2).setPrimaryKeyNames(new String[]{"pk1", "pk2", "pk3"}).create();
        Assertions.assertThat((String)source.buildChunkQuery(table, Optional.empty())).isEqualTo((Object)"SELECT * FROM \"s1\".\"table1\" ORDER BY \"pk1\", \"pk2\", \"pk3\" LIMIT 1024");
        context.nextChunkPosition(new Object[]{1, 5});
        context.maximumKey(new Object[]{10, 50});
        Assertions.assertThat((String)source.buildChunkQuery(table, Optional.empty())).isEqualTo((Object)"SELECT * FROM \"s1\".\"table1\" WHERE ((\"pk1\" > ?) OR (\"pk1\" = ? AND \"pk2\" > ?) OR (\"pk1\" = ? AND \"pk2\" = ? AND \"pk3\" > ?)) AND NOT ((\"pk1\" > ?) OR (\"pk1\" = ? AND \"pk2\" > ?) OR (\"pk1\" = ? AND \"pk2\" = ? AND \"pk3\" > ?)) ORDER BY \"pk1\", \"pk2\", \"pk3\" LIMIT 1024");
    }

    @Test
    public void testBuildQueryThreePkColumnsWithAdditionalCondition() {
        SignalBasedIncrementalSnapshotChangeEventSource source = new SignalBasedIncrementalSnapshotChangeEventSource(this.config(), new JdbcConnection(this.config().getJdbcConfig(), config -> null, "\"", "\""), null, null, null, SnapshotProgressListener.NO_OP(), DataChangeEventListener.NO_OP(), this.notificationService);
        SignalBasedIncrementalSnapshotContext context = new SignalBasedIncrementalSnapshotContext();
        source.setContext((IncrementalSnapshotContext)context);
        Column pk1 = Column.editor().name("pk1").create();
        Column pk2 = Column.editor().name("pk2").create();
        Column pk3 = Column.editor().name("pk3").create();
        Column val1 = Column.editor().name("val1").create();
        Column val2 = Column.editor().name("val2").create();
        Table table = Table.editor().tableId(new TableId(null, "s1", "table1")).addColumn(pk1).addColumn(pk2).addColumn(pk3).addColumn(val1).addColumn(val2).setPrimaryKeyNames(new String[]{"pk1", "pk2", "pk3"}).create();
        Assertions.assertThat((String)source.buildChunkQuery(table, Optional.of("\"val1\"=foo"))).isEqualTo((Object)"SELECT * FROM \"s1\".\"table1\" WHERE \"val1\"=foo ORDER BY \"pk1\", \"pk2\", \"pk3\" LIMIT 1024");
        context.nextChunkPosition(new Object[]{1, 5});
        context.maximumKey(new Object[]{10, 50});
        Assertions.assertThat((String)source.buildChunkQuery(table, Optional.of("\"val1\"=foo"))).isEqualTo((Object)"SELECT * FROM \"s1\".\"table1\" WHERE ((\"pk1\" > ?) OR (\"pk1\" = ? AND \"pk2\" > ?) OR (\"pk1\" = ? AND \"pk2\" = ? AND \"pk3\" > ?)) AND NOT ((\"pk1\" > ?) OR (\"pk1\" = ? AND \"pk2\" > ?) OR (\"pk1\" = ? AND \"pk2\" = ? AND \"pk3\" > ?)) AND \"val1\"=foo ORDER BY \"pk1\", \"pk2\", \"pk3\" LIMIT 1024");
    }

    @Test
    public void testBuildQueryTwoPkColumnsWithSurrogateKey() {
        SignalBasedIncrementalSnapshotChangeEventSource source = new SignalBasedIncrementalSnapshotChangeEventSource(this.config(), new JdbcConnection(this.config().getJdbcConfig(), config -> null, "\"", "\""), null, null, null, SnapshotProgressListener.NO_OP(), DataChangeEventListener.NO_OP(), this.notificationService);
        SignalBasedIncrementalSnapshotContext context = new SignalBasedIncrementalSnapshotContext();
        source.setContext((IncrementalSnapshotContext)context);
        Column pk1 = Column.editor().name("pk1").create();
        Column pk2 = Column.editor().name("pk2").create();
        Column val1 = Column.editor().name("val1").create();
        Column val2 = Column.editor().name("val2").create();
        Table table = Table.editor().tableId(new TableId(null, "s1", "table1")).addColumn(pk1).addColumn(pk2).addColumn(val1).addColumn(val2).setPrimaryKeyNames(new String[]{"pk1", "pk2"}).create();
        context.addDataCollectionNamesToSnapshot(List.of(table.id().toString()), Optional.empty(), Optional.of("pk2"));
        Assertions.assertThat((String)source.buildChunkQuery(table, Optional.empty())).isEqualTo((Object)"SELECT * FROM \"s1\".\"table1\" ORDER BY \"pk2\" LIMIT 1024");
    }

    @Test
    public void testMaxQuery() {
        SignalBasedIncrementalSnapshotChangeEventSource source = new SignalBasedIncrementalSnapshotChangeEventSource(this.config(), new JdbcConnection(this.config().getJdbcConfig(), config -> null, "\"", "\""), null, null, null, SnapshotProgressListener.NO_OP(), DataChangeEventListener.NO_OP(), this.notificationService);
        Column pk1 = Column.editor().name("pk1").create();
        Column pk2 = Column.editor().name("pk2").create();
        Column val1 = Column.editor().name("val1").create();
        Column val2 = Column.editor().name("val2").create();
        Table table = Table.editor().tableId(new TableId(null, "s1", "table1")).addColumn(pk1).addColumn(pk2).addColumn(val1).addColumn(val2).setPrimaryKeyNames(new String[]{"pk1", "pk2"}).create();
        Assertions.assertThat((String)source.buildMaxPrimaryKeyQuery(table, Optional.empty())).isEqualTo((Object)"SELECT * FROM \"s1\".\"table1\" ORDER BY \"pk1\" DESC, \"pk2\" DESC LIMIT 1");
    }

    @Test
    public void testMaxQueryWithAdditionalCondition() {
        SignalBasedIncrementalSnapshotChangeEventSource source = new SignalBasedIncrementalSnapshotChangeEventSource(this.config(), new JdbcConnection(this.config().getJdbcConfig(), config -> null, "\"", "\""), null, null, null, SnapshotProgressListener.NO_OP(), DataChangeEventListener.NO_OP(), this.notificationService);
        Column pk1 = Column.editor().name("pk1").create();
        Column pk2 = Column.editor().name("pk2").create();
        Column val1 = Column.editor().name("val1").create();
        Column val2 = Column.editor().name("val2").create();
        Table table = Table.editor().tableId(new TableId(null, "s1", "table1")).addColumn(pk1).addColumn(pk2).addColumn(val1).addColumn(val2).setPrimaryKeyNames(new String[]{"pk1", "pk2"}).create();
        Assertions.assertThat((String)source.buildMaxPrimaryKeyQuery(table, Optional.of("\"val1\"=foo"))).isEqualTo((Object)"SELECT * FROM \"s1\".\"table1\" WHERE \"val1\"=foo ORDER BY \"pk1\" DESC, \"pk2\" DESC LIMIT 1");
    }

    @Test
    public void testMaxQueryWithSurrogateKey() {
        SignalBasedIncrementalSnapshotChangeEventSource source = new SignalBasedIncrementalSnapshotChangeEventSource(this.config(), new JdbcConnection(this.config().getJdbcConfig(), config -> null, "\"", "\""), null, null, null, SnapshotProgressListener.NO_OP(), DataChangeEventListener.NO_OP(), this.notificationService);
        SignalBasedIncrementalSnapshotContext context = new SignalBasedIncrementalSnapshotContext();
        source.setContext((IncrementalSnapshotContext)context);
        Column pk1 = Column.editor().name("pk1").create();
        Column pk2 = Column.editor().name("pk2").create();
        Column val1 = Column.editor().name("val1").create();
        Column val2 = Column.editor().name("val2").create();
        Table table = Table.editor().tableId(new TableId(null, "s1", "table1")).addColumn(pk1).addColumn(pk2).addColumn(val1).addColumn(val2).setPrimaryKeyNames(new String[]{"pk1", "pk2"}).create();
        context.addDataCollectionNamesToSnapshot(List.of(table.id().toString()), Optional.empty(), Optional.of("pk2"));
        Assertions.assertThat((String)source.buildMaxPrimaryKeyQuery(table, Optional.empty())).isEqualTo((Object)"SELECT * FROM \"s1\".\"table1\" ORDER BY \"pk2\" DESC LIMIT 1");
    }

    @Test
    @FixFor(value={"DBZ-5727"})
    public void testBuildProjectionWithColumnIncludeList() {
        RelationalDatabaseConnectorConfig config = this.buildConfig(((Configuration.Builder)this.config().getJdbcConfig().edit().with(RelationalDatabaseConnectorConfig.COLUMN_INCLUDE_LIST, ".*\\.(pk1|pk2|val1|val2)$")).build());
        SignalBasedIncrementalSnapshotChangeEventSource source = new SignalBasedIncrementalSnapshotChangeEventSource(config, new JdbcConnection(config.getJdbcConfig(), c -> null, "\"", "\""), null, null, null, SnapshotProgressListener.NO_OP(), DataChangeEventListener.NO_OP(), this.notificationService);
        SignalBasedIncrementalSnapshotContext context = new SignalBasedIncrementalSnapshotContext();
        source.setContext((IncrementalSnapshotContext)context);
        String actualProjection = source.buildChunkQuery(this.createTwoPrimaryKeysTable(), Optional.empty());
        String expectedProjection = "SELECT \"pk1\", \"pk2\", \"val1\", \"val2\" FROM \"s1\".\"table1\" ORDER BY \"pk1\", \"pk2\" LIMIT 1024";
        Assertions.assertThat((String)actualProjection).isEqualTo((Object)expectedProjection);
    }

    @Test
    @FixFor(value={"DBZ-5727"})
    public void testBuildProjectionWithColumnExcludeList() {
        RelationalDatabaseConnectorConfig config = this.buildConfig(((Configuration.Builder)this.config().getJdbcConfig().edit().with(RelationalDatabaseConnectorConfig.COLUMN_EXCLUDE_LIST, ".*\\.(pk2|val3)$")).build());
        SignalBasedIncrementalSnapshotChangeEventSource source = new SignalBasedIncrementalSnapshotChangeEventSource(config, new JdbcConnection(config.getJdbcConfig(), c -> null, "\"", "\""), null, null, null, SnapshotProgressListener.NO_OP(), DataChangeEventListener.NO_OP(), this.notificationService);
        SignalBasedIncrementalSnapshotContext context = new SignalBasedIncrementalSnapshotContext();
        source.setContext((IncrementalSnapshotContext)context);
        String actualProjection = source.buildChunkQuery(this.createTwoPrimaryKeysTable(), Optional.empty());
        String expectedProjection = "SELECT \"pk1\", \"val1\", \"val2\" FROM \"s1\".\"table1\" ORDER BY \"pk1\", \"pk2\" LIMIT 1024";
        Assertions.assertThat((String)actualProjection).isEqualTo((Object)expectedProjection);
    }

    private Table createTwoPrimaryKeysTable() {
        Column pk1 = Column.editor().name("pk1").create();
        Column pk2 = Column.editor().name("pk2").create();
        Column val1 = Column.editor().name("val1").create();
        Column val2 = Column.editor().name("val2").create();
        Column val3 = Column.editor().name("val3").create();
        Table table = Table.editor().tableId(new TableId(null, "s1", "table1")).addColumn(pk1).addColumn(pk2).addColumn(val1).addColumn(val2).addColumn(val3).setPrimaryKeyNames(new String[]{"pk1", "pk2"}).create();
        return table;
    }
}

