/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.relational.ddl;

import io.debezium.relational.TableId;
import io.debezium.relational.ddl.DdlChanges;
import io.debezium.relational.ddl.DdlParserListener;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.assertj.core.api.Assertions;

public class SimpleDdlParserListener
extends DdlChanges
implements DdlParserListener {
    private final AtomicLong counter = new AtomicLong();

    public DdlChanges reset() {
        super.reset();
        this.counter.set(0L);
        return this;
    }

    public void handle(DdlParserListener.Event event) {
        super.handle(event);
        this.counter.incrementAndGet();
    }

    public int total() {
        return this.counter.intValue();
    }

    public int remaining() {
        return this.events.size();
    }

    public void assertNoMoreEvents() {
        Assertions.assertThat((boolean)this.events.isEmpty()).isTrue();
    }

    public EventAssert assertNext() {
        Assertions.assertThat((boolean)this.events.isEmpty()).isFalse();
        return new EventAssert((DdlParserListener.Event)this.events.remove(0));
    }

    public void forEach(Consumer<DdlParserListener.Event> eventConsumer) {
        this.events.forEach(eventConsumer);
    }

    public static final class EventAssert {
        private final DdlParserListener.Event actual;

        public EventAssert(DdlParserListener.Event actual) {
            this.actual = actual;
        }

        public EventAssert ddlMatches(String expected) {
            Assertions.assertThat((String)this.actual.statement()).isEqualTo((Object)expected);
            return this;
        }

        public EventAssert ddlStartsWith(String expected) {
            Assertions.assertThat((String)this.actual.statement()).startsWith((CharSequence)expected);
            return this;
        }

        public EventAssert ddlContains(String expected) {
            Assertions.assertThat((String)this.actual.statement()).contains(new CharSequence[]{expected});
            return this;
        }

        protected DdlParserListener.TableEvent tableEvent() {
            Assertions.assertThat((Object)this.actual).isInstanceOf(DdlParserListener.TableEvent.class);
            return (DdlParserListener.TableEvent)this.actual;
        }

        protected DdlParserListener.TableAlteredEvent alterTableEvent() {
            Assertions.assertThat((Object)this.actual).isInstanceOf(DdlParserListener.TableAlteredEvent.class);
            return (DdlParserListener.TableAlteredEvent)this.actual;
        }

        public EventAssert tableNameIs(String expected) {
            Assertions.assertThat((String)this.tableEvent().tableId().table()).isEqualTo((Object)expected);
            return this;
        }

        public EventAssert tableIs(TableId expected) {
            Assertions.assertThat((Comparable)this.tableEvent().tableId()).isEqualTo((Object)expected);
            return this;
        }

        public EventAssert ofType(DdlParserListener.EventType expected) {
            Assertions.assertThat((Comparable)this.actual.type()).isEqualTo((Object)expected);
            return this;
        }

        public EventAssert createTableNamed(String tableName) {
            return this.createTable().tableNameIs(tableName).isNotView();
        }

        public EventAssert alterTableNamed(String tableName) {
            return this.alterTable().tableNameIs(tableName).isNotView();
        }

        public EventAssert truncateTableNamed(String tableName) {
            return this.truncateTable().tableNameIs(tableName).isNotView();
        }

        public EventAssert renamedFrom(String oldName) {
            TableId previousTableId = this.alterTableEvent().previousTableId();
            if (oldName == null) {
                Assertions.assertThat((Comparable)previousTableId).isNull();
            } else {
                Assertions.assertThat((String)previousTableId.table()).isEqualTo((Object)oldName);
            }
            return this;
        }

        public EventAssert dropTableNamed(String tableName) {
            return this.dropTable().tableNameIs(tableName).isNotView();
        }

        public EventAssert createViewNamed(String viewName) {
            return this.createTable().tableNameIs(viewName).isView();
        }

        public EventAssert alterViewNamed(String viewName) {
            return this.alterTable().tableNameIs(viewName).isView();
        }

        public EventAssert dropViewNamed(String viewName) {
            return this.dropTable().tableNameIs(viewName).isView();
        }

        public EventAssert isView() {
            Assertions.assertThat((boolean)this.tableEvent().isView()).isTrue();
            return this;
        }

        public EventAssert isNotView() {
            Assertions.assertThat((boolean)this.tableEvent().isView()).isFalse();
            return this;
        }

        public EventAssert createTable() {
            this.ofType(DdlParserListener.EventType.CREATE_TABLE);
            return this;
        }

        public EventAssert alterTable() {
            this.ofType(DdlParserListener.EventType.ALTER_TABLE);
            return this;
        }

        public EventAssert dropTable() {
            this.ofType(DdlParserListener.EventType.DROP_TABLE);
            return this;
        }

        public EventAssert createIndex() {
            this.ofType(DdlParserListener.EventType.CREATE_INDEX);
            return this;
        }

        public EventAssert dropIndex() {
            this.ofType(DdlParserListener.EventType.DROP_INDEX);
            return this;
        }

        public EventAssert truncateTable() {
            this.ofType(DdlParserListener.EventType.TRUNCATE_TABLE);
            return this;
        }
    }
}

