/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jetty;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import io.dropwizard.jetty.BiDiGzipFilter;
import io.dropwizard.util.Size;
import java.util.Set;
import java.util.regex.Pattern;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

public class GzipFilterFactory {
    private boolean enabled = true;
    @NotNull
    private Size minimumEntitySize = Size.bytes((long)256L);
    @NotNull
    private Size bufferSize = Size.kilobytes((long)8L);
    private Set<String> excludedUserAgents = Sets.newHashSet();
    private Set<Pattern> excludedUserAgentPatterns = Sets.newHashSet();
    private Set<String> compressedMimeTypes = Sets.newHashSet();
    private Set<String> includedMethods = Sets.newHashSet();
    private boolean gzipCompatibleDeflation = true;
    private String vary = "Accept-Encoding";
    @Min(value=-1L)
    @Max(value=9L)
    private int deflateCompressionLevel = -1;

    @JsonProperty
    public boolean isEnabled() {
        return this.enabled;
    }

    @JsonProperty
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @JsonProperty
    public Size getMinimumEntitySize() {
        return this.minimumEntitySize;
    }

    @JsonProperty
    public void setMinimumEntitySize(Size size) {
        this.minimumEntitySize = (Size)Preconditions.checkNotNull((Object)size);
    }

    @JsonProperty
    public Size getBufferSize() {
        return this.bufferSize;
    }

    @JsonProperty
    public void setBufferSize(Size size) {
        this.bufferSize = (Size)Preconditions.checkNotNull((Object)size);
    }

    @JsonProperty
    public Set<String> getExcludedUserAgents() {
        return this.excludedUserAgents;
    }

    @JsonProperty
    public void setExcludedUserAgents(Set<String> userAgents) {
        this.excludedUserAgents = userAgents;
    }

    @JsonProperty
    public Set<String> getCompressedMimeTypes() {
        return this.compressedMimeTypes;
    }

    @JsonProperty
    public void setCompressedMimeTypes(Set<String> mimeTypes) {
        this.compressedMimeTypes = mimeTypes;
    }

    @JsonProperty
    public int getDeflateCompressionLevel() {
        return this.deflateCompressionLevel;
    }

    @JsonProperty
    public void setDeflateCompressionLevel(int level) {
        this.deflateCompressionLevel = level;
    }

    @JsonProperty
    public boolean isGzipCompatibleDeflation() {
        return this.gzipCompatibleDeflation;
    }

    @JsonProperty
    public void setGzipCompatibleDeflation(boolean compatible) {
        this.gzipCompatibleDeflation = compatible;
    }

    @JsonProperty
    public Set<Pattern> getExcludedUserAgentPatterns() {
        return this.excludedUserAgentPatterns;
    }

    @JsonProperty
    public void setExcludedUserAgentPatterns(Set<Pattern> patterns) {
        this.excludedUserAgentPatterns = patterns;
    }

    @JsonProperty
    public Set<String> getIncludedMethods() {
        return this.includedMethods;
    }

    @JsonProperty
    public void setIncludedMethods(Set<String> methods) {
        this.includedMethods = methods;
    }

    @JsonProperty
    public String getVary() {
        return this.vary;
    }

    @JsonProperty
    public void setVary(String vary) {
        this.vary = vary;
    }

    public BiDiGzipFilter build() {
        BiDiGzipFilter filter = new BiDiGzipFilter();
        filter.setMinGzipSize((int)this.minimumEntitySize.toBytes());
        filter.setBufferSize((int)this.bufferSize.toBytes());
        filter.setDeflateCompressionLevel(this.deflateCompressionLevel);
        if (this.excludedUserAgents != null) {
            filter.setExcludedAgents(this.excludedUserAgents);
        }
        if (this.compressedMimeTypes != null) {
            filter.setMimeTypes(this.compressedMimeTypes);
        }
        if (this.includedMethods != null) {
            filter.setMethods(this.includedMethods);
        }
        if (this.excludedUserAgentPatterns != null) {
            filter.setExcludedAgentPatterns(this.excludedUserAgentPatterns);
        }
        if (this.vary != null) {
            filter.setVary(this.vary);
        }
        filter.setDeflateNoWrap(this.gzipCompatibleDeflation);
        return filter;
    }
}

