/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jetty;

import com.codahale.metrics.MetricRegistry;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.dropwizard.jetty.ConnectorFactory;
import io.dropwizard.jetty.Jetty93InstrumentedConnectionFactory;
import io.dropwizard.util.Duration;
import io.dropwizard.util.Size;
import io.dropwizard.util.SizeUnit;
import io.dropwizard.validation.MinDuration;
import io.dropwizard.validation.MinSize;
import io.dropwizard.validation.PortRange;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.eclipse.jetty.io.ArrayByteBufferPool;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.ForwardedRequestCustomizer;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.util.thread.ScheduledExecutorScheduler;
import org.eclipse.jetty.util.thread.Scheduler;
import org.eclipse.jetty.util.thread.ThreadPool;

@JsonTypeName(value="http")
public class HttpConnectorFactory
implements ConnectorFactory {
    @PortRange
    private int port = 8080;
    private String bindHost = null;
    private boolean inheritChannel = false;
    @NotNull
    @MinSize(value=128L)
    private Size headerCacheSize = Size.bytes((long)512L);
    @NotNull
    @MinSize(value=8L, unit=SizeUnit.KILOBYTES)
    private Size outputBufferSize = Size.kilobytes((long)32L);
    @NotNull
    @MinSize(value=1L, unit=SizeUnit.KILOBYTES)
    private Size maxRequestHeaderSize = Size.kilobytes((long)8L);
    @NotNull
    @MinSize(value=1L, unit=SizeUnit.KILOBYTES)
    private Size maxResponseHeaderSize = Size.kilobytes((long)8L);
    @NotNull
    @MinSize(value=1L, unit=SizeUnit.KILOBYTES)
    private Size inputBufferSize = Size.kilobytes((long)8L);
    @NotNull
    @MinDuration(value=1L, unit=TimeUnit.MILLISECONDS)
    private Duration idleTimeout = Duration.seconds((long)30L);
    @NotNull
    @MinSize(value=1L, unit=SizeUnit.BYTES)
    private Size minBufferPoolSize = Size.bytes((long)64L);
    @NotNull
    @MinSize(value=1L, unit=SizeUnit.BYTES)
    private Size bufferPoolIncrement = Size.bytes((long)1024L);
    @NotNull
    @MinSize(value=1L, unit=SizeUnit.BYTES)
    private Size maxBufferPoolSize = Size.kilobytes((long)64L);
    @Min(value=1L)
    private int acceptorThreads = Math.max(1, Runtime.getRuntime().availableProcessors() / 2);
    @Min(value=1L)
    private int selectorThreads = Runtime.getRuntime().availableProcessors();
    @Min(value=0L)
    private Integer acceptQueueSize;
    private boolean reuseAddress = true;
    private Duration soLingerTime = null;
    private boolean useServerHeader = false;
    private boolean useDateHeader = true;
    private boolean useForwardedHeaders = true;

    public static ConnectorFactory application() {
        HttpConnectorFactory factory = new HttpConnectorFactory();
        factory.port = 8080;
        return factory;
    }

    public static ConnectorFactory admin() {
        HttpConnectorFactory factory = new HttpConnectorFactory();
        factory.port = 8081;
        return factory;
    }

    @JsonProperty
    public int getPort() {
        return this.port;
    }

    @JsonProperty
    public void setPort(int port) {
        this.port = port;
    }

    @JsonProperty
    public String getBindHost() {
        return this.bindHost;
    }

    @JsonProperty
    public void setBindHost(String bindHost) {
        this.bindHost = bindHost;
    }

    @JsonProperty
    public boolean isInheritChannel() {
        return this.inheritChannel;
    }

    @JsonProperty
    public void setInheritChannel(boolean inheritChannel) {
        this.inheritChannel = inheritChannel;
    }

    @JsonProperty
    public Size getHeaderCacheSize() {
        return this.headerCacheSize;
    }

    @JsonProperty
    public void setHeaderCacheSize(Size headerCacheSize) {
        this.headerCacheSize = headerCacheSize;
    }

    @JsonProperty
    public Size getOutputBufferSize() {
        return this.outputBufferSize;
    }

    @JsonProperty
    public void setOutputBufferSize(Size outputBufferSize) {
        this.outputBufferSize = outputBufferSize;
    }

    @JsonProperty
    public Size getMaxRequestHeaderSize() {
        return this.maxRequestHeaderSize;
    }

    @JsonProperty
    public void setMaxRequestHeaderSize(Size maxRequestHeaderSize) {
        this.maxRequestHeaderSize = maxRequestHeaderSize;
    }

    @JsonProperty
    public Size getMaxResponseHeaderSize() {
        return this.maxResponseHeaderSize;
    }

    @JsonProperty
    public void setMaxResponseHeaderSize(Size maxResponseHeaderSize) {
        this.maxResponseHeaderSize = maxResponseHeaderSize;
    }

    @JsonProperty
    public Size getInputBufferSize() {
        return this.inputBufferSize;
    }

    @JsonProperty
    public void setInputBufferSize(Size inputBufferSize) {
        this.inputBufferSize = inputBufferSize;
    }

    @JsonProperty
    public Duration getIdleTimeout() {
        return this.idleTimeout;
    }

    @JsonProperty
    public void setIdleTimeout(Duration idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    @JsonProperty
    public Size getMinBufferPoolSize() {
        return this.minBufferPoolSize;
    }

    @JsonProperty
    public void setMinBufferPoolSize(Size minBufferPoolSize) {
        this.minBufferPoolSize = minBufferPoolSize;
    }

    @JsonProperty
    public Size getBufferPoolIncrement() {
        return this.bufferPoolIncrement;
    }

    @JsonProperty
    public void setBufferPoolIncrement(Size bufferPoolIncrement) {
        this.bufferPoolIncrement = bufferPoolIncrement;
    }

    @JsonProperty
    public Size getMaxBufferPoolSize() {
        return this.maxBufferPoolSize;
    }

    @JsonProperty
    public void setMaxBufferPoolSize(Size maxBufferPoolSize) {
        this.maxBufferPoolSize = maxBufferPoolSize;
    }

    @JsonProperty
    public int getAcceptorThreads() {
        return this.acceptorThreads;
    }

    @JsonProperty
    public void setAcceptorThreads(int acceptorThreads) {
        this.acceptorThreads = acceptorThreads;
    }

    @JsonProperty
    public int getSelectorThreads() {
        return this.selectorThreads;
    }

    @JsonProperty
    public void setSelectorThreads(int selectorThreads) {
        this.selectorThreads = selectorThreads;
    }

    @JsonProperty
    public Integer getAcceptQueueSize() {
        return this.acceptQueueSize;
    }

    @JsonProperty
    public void setAcceptQueueSize(Integer acceptQueueSize) {
        this.acceptQueueSize = acceptQueueSize;
    }

    @JsonProperty
    public boolean isReuseAddress() {
        return this.reuseAddress;
    }

    @JsonProperty
    public void setReuseAddress(boolean reuseAddress) {
        this.reuseAddress = reuseAddress;
    }

    @JsonProperty
    public Duration getSoLingerTime() {
        return this.soLingerTime;
    }

    @JsonProperty
    public void setSoLingerTime(Duration soLingerTime) {
        this.soLingerTime = soLingerTime;
    }

    @JsonProperty
    public boolean isUseServerHeader() {
        return this.useServerHeader;
    }

    @JsonProperty
    public void setUseServerHeader(boolean useServerHeader) {
        this.useServerHeader = useServerHeader;
    }

    @JsonProperty
    public boolean isUseDateHeader() {
        return this.useDateHeader;
    }

    @JsonProperty
    public void setUseDateHeader(boolean useDateHeader) {
        this.useDateHeader = useDateHeader;
    }

    @JsonProperty
    public boolean isUseForwardedHeaders() {
        return this.useForwardedHeaders;
    }

    @JsonProperty
    public void setUseForwardedHeaders(boolean useForwardedHeaders) {
        this.useForwardedHeaders = useForwardedHeaders;
    }

    @Override
    public Connector build(Server server, MetricRegistry metrics, String name, ThreadPool threadPool) {
        HttpConfiguration httpConfig = this.buildHttpConfiguration();
        HttpConnectionFactory httpConnectionFactory = this.buildHttpConnectionFactory(httpConfig);
        ScheduledExecutorScheduler scheduler = new ScheduledExecutorScheduler();
        ByteBufferPool bufferPool = this.buildBufferPool();
        return this.buildConnector(server, (Scheduler)scheduler, bufferPool, name, threadPool, new Jetty93InstrumentedConnectionFactory((ConnectionFactory)httpConnectionFactory, metrics.timer(this.httpConnections())));
    }

    protected String httpConnections() {
        return MetricRegistry.name(HttpConnectionFactory.class, (String[])new String[]{this.bindHost, Integer.toString(this.port), "connections"});
    }

    protected ServerConnector buildConnector(Server server, Scheduler scheduler, ByteBufferPool bufferPool, String name, ThreadPool threadPool, ConnectionFactory ... factories) {
        ServerConnector connector = new ServerConnector(server, (Executor)threadPool, scheduler, bufferPool, this.acceptorThreads, this.selectorThreads, factories);
        connector.setPort(this.port);
        connector.setHost(this.bindHost);
        connector.setInheritChannel(this.inheritChannel);
        if (this.acceptQueueSize != null) {
            connector.setAcceptQueueSize(this.acceptQueueSize.intValue());
        }
        connector.setReuseAddress(this.reuseAddress);
        if (this.soLingerTime != null) {
            connector.setSoLingerTime((int)this.soLingerTime.toSeconds());
        }
        connector.setIdleTimeout(this.idleTimeout.toMilliseconds());
        connector.setName(name);
        return connector;
    }

    protected HttpConnectionFactory buildHttpConnectionFactory(HttpConfiguration httpConfig) {
        HttpConnectionFactory httpConnectionFactory = new HttpConnectionFactory(httpConfig);
        httpConnectionFactory.setInputBufferSize((int)this.inputBufferSize.toBytes());
        return httpConnectionFactory;
    }

    protected HttpConfiguration buildHttpConfiguration() {
        HttpConfiguration httpConfig = new HttpConfiguration();
        httpConfig.setHeaderCacheSize((int)this.headerCacheSize.toBytes());
        httpConfig.setOutputBufferSize((int)this.outputBufferSize.toBytes());
        httpConfig.setRequestHeaderSize((int)this.maxRequestHeaderSize.toBytes());
        httpConfig.setResponseHeaderSize((int)this.maxResponseHeaderSize.toBytes());
        httpConfig.setSendDateHeader(this.useDateHeader);
        httpConfig.setSendServerVersion(this.useServerHeader);
        if (this.useForwardedHeaders) {
            httpConfig.addCustomizer((HttpConfiguration.Customizer)new ForwardedRequestCustomizer());
        }
        return httpConfig;
    }

    protected ByteBufferPool buildBufferPool() {
        return new ArrayByteBufferPool((int)this.minBufferPoolSize.toBytes(), (int)this.bufferPoolIncrement.toBytes(), (int)this.maxBufferPoolSize.toBytes());
    }
}

