/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.lifecycle.setup;

import com.codahale.metrics.InstrumentedThreadFactory;
import io.dropwizard.lifecycle.ExecutorServiceManager;
import io.dropwizard.lifecycle.setup.LifecycleEnvironment;
import io.dropwizard.util.Duration;
import java.util.Locale;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutorServiceBuilder {
    private static Logger log = LoggerFactory.getLogger(ExecutorServiceBuilder.class);
    private static final AtomicLong COUNT = new AtomicLong(0L);
    private final LifecycleEnvironment environment;
    @Nonnull
    private final String nameFormat;
    private int corePoolSize;
    private int maximumPoolSize;
    private boolean allowCoreThreadTimeOut;
    private Duration keepAliveTime;
    private Duration shutdownTime;
    private BlockingQueue<Runnable> workQueue;
    private ThreadFactory threadFactory;
    private RejectedExecutionHandler handler;

    public ExecutorServiceBuilder(LifecycleEnvironment environment, String nameFormat, ThreadFactory factory) {
        this.environment = environment;
        this.nameFormat = nameFormat;
        this.corePoolSize = 0;
        this.maximumPoolSize = 1;
        this.allowCoreThreadTimeOut = false;
        this.keepAliveTime = Duration.seconds((long)60L);
        this.shutdownTime = Duration.seconds((long)5L);
        this.workQueue = new LinkedBlockingQueue<Runnable>();
        this.threadFactory = factory;
        this.handler = new ThreadPoolExecutor.AbortPolicy();
    }

    public ExecutorServiceBuilder(LifecycleEnvironment environment, String nameFormat) {
        this(environment, nameFormat, ExecutorServiceBuilder.buildThreadFactory(nameFormat));
    }

    private static ThreadFactory buildThreadFactory(String nameFormat) {
        ThreadFactory defaultThreadFactory = Executors.defaultThreadFactory();
        String.format(Locale.ROOT, nameFormat, 0);
        return r -> {
            Thread thread = defaultThreadFactory.newThread(r);
            thread.setName(String.format(Locale.ROOT, nameFormat, COUNT.incrementAndGet()));
            return thread;
        };
    }

    public ExecutorServiceBuilder minThreads(int threads) {
        this.corePoolSize = threads;
        return this;
    }

    public ExecutorServiceBuilder maxThreads(int threads) {
        this.maximumPoolSize = threads;
        return this;
    }

    public ExecutorServiceBuilder allowCoreThreadTimeOut(boolean allowCoreThreadTimeOut) {
        this.allowCoreThreadTimeOut = allowCoreThreadTimeOut;
        return this;
    }

    public ExecutorServiceBuilder keepAliveTime(Duration time) {
        this.keepAliveTime = time;
        return this;
    }

    public ExecutorServiceBuilder shutdownTime(Duration time) {
        this.shutdownTime = time;
        return this;
    }

    public ExecutorServiceBuilder workQueue(BlockingQueue<Runnable> workQueue) {
        this.workQueue = workQueue;
        return this;
    }

    public ExecutorServiceBuilder rejectedExecutionHandler(RejectedExecutionHandler handler) {
        this.handler = handler;
        return this;
    }

    public ExecutorServiceBuilder threadFactory(ThreadFactory threadFactory) {
        this.threadFactory = threadFactory;
        return this;
    }

    public ExecutorService build() {
        if (this.corePoolSize != this.maximumPoolSize && this.maximumPoolSize > 1 && !this.isBoundedQueue()) {
            log.warn("Parameter 'maximumPoolSize' is conflicting with unbounded work queues");
        }
        String nameWithoutFormat = ExecutorServiceBuilder.getNameWithoutFormat(this.nameFormat);
        InstrumentedThreadFactory instrumentedThreadFactory = new InstrumentedThreadFactory(this.threadFactory, this.environment.getMetricRegistry(), nameWithoutFormat);
        ThreadPoolExecutor executor = new ThreadPoolExecutor(this.corePoolSize, this.maximumPoolSize, this.keepAliveTime.getQuantity(), this.keepAliveTime.getUnit(), this.workQueue, (ThreadFactory)instrumentedThreadFactory, this.handler);
        executor.allowCoreThreadTimeOut(this.allowCoreThreadTimeOut);
        this.environment.manage(new ExecutorServiceManager(executor, this.shutdownTime, this.nameFormat));
        return executor;
    }

    static String getNameWithoutFormat(String nameFormat) {
        String name = String.format(Locale.ROOT, nameFormat, 0);
        return ExecutorServiceBuilder.commonPrefixWithoutHyphen(name, nameFormat) + ExecutorServiceBuilder.commonSuffix(name, nameFormat);
    }

    static String commonPrefixWithoutHyphen(String name, String nameFormat) {
        int diffIndex;
        int minLength = Math.min(name.length(), nameFormat.length());
        for (diffIndex = 0; diffIndex < minLength && name.charAt(diffIndex) == nameFormat.charAt(diffIndex); ++diffIndex) {
        }
        if (diffIndex > 0 && name.charAt(diffIndex - 1) == '-') {
            --diffIndex;
        }
        return name.substring(0, diffIndex);
    }

    static String commonSuffix(String name, String nameFormat) {
        int nameIndex = name.length();
        int nameFormatIndex = nameFormat.length();
        while (--nameIndex >= 0 && --nameFormatIndex >= 0 && name.charAt(nameIndex) == nameFormat.charAt(nameFormatIndex)) {
        }
        return name.substring(nameIndex + 1);
    }

    private boolean isBoundedQueue() {
        return this.workQueue.remainingCapacity() != Integer.MAX_VALUE;
    }

    static synchronized void setLog(Logger newLog) {
        log = newLog;
    }
}

