/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.common.actions;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Throwables;
import io.druid.indexing.common.TaskLock;
import io.druid.indexing.common.actions.TaskAction;
import io.druid.indexing.common.actions.TaskActionToolbox;
import io.druid.indexing.common.task.Task;
import org.joda.time.Interval;

public class LockAcquireAction
implements TaskAction<TaskLock> {
    @JsonIgnore
    private final Interval interval;

    @JsonCreator
    public LockAcquireAction(@JsonProperty(value="interval") Interval interval) {
        this.interval = interval;
    }

    @JsonProperty
    public Interval getInterval() {
        return this.interval;
    }

    @Override
    public TypeReference<TaskLock> getReturnTypeReference() {
        return new TypeReference<TaskLock>(){};
    }

    @Override
    public TaskLock perform(Task task, TaskActionToolbox toolbox) {
        try {
            return toolbox.getTaskLockbox().lock(task, this.interval);
        }
        catch (InterruptedException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public boolean isAudited() {
        return false;
    }

    public String toString() {
        return "LockAcquireAction{interval=" + this.interval + '}';
    }
}

