/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.common.actions;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import com.metamx.http.client.HttpClient;
import io.druid.client.indexing.IndexingService;
import io.druid.curator.discovery.ServerDiscoverySelector;
import io.druid.guice.annotations.Global;
import io.druid.indexing.common.RetryPolicyFactory;
import io.druid.indexing.common.actions.RemoteTaskActionClient;
import io.druid.indexing.common.actions.TaskActionClient;
import io.druid.indexing.common.actions.TaskActionClientFactory;
import io.druid.indexing.common.task.Task;

public class RemoteTaskActionClientFactory
implements TaskActionClientFactory {
    private final HttpClient httpClient;
    private final ServerDiscoverySelector selector;
    private final RetryPolicyFactory retryPolicyFactory;
    private final ObjectMapper jsonMapper;

    @Inject
    public RemoteTaskActionClientFactory(@Global HttpClient httpClient, @IndexingService ServerDiscoverySelector selector, RetryPolicyFactory retryPolicyFactory, ObjectMapper jsonMapper) {
        this.httpClient = httpClient;
        this.selector = selector;
        this.retryPolicyFactory = retryPolicyFactory;
        this.jsonMapper = jsonMapper;
    }

    @Override
    public TaskActionClient create(Task task) {
        return new RemoteTaskActionClient(task, this.httpClient, this.selector, this.retryPolicyFactory, this.jsonMapper);
    }
}

