/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.common.actions;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.ImmutableSet;
import com.metamx.emitter.service.ServiceMetricEvent;
import io.druid.indexing.common.actions.TaskAction;
import io.druid.indexing.common.actions.TaskActionToolbox;
import io.druid.indexing.common.task.Task;
import io.druid.timeline.DataSegment;
import java.io.IOException;
import java.util.Set;

public class SegmentMetadataUpdateAction
implements TaskAction<Void> {
    @JsonIgnore
    private final Set<DataSegment> segments;

    @JsonCreator
    public SegmentMetadataUpdateAction(@JsonProperty(value="segments") Set<DataSegment> segments) {
        this.segments = ImmutableSet.copyOf(segments);
    }

    @JsonProperty
    public Set<DataSegment> getSegments() {
        return this.segments;
    }

    @Override
    public TypeReference<Void> getReturnTypeReference() {
        return new TypeReference<Void>(){};
    }

    @Override
    public Void perform(Task task, TaskActionToolbox toolbox) throws IOException {
        toolbox.verifyTaskLocksAndSinglePartitionSettitude(task, this.segments, true);
        toolbox.getIndexerMetadataStorageCoordinator().updateSegmentMetadata(this.segments);
        ServiceMetricEvent.Builder metricBuilder = new ServiceMetricEvent.Builder().setUser2(task.getDataSource()).setUser4(task.getType());
        for (DataSegment segment : this.segments) {
            metricBuilder.setUser5(segment.getInterval().toString());
            toolbox.getEmitter().emit(metricBuilder.build("indexer/segmentMoved/bytes", (Number)segment.getSize()));
        }
        return null;
    }

    @Override
    public boolean isAudited() {
        return true;
    }

    public String toString() {
        return "SegmentMetadataUpdateAction{segments=" + this.segments + '}';
    }
}

