/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.common.config;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.List;

public class TaskConfig {
    public static final List<String> DEFAULT_DEFAULT_HADOOP_COORDINATES = ImmutableList.of((Object)"org.apache.hadoop:hadoop-client:2.3.0");
    @JsonProperty
    private final String baseDir;
    @JsonProperty
    private final File baseTaskDir;
    @JsonProperty
    private final String hadoopWorkingPath;
    @JsonProperty
    private final int defaultRowFlushBoundary;
    @JsonProperty
    private final List<String> defaultHadoopCoordinates;

    @JsonCreator
    public TaskConfig(@JsonProperty(value="baseDir") String baseDir, @JsonProperty(value="baseTaskDir") String baseTaskDir, @JsonProperty(value="hadoopWorkingPath") String hadoopWorkingPath, @JsonProperty(value="defaultRowFlushBoundary") Integer defaultRowFlushBoundary, @JsonProperty(value="defaultHadoopCoordinates") List<String> defaultHadoopCoordinates) {
        this.baseDir = baseDir == null ? "/tmp" : baseDir;
        this.baseTaskDir = new File(this.defaultDir(baseTaskDir, "persistent/task"));
        this.hadoopWorkingPath = this.defaultDir(hadoopWorkingPath, "druid-indexing");
        this.defaultRowFlushBoundary = defaultRowFlushBoundary == null ? 500000 : defaultRowFlushBoundary;
        this.defaultHadoopCoordinates = defaultHadoopCoordinates == null ? DEFAULT_DEFAULT_HADOOP_COORDINATES : defaultHadoopCoordinates;
    }

    @JsonProperty
    public String getBaseDir() {
        return this.baseDir;
    }

    @JsonProperty
    public File getBaseTaskDir() {
        return this.baseTaskDir;
    }

    @JsonProperty
    public String getHadoopWorkingPath() {
        return this.hadoopWorkingPath;
    }

    @JsonProperty
    public int getDefaultRowFlushBoundary() {
        return this.defaultRowFlushBoundary;
    }

    @JsonProperty
    public List<String> getDefaultHadoopCoordinates() {
        return this.defaultHadoopCoordinates;
    }

    private String defaultDir(String configParameter, String defaultVal) {
        if (configParameter == null) {
            return String.format("%s/%s", this.getBaseDir(), defaultVal);
        }
        return configParameter;
    }
}

