/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.common.task;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.Injector;
import com.metamx.common.logger.Logger;
import io.druid.common.utils.JodaUtils;
import io.druid.guice.ExtensionsConfig;
import io.druid.guice.GuiceInjectors;
import io.druid.indexer.HadoopDruidDetermineConfigurationJob;
import io.druid.indexer.HadoopDruidIndexerConfig;
import io.druid.indexer.HadoopDruidIndexerJob;
import io.druid.indexer.HadoopIngestionSpec;
import io.druid.indexer.MetadataStorageUpdaterJobHandler;
import io.druid.indexing.common.TaskLock;
import io.druid.indexing.common.TaskStatus;
import io.druid.indexing.common.TaskToolbox;
import io.druid.indexing.common.actions.LockAcquireAction;
import io.druid.indexing.common.actions.LockTryAcquireAction;
import io.druid.indexing.common.actions.TaskActionClient;
import io.druid.indexing.common.task.AbstractTask;
import io.druid.initialization.Initialization;
import io.druid.timeline.DataSegment;
import io.tesla.aether.TeslaAether;
import io.tesla.aether.internal.DefaultTeslaAether;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.joda.time.DateTime;
import org.joda.time.Interval;

public class HadoopIndexTask
extends AbstractTask {
    private static final Logger log = new Logger(HadoopIndexTask.class);
    private static final ExtensionsConfig extensionsConfig;
    static final Injector injector;
    @JsonIgnore
    private final HadoopIngestionSpec spec;
    @JsonIgnore
    private final List<String> hadoopDependencyCoordinates;
    @JsonIgnore
    private final String classpathPrefix;

    private static String getTheDataSource(HadoopIngestionSpec spec) {
        return spec.getDataSchema().getDataSource();
    }

    @JsonCreator
    public HadoopIndexTask(@JsonProperty(value="id") String id, @JsonProperty(value="spec") HadoopIngestionSpec spec, @JsonProperty(value="hadoopCoordinates") String hadoopCoordinates, @JsonProperty(value="hadoopDependencyCoordinates") List<String> hadoopDependencyCoordinates, @JsonProperty(value="classpathPrefix") String classpathPrefix) {
        super(id != null ? id : String.format("index_hadoop_%s_%s", HadoopIndexTask.getTheDataSource(spec), new DateTime()), HadoopIndexTask.getTheDataSource(spec));
        this.spec = spec;
        Preconditions.checkArgument((this.spec.getIOConfig().getSegmentOutputPath() == null ? 1 : 0) != 0, (Object)"segmentOutputPath must be absent");
        Preconditions.checkArgument((this.spec.getTuningConfig().getWorkingPath() == null ? 1 : 0) != 0, (Object)"workingPath must be absent");
        Preconditions.checkArgument((this.spec.getIOConfig().getMetadataUpdateSpec() == null ? 1 : 0) != 0, (Object)"metadataUpdateSpec must be absent");
        this.hadoopDependencyCoordinates = hadoopDependencyCoordinates != null ? hadoopDependencyCoordinates : (hadoopCoordinates != null ? ImmutableList.of((Object)hadoopCoordinates) : null);
        this.classpathPrefix = classpathPrefix;
    }

    @Override
    public String getType() {
        return "index_hadoop";
    }

    @Override
    public boolean isReady(TaskActionClient taskActionClient) throws Exception {
        Optional intervals = this.spec.getDataSchema().getGranularitySpec().bucketIntervals();
        if (intervals.isPresent()) {
            Interval interval = JodaUtils.umbrellaInterval((Iterable)JodaUtils.condenseIntervals((Iterable)((Iterable)intervals.get())));
            return taskActionClient.submit(new LockTryAcquireAction(interval)).isPresent();
        }
        return true;
    }

    @JsonProperty(value="spec")
    public HadoopIngestionSpec getSpec() {
        return this.spec;
    }

    @JsonProperty
    public List<String> getHadoopDependencyCoordinates() {
        return this.hadoopDependencyCoordinates;
    }

    @Override
    @JsonProperty
    public String getClasspathPrefix() {
        return this.classpathPrefix;
    }

    @Override
    public TaskStatus run(TaskToolbox toolbox) throws Exception {
        String version;
        List<String> finalHadoopDependencyCoordinates = this.hadoopDependencyCoordinates != null ? this.hadoopDependencyCoordinates : toolbox.getConfig().getDefaultHadoopCoordinates();
        DefaultTeslaAether aetherClient = Initialization.getAetherClient((ExtensionsConfig)extensionsConfig);
        ArrayList extensionURLs = Lists.newArrayList();
        for (String coordinate : extensionsConfig.getCoordinates()) {
            URLClassLoader coordinateLoader = Initialization.getClassLoaderForCoordinates((TeslaAether)aetherClient, (String)coordinate, (String)extensionsConfig.getDefaultVersion());
            extensionURLs.addAll(Arrays.asList(coordinateLoader.getURLs()));
        }
        ArrayList nonHadoopURLs = Lists.newArrayList();
        nonHadoopURLs.addAll(Arrays.asList(((URLClassLoader)HadoopIndexTask.class.getClassLoader()).getURLs()));
        ArrayList driverURLs = Lists.newArrayList();
        driverURLs.addAll(nonHadoopURLs);
        for (String hadoopDependencyCoordinate : finalHadoopDependencyCoordinates) {
            URLClassLoader hadoopLoader = Initialization.getClassLoaderForCoordinates((TeslaAether)aetherClient, (String)hadoopDependencyCoordinate, (String)extensionsConfig.getDefaultVersion());
            driverURLs.addAll(Arrays.asList(hadoopLoader.getURLs()));
        }
        URLClassLoader loader = new URLClassLoader(driverURLs.toArray(new URL[driverURLs.size()]), null);
        Thread.currentThread().setContextClassLoader(loader);
        ArrayList jobUrls = Lists.newArrayList();
        jobUrls.addAll(nonHadoopURLs);
        jobUrls.addAll(extensionURLs);
        System.setProperty("druid.hadoop.internal.classpath", Joiner.on((String)File.pathSeparator).join((Iterable)jobUrls));
        boolean determineIntervals = !this.spec.getDataSchema().getGranularitySpec().bucketIntervals().isPresent();
        Class<?> determineConfigurationMainClass = loader.loadClass(HadoopDetermineConfigInnerProcessing.class.getName());
        Method determineConfigurationMainMethod = determineConfigurationMainClass.getMethod("runTask", String[].class);
        String[] determineConfigArgs = new String[]{toolbox.getObjectMapper().writeValueAsString((Object)this.spec), toolbox.getConfig().getHadoopWorkingPath(), toolbox.getSegmentPusher().getPathForHadoop(this.getDataSource())};
        String config = (String)determineConfigurationMainMethod.invoke(null, new Object[]{determineConfigArgs});
        HadoopIngestionSpec indexerSchema = (HadoopIngestionSpec)toolbox.getObjectMapper().readValue(config, HadoopIngestionSpec.class);
        if (determineIntervals) {
            Interval interval = JodaUtils.umbrellaInterval((Iterable)JodaUtils.condenseIntervals((Iterable)((Iterable)indexerSchema.getDataSchema().getGranularitySpec().bucketIntervals().get())));
            TaskLock lock = toolbox.getTaskActionClient().submit(new LockAcquireAction(interval));
            version = lock.getVersion();
        } else {
            Iterable<TaskLock> locks = this.getTaskLocks(toolbox);
            TaskLock myLock = (TaskLock)Iterables.getOnlyElement(locks);
            version = myLock.getVersion();
        }
        log.info("Setting version to: %s", new Object[]{version});
        Class<?> indexGeneratorMainClass = loader.loadClass(HadoopIndexGeneratorInnerProcessing.class.getName());
        Method indexGeneratorMainMethod = indexGeneratorMainClass.getMethod("runTask", String[].class);
        String[] indexGeneratorArgs = new String[]{toolbox.getObjectMapper().writeValueAsString((Object)indexerSchema), version};
        String segments = (String)indexGeneratorMainMethod.invoke(null, new Object[]{indexGeneratorArgs});
        if (segments != null) {
            List publishedSegments = (List)toolbox.getObjectMapper().readValue(segments, (TypeReference)new TypeReference<List<DataSegment>>(){});
            toolbox.pushSegments(publishedSegments);
            return TaskStatus.success(this.getId());
        }
        return TaskStatus.failure(this.getId());
    }

    static {
        injector = GuiceInjectors.makeStartupInjector();
        extensionsConfig = (ExtensionsConfig)injector.getInstance(ExtensionsConfig.class);
    }

    public static class HadoopDetermineConfigInnerProcessing {
        public static String runTask(String[] args) throws Exception {
            String schema = args[0];
            String workingPath = args[1];
            String segmentOutputPath = args[2];
            HadoopIngestionSpec theSchema = (HadoopIngestionSpec)HadoopDruidIndexerConfig.jsonMapper.readValue(schema, HadoopIngestionSpec.class);
            HadoopDruidIndexerConfig config = HadoopDruidIndexerConfig.fromSpec((HadoopIngestionSpec)theSchema.withIOConfig(theSchema.getIOConfig().withSegmentOutputPath(segmentOutputPath)).withTuningConfig(theSchema.getTuningConfig().withWorkingPath(workingPath)));
            HadoopDruidDetermineConfigurationJob job = new HadoopDruidDetermineConfigurationJob(config);
            log.info("Starting a hadoop determine configuration job...", new Object[0]);
            if (job.run()) {
                return HadoopDruidIndexerConfig.jsonMapper.writeValueAsString((Object)config.getSchema());
            }
            return null;
        }
    }

    public static class HadoopIndexGeneratorInnerProcessing {
        public static String runTask(String[] args) throws Exception {
            String schema = args[0];
            String version = args[1];
            HadoopIngestionSpec theSchema = (HadoopIngestionSpec)HadoopDruidIndexerConfig.jsonMapper.readValue(schema, HadoopIngestionSpec.class);
            HadoopDruidIndexerConfig config = HadoopDruidIndexerConfig.fromSpec((HadoopIngestionSpec)theSchema.withTuningConfig(theSchema.getTuningConfig().withVersion(version)));
            MetadataStorageUpdaterJobHandler maybeHandler = config.isUpdaterJobSpecSet() ? (MetadataStorageUpdaterJobHandler)injector.getInstance(MetadataStorageUpdaterJobHandler.class) : null;
            HadoopDruidIndexerJob job = new HadoopDruidIndexerJob(config, maybeHandler);
            log.info("Starting a hadoop index generator job...", new Object[0]);
            if (job.run()) {
                return HadoopDruidIndexerConfig.jsonMapper.writeValueAsString((Object)job.getPublishedSegments());
            }
            return null;
        }
    }
}

