/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.common.task;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Function;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import io.druid.indexing.common.task.MergeTaskBase;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.segment.IndexIO;
import io.druid.segment.IndexMerger;
import io.druid.segment.QueryableIndex;
import io.druid.timeline.DataSegment;
import java.io.File;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class MergeTask
extends MergeTaskBase {
    @JsonIgnore
    private final List<AggregatorFactory> aggregators;

    @JsonCreator
    public MergeTask(@JsonProperty(value="id") String id, @JsonProperty(value="dataSource") String dataSource, @JsonProperty(value="segments") List<DataSegment> segments, @JsonProperty(value="aggregations") List<AggregatorFactory> aggregators) {
        super(id, dataSource, segments);
        this.aggregators = aggregators;
    }

    @Override
    public File merge(Map<DataSegment, File> segments, File outDir) throws Exception {
        return IndexMerger.mergeQueryableIndex((List)Lists.transform((List)ImmutableList.copyOf(segments.values()), (Function)new Function<File, QueryableIndex>(){

            public QueryableIndex apply(@Nullable File input) {
                try {
                    return IndexIO.loadIndex((File)input);
                }
                catch (Exception e) {
                    throw Throwables.propagate((Throwable)e);
                }
            }
        }), (AggregatorFactory[])this.aggregators.toArray(new AggregatorFactory[this.aggregators.size()]), (File)outDir);
    }

    @Override
    public String getType() {
        return "merge";
    }

    @JsonProperty(value="aggregations")
    public List<AggregatorFactory> getAggregators() {
        return this.aggregators;
    }
}

