/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.overlord;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import io.druid.guice.annotations.Self;
import io.druid.indexing.common.config.TaskConfig;
import io.druid.indexing.overlord.ForkingTaskRunner;
import io.druid.indexing.overlord.TaskRunner;
import io.druid.indexing.overlord.TaskRunnerFactory;
import io.druid.indexing.overlord.config.ForkingTaskRunnerConfig;
import io.druid.indexing.worker.config.WorkerConfig;
import io.druid.server.DruidNode;
import io.druid.tasklogs.TaskLogPusher;
import java.util.Properties;

public class ForkingTaskRunnerFactory
implements TaskRunnerFactory {
    private final ForkingTaskRunnerConfig config;
    private final TaskConfig taskConfig;
    private final WorkerConfig workerConfig;
    private final Properties props;
    private final ObjectMapper jsonMapper;
    private final TaskLogPusher persistentTaskLogs;
    private final DruidNode node;

    @Inject
    public ForkingTaskRunnerFactory(ForkingTaskRunnerConfig config, TaskConfig taskConfig, WorkerConfig workerConfig, Properties props, ObjectMapper jsonMapper, TaskLogPusher persistentTaskLogs, @Self DruidNode node) {
        this.config = config;
        this.taskConfig = taskConfig;
        this.workerConfig = workerConfig;
        this.props = props;
        this.jsonMapper = jsonMapper;
        this.persistentTaskLogs = persistentTaskLogs;
        this.node = node;
    }

    @Override
    public TaskRunner build() {
        return new ForkingTaskRunner(this.config, this.taskConfig, this.workerConfig, this.props, this.persistentTaskLogs, this.jsonMapper, this.node);
    }
}

