/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.overlord;

import com.google.common.collect.ImmutableSet;
import io.druid.indexing.common.task.Task;
import io.druid.indexing.worker.Worker;
import java.util.Set;

public class ImmutableZkWorker {
    private final Worker worker;
    private final int currCapacityUsed;
    private final ImmutableSet<String> availabilityGroups;

    public ImmutableZkWorker(Worker worker, int currCapacityUsed, Set<String> availabilityGroups) {
        this.worker = worker;
        this.currCapacityUsed = currCapacityUsed;
        this.availabilityGroups = ImmutableSet.copyOf(availabilityGroups);
    }

    public Worker getWorker() {
        return this.worker;
    }

    public int getCurrCapacityUsed() {
        return this.currCapacityUsed;
    }

    public Set<String> getAvailabilityGroups() {
        return this.availabilityGroups;
    }

    public boolean isValidVersion(String minVersion) {
        return this.worker.getVersion().compareTo(minVersion) >= 0;
    }

    public boolean canRunTask(Task task) {
        return this.worker.getCapacity() - this.getCurrCapacityUsed() >= task.getTaskResource().getRequiredCapacity() && !this.getAvailabilityGroups().contains(task.getTaskResource().getAvailabilityGroup());
    }
}

