/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.overlord;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.metamx.common.Pair;
import com.metamx.common.lifecycle.LifecycleStart;
import com.metamx.common.lifecycle.LifecycleStop;
import com.metamx.emitter.EmittingLogger;
import io.druid.indexing.common.TaskLock;
import io.druid.indexing.common.TaskStatus;
import io.druid.indexing.common.actions.TaskAction;
import io.druid.indexing.common.config.TaskStorageConfig;
import io.druid.indexing.common.task.Task;
import io.druid.indexing.overlord.TaskStorage;
import io.druid.metadata.EntryExistsException;
import io.druid.metadata.MetadataStorageActionHandler;
import io.druid.metadata.MetadataStorageActionHandlerFactory;
import io.druid.metadata.MetadataStorageActionHandlerTypes;
import io.druid.metadata.MetadataStorageConnector;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.joda.time.ReadableDuration;

public class MetadataTaskStorage
implements TaskStorage {
    private static final MetadataStorageActionHandlerTypes<Task, TaskStatus, TaskAction, TaskLock> TASK_TYPES = new MetadataStorageActionHandlerTypes<Task, TaskStatus, TaskAction, TaskLock>(){

        public TypeReference<Task> getEntryType() {
            return new TypeReference<Task>(){};
        }

        public TypeReference<TaskStatus> getStatusType() {
            return new TypeReference<TaskStatus>(){};
        }

        public TypeReference<TaskAction> getLogType() {
            return new TypeReference<TaskAction>(){};
        }

        public TypeReference<TaskLock> getLockType() {
            return new TypeReference<TaskLock>(){};
        }
    };
    private final MetadataStorageConnector metadataStorageConnector;
    private final TaskStorageConfig config;
    private final MetadataStorageActionHandler<Task, TaskStatus, TaskAction, TaskLock> handler;
    private static final EmittingLogger log = new EmittingLogger(MetadataTaskStorage.class);

    @Inject
    public MetadataTaskStorage(MetadataStorageConnector metadataStorageConnector, TaskStorageConfig config, MetadataStorageActionHandlerFactory factory) {
        this.metadataStorageConnector = metadataStorageConnector;
        this.config = config;
        this.handler = factory.create("task", TASK_TYPES);
    }

    @LifecycleStart
    public void start() {
        this.metadataStorageConnector.createTaskTables();
    }

    @LifecycleStop
    public void stop() {
    }

    @Override
    public void insert(Task task, TaskStatus status) throws EntryExistsException {
        Preconditions.checkNotNull((Object)task, (Object)"task");
        Preconditions.checkNotNull((Object)status, (Object)"status");
        Preconditions.checkArgument((boolean)task.getId().equals(status.getId()), (String)"Task/Status ID mismatch[%s/%s]", (Object[])new Object[]{task.getId(), status.getId()});
        log.info("Inserting task %s with status: %s", new Object[]{task.getId(), status});
        try {
            this.handler.insert(task.getId(), new DateTime(), task.getDataSource(), (Object)task, status.isRunnable(), (Object)status);
        }
        catch (Exception e) {
            if (e instanceof EntryExistsException) {
                throw (EntryExistsException)((Object)e);
            }
            Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public void setStatus(TaskStatus status) {
        Preconditions.checkNotNull((Object)status, (Object)"status");
        log.info("Updating task %s to status: %s", new Object[]{status.getId(), status});
        boolean set = this.handler.setStatus(status.getId(), status.isRunnable(), (Object)status);
        if (!set) {
            throw new IllegalStateException(String.format("Active task not found: %s", status.getId()));
        }
    }

    @Override
    public Optional<Task> getTask(String taskId) {
        return this.handler.getEntry(taskId);
    }

    @Override
    public Optional<TaskStatus> getStatus(String taskId) {
        return this.handler.getStatus(taskId);
    }

    @Override
    public List<Task> getActiveTasks() {
        return ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)Iterables.filter((Iterable)this.handler.getActiveEntriesWithStatus(), (Predicate)new Predicate<Pair<Task, TaskStatus>>(){

            public boolean apply(@Nullable Pair<Task, TaskStatus> input) {
                return ((TaskStatus)input.rhs).isRunnable();
            }
        }), (Function)new Function<Pair<Task, TaskStatus>, Task>(){

            @Nullable
            public Task apply(@Nullable Pair<Task, TaskStatus> input) {
                return (Task)input.lhs;
            }
        }));
    }

    @Override
    public List<TaskStatus> getRecentlyFinishedTaskStatuses() {
        DateTime start = new DateTime().minus((ReadableDuration)this.config.getRecentlyFinishedThreshold());
        return ImmutableList.copyOf((Iterable)Iterables.filter((Iterable)this.handler.getInactiveStatusesSince(start), (Predicate)new Predicate<TaskStatus>(){

            public boolean apply(TaskStatus status) {
                return status.isComplete();
            }
        }));
    }

    @Override
    public void addLock(String taskid, TaskLock taskLock) {
        Preconditions.checkNotNull((Object)taskid, (Object)"taskid");
        Preconditions.checkNotNull((Object)taskLock, (Object)"taskLock");
        log.info("Adding lock on interval[%s] version[%s] for task: %s", new Object[]{taskLock.getInterval(), taskLock.getVersion(), taskid});
        this.handler.addLock(taskid, (Object)taskLock);
    }

    @Override
    public void removeLock(String taskid, TaskLock taskLockToRemove) {
        Preconditions.checkNotNull((Object)taskid, (Object)"taskid");
        Preconditions.checkNotNull((Object)taskLockToRemove, (Object)"taskLockToRemove");
        Map<Long, TaskLock> taskLocks = this.getLocksWithIds(taskid);
        for (Map.Entry<Long, TaskLock> taskLockWithId : taskLocks.entrySet()) {
            long id = taskLockWithId.getKey();
            TaskLock taskLock = taskLockWithId.getValue();
            if (!taskLock.equals(taskLockToRemove)) continue;
            log.info("Deleting TaskLock with id[%d]: %s", new Object[]{id, taskLock});
            this.handler.removeLock(id);
        }
    }

    @Override
    public List<TaskLock> getLocks(String taskid) {
        return ImmutableList.copyOf((Iterable)Iterables.transform(this.getLocksWithIds(taskid).entrySet(), (Function)new Function<Map.Entry<Long, TaskLock>, TaskLock>(){

            public TaskLock apply(Map.Entry<Long, TaskLock> e) {
                return e.getValue();
            }
        }));
    }

    @Override
    public <T> void addAuditLog(Task task, TaskAction<T> taskAction) {
        Preconditions.checkNotNull(taskAction, (Object)"taskAction");
        log.info("Logging action for task[%s]: %s", new Object[]{task.getId(), taskAction});
        this.handler.addLog(task.getId(), taskAction);
    }

    @Override
    public List<TaskAction> getAuditLogs(String taskId) {
        return this.handler.getLogs(taskId);
    }

    private Map<Long, TaskLock> getLocksWithIds(String taskid) {
        return this.handler.getLocks(taskid);
    }
}

