/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.overlord;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Supplier;
import com.google.inject.Inject;
import com.metamx.http.client.HttpClient;
import io.druid.curator.cache.PathChildrenCacheFactory;
import io.druid.curator.cache.SimplePathChildrenCacheFactory;
import io.druid.guice.annotations.Global;
import io.druid.indexing.overlord.RemoteTaskRunner;
import io.druid.indexing.overlord.TaskRunner;
import io.druid.indexing.overlord.TaskRunnerFactory;
import io.druid.indexing.overlord.config.RemoteTaskRunnerConfig;
import io.druid.indexing.overlord.setup.WorkerBehaviorConfig;
import io.druid.server.initialization.IndexerZkConfig;
import org.apache.curator.framework.CuratorFramework;

public class RemoteTaskRunnerFactory
implements TaskRunnerFactory {
    private final CuratorFramework curator;
    private final RemoteTaskRunnerConfig remoteTaskRunnerConfig;
    private final IndexerZkConfig zkPaths;
    private final ObjectMapper jsonMapper;
    private final HttpClient httpClient;
    private final Supplier<WorkerBehaviorConfig> workerConfigRef;

    @Inject
    public RemoteTaskRunnerFactory(CuratorFramework curator, RemoteTaskRunnerConfig remoteTaskRunnerConfig, IndexerZkConfig zkPaths, ObjectMapper jsonMapper, @Global HttpClient httpClient, Supplier<WorkerBehaviorConfig> workerConfigRef) {
        this.curator = curator;
        this.remoteTaskRunnerConfig = remoteTaskRunnerConfig;
        this.zkPaths = zkPaths;
        this.jsonMapper = jsonMapper;
        this.httpClient = httpClient;
        this.workerConfigRef = workerConfigRef;
    }

    @Override
    public TaskRunner build() {
        return new RemoteTaskRunner(this.jsonMapper, this.remoteTaskRunnerConfig, this.zkPaths, this.curator, (PathChildrenCacheFactory)new SimplePathChildrenCacheFactory.Builder().withCompressed(true).build(), this.httpClient, this.workerConfigRef);
    }
}

