/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.overlord;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.metamx.common.Pair;
import com.metamx.common.guava.Comparators;
import com.metamx.common.guava.FunctionalIterable;
import com.metamx.emitter.EmittingLogger;
import io.druid.indexing.common.TaskLock;
import io.druid.indexing.common.task.Task;
import io.druid.indexing.overlord.TaskStorage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;

public class TaskLockbox {
    private final Map<String, NavigableMap<Interval, TaskLockPosse>> running = Maps.newHashMap();
    private final TaskStorage taskStorage;
    private final ReentrantLock giant = new ReentrantLock();
    private final Condition lockReleaseCondition = this.giant.newCondition();
    private static final EmittingLogger log = new EmittingLogger(TaskLockbox.class);

    @Inject
    public TaskLockbox(TaskStorage taskStorage) {
        this.taskStorage = taskStorage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncFromStorage() {
        this.giant.lock();
        try {
            ArrayList storedLocks = Lists.newArrayList();
            for (Task task : this.taskStorage.getActiveTasks()) {
                for (TaskLock taskLock : this.taskStorage.getLocks(task.getId())) {
                    storedLocks.add(Pair.of((Object)task, (Object)taskLock));
                }
            }
            Ordering<Pair<Task, TaskLock>> byVersionOrdering = new Ordering<Pair<Task, TaskLock>>(){

                public int compare(Pair<Task, TaskLock> left, Pair<Task, TaskLock> right) {
                    return ComparisonChain.start().compare((Comparable)((Object)((TaskLock)left.rhs).getVersion()), (Comparable)((Object)((TaskLock)right.rhs).getVersion())).compare((Comparable)((Object)((Task)left.lhs).getId()), (Comparable)((Object)((Task)right.lhs).getId())).result();
                }
            };
            this.running.clear();
            HashSet uniqueTaskIds = Sets.newHashSet();
            int taskLockCount = 0;
            for (Pair taskAndLock : byVersionOrdering.sortedCopy((Iterable)storedLocks)) {
                Task task = (Task)taskAndLock.lhs;
                TaskLock savedTaskLock = (TaskLock)taskAndLock.rhs;
                if (savedTaskLock.getInterval().toDurationMillis() <= 0L) {
                    log.warn("WTF?! Got lock with empty interval for task: %s", new Object[]{task.getId()});
                    continue;
                }
                uniqueTaskIds.add(task.getId());
                Optional<TaskLock> acquiredTaskLock = this.tryLock(task, savedTaskLock.getInterval(), (Optional<String>)Optional.of((Object)savedTaskLock.getVersion()));
                if (acquiredTaskLock.isPresent() && savedTaskLock.getVersion().equals(((TaskLock)acquiredTaskLock.get()).getVersion())) {
                    ++taskLockCount;
                    log.info("Reacquired lock on interval[%s] version[%s] for task: %s", new Object[]{savedTaskLock.getInterval(), savedTaskLock.getVersion(), task.getId()});
                    continue;
                }
                if (acquiredTaskLock.isPresent()) {
                    ++taskLockCount;
                    log.info("Could not reacquire lock on interval[%s] version[%s] (got version[%s] instead) for task: %s", new Object[]{savedTaskLock.getInterval(), savedTaskLock.getVersion(), ((TaskLock)acquiredTaskLock.get()).getVersion(), task.getId()});
                    continue;
                }
                log.info("Could not reacquire lock on interval[%s] version[%s] for task: %s", new Object[]{savedTaskLock.getInterval(), savedTaskLock.getVersion(), task.getId()});
            }
            log.info("Synced %,d locks for %,d tasks from storage (%,d locks ignored).", new Object[]{taskLockCount, uniqueTaskIds.size(), storedLocks.size() - taskLockCount});
        }
        finally {
            this.giant.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskLock lock(Task task, Interval interval) throws InterruptedException {
        this.giant.lock();
        try {
            Optional<TaskLock> taskLock;
            while (!(taskLock = this.tryLock(task, interval)).isPresent()) {
                this.lockReleaseCondition.await();
            }
            TaskLock taskLock2 = (TaskLock)taskLock.get();
            return taskLock2;
        }
        finally {
            this.giant.unlock();
        }
    }

    public Optional<TaskLock> tryLock(Task task, Interval interval) {
        return this.tryLock(task, interval, (Optional<String>)Optional.absent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private Optional<TaskLock> tryLock(Task task, Interval interval, Optional<String> preferredVersion) {
        this.giant.lock();
        try {
            String version;
            TaskLockPosse posseToUse;
            Preconditions.checkArgument((interval.toDurationMillis() > 0L ? 1 : 0) != 0, (Object)"interval empty");
            String dataSource = task.getDataSource();
            List<TaskLockPosse> foundPosses = this.findLockPossesForInterval(dataSource, interval);
            if (foundPosses.size() > 1) {
                Optional optional = Optional.absent();
                return optional;
            }
            if (foundPosses.size() == 1) {
                TaskLockPosse foundPosse = (TaskLockPosse)Iterables.getOnlyElement(foundPosses);
                if (!foundPosse.getTaskLock().getInterval().contains((ReadableInterval)interval) || !foundPosse.getTaskLock().getGroupId().equals(task.getGroupId())) {
                    Optional optional = Optional.absent();
                    return optional;
                }
                posseToUse = foundPosse;
            } else {
                if (!this.running.containsKey(dataSource)) {
                    this.running.put(dataSource, new TreeMap(Comparators.intervalsByStartThenEnd()));
                }
                version = preferredVersion.isPresent() ? (String)preferredVersion.get() : new DateTime().toString();
                posseToUse = new TaskLockPosse(new TaskLock(task.getGroupId(), dataSource, interval, version));
                this.running.get(dataSource).put(interval, posseToUse);
                log.info("Created new TaskLockPosse: %s", new Object[]{posseToUse});
            }
            if (posseToUse.getTaskIds().add(task.getId())) {
                log.info("Added task[%s] to TaskLock[%s]", new Object[]{task.getId(), posseToUse.getTaskLock().getGroupId()});
                try {
                    this.taskStorage.addLock(task.getId(), posseToUse.getTaskLock());
                    version = Optional.of((Object)posseToUse.getTaskLock());
                    return version;
                }
                catch (Exception e) {
                    log.makeAlert("Failed to persist lock in storage", new Object[0]).addData("task", (Object)task.getId()).addData("dataSource", (Object)posseToUse.getTaskLock().getDataSource()).addData("interval", (Object)posseToUse.getTaskLock().getInterval()).addData("version", (Object)posseToUse.getTaskLock().getVersion()).emit();
                    this.unlock(task, interval);
                    Optional optional = Optional.absent();
                    this.giant.unlock();
                    return optional;
                }
            }
            log.info("Task[%s] already present in TaskLock[%s]", new Object[]{task.getId(), posseToUse.getTaskLock().getGroupId()});
            Optional optional = Optional.of((Object)posseToUse.getTaskLock());
            return optional;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.giant.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TaskLock> findLocksForTask(Task task) {
        this.giant.lock();
        try {
            List list = Lists.transform(this.findLockPossesForTask(task), (Function)new Function<TaskLockPosse, TaskLock>(){

                public TaskLock apply(TaskLockPosse taskLockPosse) {
                    return taskLockPosse.getTaskLock();
                }
            });
            return list;
        }
        finally {
            this.giant.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock(Task task, Interval interval) {
        this.giant.lock();
        try {
            TaskLockPosse taskLockPosse;
            String dataSource = task.getDataSource();
            NavigableMap<Interval, TaskLockPosse> dsRunning = this.running.get(dataSource);
            boolean removed = false;
            if (dsRunning != null && (taskLockPosse = (TaskLockPosse)dsRunning.get(interval)) != null) {
                TaskLock taskLock = taskLockPosse.getTaskLock();
                log.info("Removing task[%s] from TaskLock[%s]", new Object[]{task.getId(), taskLock.getGroupId()});
                removed = taskLockPosse.getTaskIds().remove(task.getId());
                if (taskLockPosse.getTaskIds().isEmpty()) {
                    log.info("TaskLock is now empty: %s", new Object[]{taskLock});
                    this.running.get(dataSource).remove(taskLock.getInterval());
                }
                if (this.running.get(dataSource).size() == 0) {
                    this.running.remove(dataSource);
                }
                this.lockReleaseCondition.signalAll();
                try {
                    this.taskStorage.removeLock(task.getId(), taskLock);
                }
                catch (Exception e) {
                    log.makeAlert((Throwable)e, "Failed to clean up lock from storage", new Object[0]).addData("task", (Object)task.getId()).addData("dataSource", (Object)taskLock.getDataSource()).addData("interval", (Object)taskLock.getInterval()).addData("version", (Object)taskLock.getVersion()).emit();
                }
            }
            if (!removed) {
                log.makeAlert("Lock release without acquire", new Object[0]).addData("task", (Object)task.getId()).addData("interval", (Object)interval).emit();
            }
        }
        finally {
            this.giant.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock(Task task) {
        this.giant.lock();
        try {
            for (TaskLockPosse taskLockPosse : this.findLockPossesForTask(task)) {
                this.unlock(task, taskLockPosse.getTaskLock().getInterval());
            }
        }
        finally {
            this.giant.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<TaskLockPosse> findLockPossesForTask(final Task task) {
        this.giant.lock();
        try {
            NavigableMap<Interval, TaskLockPosse> dsRunning = this.running.get(task.getDataSource());
            Object searchSpace = dsRunning == null ? ImmutableList.of() : dsRunning.values();
            ImmutableList immutableList = ImmutableList.copyOf((Iterable)Iterables.filter((Iterable)searchSpace, (Predicate)new Predicate<TaskLockPosse>(){

                public boolean apply(TaskLockPosse taskLock) {
                    return taskLock.getTaskIds().contains(task.getId());
                }
            }));
            return immutableList;
        }
        finally {
            this.giant.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<TaskLockPosse> findLockPossesForInterval(String dataSource, final Interval interval) {
        this.giant.lock();
        try {
            final NavigableMap<Interval, TaskLockPosse> dsRunning = this.running.get(dataSource);
            if (dsRunning == null) {
                List<TaskLockPosse> list = Collections.emptyList();
                return list;
            }
            NavigableSet<Interval> dsLockbox = dsRunning.navigableKeySet();
            Iterable searchIntervals = Iterables.concat(Collections.singletonList(dsLockbox.floor(new Interval((ReadableInstant)interval.getStart(), (ReadableInstant)new DateTime(0x3FFFFFFFFFFFFFFFL)))), dsLockbox.subSet(new Interval((ReadableInstant)interval.getStart(), (ReadableInstant)new DateTime(0x3FFFFFFFFFFFFFFFL)), false, new Interval((ReadableInstant)interval.getEnd(), (ReadableInstant)interval.getEnd()), false));
            ArrayList arrayList = Lists.newArrayList((Iterable)FunctionalIterable.create((Iterable)searchIntervals).filter((Predicate)new Predicate<Interval>(){

                public boolean apply(@Nullable Interval searchInterval) {
                    return searchInterval != null && searchInterval.overlaps((ReadableInterval)interval);
                }
            }).transform((Function)new Function<Interval, TaskLockPosse>(){

                public TaskLockPosse apply(Interval interval) {
                    return (TaskLockPosse)dsRunning.get(interval);
                }
            }));
            return arrayList;
        }
        finally {
            this.giant.unlock();
        }
    }

    private static class TaskLockPosse {
        private final TaskLock taskLock;
        private final Set<String> taskIds;

        public TaskLockPosse(TaskLock taskLock) {
            this.taskLock = taskLock;
            this.taskIds = Sets.newHashSet();
        }

        public TaskLock getTaskLock() {
            return this.taskLock;
        }

        public Set<String> getTaskIds() {
            return this.taskIds;
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("taskLock", (Object)this.taskLock).add("taskIds", this.taskIds).toString();
        }
    }
}

