/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.overlord;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ComparisonChain;
import com.google.common.util.concurrent.ListenableFuture;
import io.druid.indexing.common.TaskStatus;
import java.util.Comparator;
import org.joda.time.DateTime;
import org.joda.time.DateTimeComparator;

public class TaskRunnerWorkItem
implements Comparable<TaskRunnerWorkItem> {
    private final String taskId;
    private final ListenableFuture<TaskStatus> result;
    private final DateTime createdTime;
    private final DateTime queueInsertionTime;

    public TaskRunnerWorkItem(String taskId, ListenableFuture<TaskStatus> result) {
        this(taskId, result, new DateTime(), new DateTime());
    }

    public TaskRunnerWorkItem(String taskId, ListenableFuture<TaskStatus> result, DateTime createdTime, DateTime queueInsertionTime) {
        this.taskId = taskId;
        this.result = result;
        this.createdTime = createdTime;
        this.queueInsertionTime = queueInsertionTime;
    }

    @JsonProperty
    public String getTaskId() {
        return this.taskId;
    }

    @JsonIgnore
    public ListenableFuture<TaskStatus> getResult() {
        return this.result;
    }

    @JsonProperty
    public DateTime getCreatedTime() {
        return this.createdTime;
    }

    @JsonProperty
    public DateTime getQueueInsertionTime() {
        return this.queueInsertionTime;
    }

    public TaskRunnerWorkItem withQueueInsertionTime(DateTime time) {
        return new TaskRunnerWorkItem(this.taskId, this.result, this.createdTime, time);
    }

    @Override
    public int compareTo(TaskRunnerWorkItem taskRunnerWorkItem) {
        return ComparisonChain.start().compare((Object)this.createdTime, (Object)taskRunnerWorkItem.getCreatedTime(), (Comparator)DateTimeComparator.getInstance()).compare((Comparable)((Object)this.taskId), (Comparable)((Object)taskRunnerWorkItem.getTaskId())).result();
    }

    public String toString() {
        return "TaskRunnerWorkItem{taskId='" + this.taskId + '\'' + ", result=" + this.result + ", createdTime=" + this.createdTime + ", queueInsertionTime=" + this.queueInsertionTime + '}';
    }
}

