/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.overlord;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.druid.indexing.overlord.ImmutableZkWorker;
import io.druid.indexing.worker.TaskAnnouncement;
import io.druid.indexing.worker.Worker;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.PathChildrenCache;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheListener;
import org.joda.time.DateTime;

public class ZkWorker
implements Closeable {
    private final PathChildrenCache statusCache;
    private final Function<ChildData, TaskAnnouncement> cacheConverter;
    private AtomicReference<Worker> worker;
    private AtomicReference<DateTime> lastCompletedTaskTime = new AtomicReference<DateTime>(new DateTime());

    public ZkWorker(Worker worker, PathChildrenCache statusCache, final ObjectMapper jsonMapper) {
        this.worker = new AtomicReference<Worker>(worker);
        this.statusCache = statusCache;
        this.cacheConverter = new Function<ChildData, TaskAnnouncement>(){

            public TaskAnnouncement apply(ChildData input) {
                try {
                    return (TaskAnnouncement)jsonMapper.readValue(input.getData(), TaskAnnouncement.class);
                }
                catch (Exception e) {
                    throw Throwables.propagate((Throwable)e);
                }
            }
        };
    }

    public void start() throws Exception {
        this.statusCache.start(PathChildrenCache.StartMode.POST_INITIALIZED_EVENT);
    }

    public void addListener(PathChildrenCacheListener listener) {
        this.statusCache.getListenable().addListener((Object)listener);
    }

    @JsonProperty(value="worker")
    public Worker getWorker() {
        return this.worker.get();
    }

    @JsonProperty(value="runningTasks")
    public Collection<String> getRunningTaskIds() {
        return this.getRunningTasks().keySet();
    }

    public Map<String, TaskAnnouncement> getRunningTasks() {
        HashMap retVal = Maps.newHashMap();
        for (TaskAnnouncement taskAnnouncement : Lists.transform((List)this.statusCache.getCurrentData(), this.cacheConverter)) {
            retVal.put(taskAnnouncement.getTaskStatus().getId(), taskAnnouncement);
        }
        return retVal;
    }

    @JsonProperty(value="currCapacityUsed")
    public int getCurrCapacityUsed() {
        int currCapacity = 0;
        for (TaskAnnouncement taskAnnouncement : this.getRunningTasks().values()) {
            currCapacity += taskAnnouncement.getTaskResource().getRequiredCapacity();
        }
        return currCapacity;
    }

    @JsonProperty(value="availabilityGroups")
    public Set<String> getAvailabilityGroups() {
        HashSet retVal = Sets.newHashSet();
        for (TaskAnnouncement taskAnnouncement : this.getRunningTasks().values()) {
            retVal.add(taskAnnouncement.getTaskResource().getAvailabilityGroup());
        }
        return retVal;
    }

    @JsonProperty
    public DateTime getLastCompletedTaskTime() {
        return this.lastCompletedTaskTime.get();
    }

    public boolean isRunningTask(String taskId) {
        return this.getRunningTasks().containsKey(taskId);
    }

    public boolean isValidVersion(String minVersion) {
        return this.worker.get().getVersion().compareTo(minVersion) >= 0;
    }

    public void setWorker(Worker newWorker) {
        Worker oldWorker = this.worker.get();
        Preconditions.checkArgument((boolean)newWorker.getHost().equals(oldWorker.getHost()), (Object)"Cannot change Worker host");
        Preconditions.checkArgument((boolean)newWorker.getIp().equals(oldWorker.getIp()), (Object)"Cannot change Worker ip");
        this.worker.set(newWorker);
    }

    public void setLastCompletedTaskTime(DateTime completedTaskTime) {
        this.lastCompletedTaskTime.set(completedTaskTime);
    }

    public ImmutableZkWorker toImmutable() {
        return new ImmutableZkWorker(this.worker.get(), this.getCurrCapacityUsed(), this.getAvailabilityGroups());
    }

    @Override
    public void close() throws IOException {
        this.statusCache.close();
    }

    public String toString() {
        return "ZkWorker{worker=" + this.worker + ", lastCompletedTaskTime=" + this.lastCompletedTaskTime + '}';
    }
}

