/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.overlord.autoscaling;

import com.metamx.common.concurrent.ScheduledExecutors;
import com.metamx.common.lifecycle.LifecycleStart;
import com.metamx.common.lifecycle.LifecycleStop;
import com.metamx.common.logger.Logger;
import io.druid.granularity.PeriodGranularity;
import io.druid.indexing.overlord.RemoteTaskRunner;
import io.druid.indexing.overlord.autoscaling.ResourceManagementSchedulerConfig;
import io.druid.indexing.overlord.autoscaling.ResourceManagementStrategy;
import io.druid.indexing.overlord.autoscaling.ScalingStats;
import java.util.concurrent.ScheduledExecutorService;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.Period;

public class ResourceManagementScheduler {
    private static final Logger log = new Logger(ResourceManagementScheduler.class);
    private final RemoteTaskRunner taskRunner;
    private final ResourceManagementStrategy resourceManagementStrategy;
    private final ResourceManagementSchedulerConfig config;
    private final ScheduledExecutorService exec;
    private final Object lock = new Object();
    private volatile boolean started = false;

    public ResourceManagementScheduler(RemoteTaskRunner taskRunner, ResourceManagementStrategy resourceManagementStrategy, ResourceManagementSchedulerConfig config, ScheduledExecutorService exec) {
        this.taskRunner = taskRunner;
        this.resourceManagementStrategy = resourceManagementStrategy;
        this.config = config;
        this.exec = exec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LifecycleStart
    public void start() {
        Object object = this.lock;
        synchronized (object) {
            if (this.started) {
                return;
            }
            log.info("Started Resource Management Scheduler", new Object[0]);
            ScheduledExecutors.scheduleAtFixedRate((ScheduledExecutorService)this.exec, (Duration)this.config.getProvisionPeriod().toStandardDuration(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    ResourceManagementScheduler.this.resourceManagementStrategy.doProvision(ResourceManagementScheduler.this.taskRunner.getPendingTasks(), ResourceManagementScheduler.this.taskRunner.getWorkers());
                }
            });
            Period period = this.config.getTerminatePeriod();
            PeriodGranularity granularity = new PeriodGranularity(period, this.config.getOriginTime(), null);
            long startTime = granularity.next(granularity.truncate(new DateTime().getMillis()));
            ScheduledExecutors.scheduleAtFixedRate((ScheduledExecutorService)this.exec, (Duration)new Duration(System.currentTimeMillis(), startTime), (Duration)this.config.getTerminatePeriod().toStandardDuration(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    ResourceManagementScheduler.this.resourceManagementStrategy.doTerminate(ResourceManagementScheduler.this.taskRunner.getPendingTasks(), ResourceManagementScheduler.this.taskRunner.getWorkers());
                }
            });
            this.started = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LifecycleStop
    public void stop() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.started) {
                return;
            }
            log.info("Stopping Resource Management Scheduler", new Object[0]);
            this.exec.shutdown();
            this.started = false;
        }
    }

    public ScalingStats getStats() {
        return this.resourceManagementStrategy.getStats();
    }
}

