/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.overlord.autoscaling;

import com.google.inject.Inject;
import com.metamx.common.concurrent.ScheduledExecutorFactory;
import io.druid.indexing.overlord.RemoteTaskRunner;
import io.druid.indexing.overlord.autoscaling.NoopResourceManagementScheduler;
import io.druid.indexing.overlord.autoscaling.ResourceManagementScheduler;
import io.druid.indexing.overlord.autoscaling.ResourceManagementSchedulerConfig;
import io.druid.indexing.overlord.autoscaling.ResourceManagementSchedulerFactory;
import io.druid.indexing.overlord.autoscaling.ResourceManagementStrategy;

public class ResourceManagementSchedulerFactoryImpl
implements ResourceManagementSchedulerFactory {
    private final ResourceManagementSchedulerConfig config;
    private final ResourceManagementStrategy strategy;

    @Inject
    public ResourceManagementSchedulerFactoryImpl(ResourceManagementStrategy strategy, ResourceManagementSchedulerConfig config, ScheduledExecutorFactory executorFactory) {
        this.config = config;
        this.strategy = strategy;
    }

    @Override
    public ResourceManagementScheduler build(RemoteTaskRunner runner, ScheduledExecutorFactory executorFactory) {
        if (this.config.isDoAutoscale()) {
            return new ResourceManagementScheduler(runner, this.strategy, this.config, executorFactory.create(1, "ScalingExec--%d"));
        }
        return new NoopResourceManagementScheduler();
    }
}

