/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.overlord.autoscaling;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.Collections2;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.metamx.common.ISE;
import com.metamx.emitter.EmittingLogger;
import io.druid.indexing.overlord.RemoteTaskRunnerWorkItem;
import io.druid.indexing.overlord.TaskRunnerWorkItem;
import io.druid.indexing.overlord.ZkWorker;
import io.druid.indexing.overlord.autoscaling.AutoScalingData;
import io.druid.indexing.overlord.autoscaling.ResourceManagementStrategy;
import io.druid.indexing.overlord.autoscaling.ScalingStats;
import io.druid.indexing.overlord.autoscaling.SimpleResourceManagementConfig;
import io.druid.indexing.overlord.setup.WorkerBehaviorConfig;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;

public class SimpleResourceManagementStrategy
implements ResourceManagementStrategy {
    private static final EmittingLogger log = new EmittingLogger(SimpleResourceManagementStrategy.class);
    private final SimpleResourceManagementConfig config;
    private final Supplier<WorkerBehaviorConfig> workerConfigRef;
    private final ScalingStats scalingStats;
    private final Object lock = new Object();
    private final Set<String> currentlyProvisioning = Sets.newHashSet();
    private final Set<String> currentlyTerminating = Sets.newHashSet();
    private int targetWorkerCount = -1;
    private DateTime lastProvisionTime = new DateTime();
    private DateTime lastTerminateTime = new DateTime();

    @Inject
    public SimpleResourceManagementStrategy(SimpleResourceManagementConfig config, Supplier<WorkerBehaviorConfig> workerConfigRef) {
        this.config = config;
        this.workerConfigRef = workerConfigRef;
        this.scalingStats = new ScalingStats(config.getNumEventsToTrack());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean doProvision(Collection<RemoteTaskRunnerWorkItem> pendingTasks, Collection<ZkWorker> zkWorkers) {
        Object object = this.lock;
        synchronized (object) {
            List<String> newNodes;
            AutoScalingData provisioned;
            boolean didProvision = false;
            WorkerBehaviorConfig workerConfig = (WorkerBehaviorConfig)this.workerConfigRef.get();
            if (workerConfig == null || workerConfig.getAutoScaler() == null) {
                log.warn("No workerConfig available, cannot provision new workers.", new Object[0]);
                return false;
            }
            Predicate<ZkWorker> isValidWorker = SimpleResourceManagementStrategy.createValidWorkerPredicate(this.config);
            int currValidWorkers = Collections2.filter(zkWorkers, isValidWorker).size();
            List<String> workerNodeIds = workerConfig.getAutoScaler().ipToIdLookup(Lists.newArrayList((Iterable)Iterables.transform(zkWorkers, (Function)new Function<ZkWorker, String>(){

                public String apply(ZkWorker input) {
                    return input.getWorker().getIp();
                }
            })));
            this.currentlyProvisioning.removeAll(workerNodeIds);
            this.updateTargetWorkerCount(workerConfig, pendingTasks, zkWorkers);
            for (int want = this.targetWorkerCount - (currValidWorkers + this.currentlyProvisioning.size()); want > 0 && (provisioned = workerConfig.getAutoScaler().provision()) != null && !(newNodes = provisioned.getNodeIds()).isEmpty(); want -= provisioned.getNodeIds().size()) {
                this.currentlyProvisioning.addAll(newNodes);
                this.lastProvisionTime = new DateTime();
                this.scalingStats.addProvisionEvent(provisioned);
                didProvision = true;
            }
            if (!this.currentlyProvisioning.isEmpty()) {
                Duration durSinceLastProvision = new Duration((ReadableInstant)this.lastProvisionTime, (ReadableInstant)new DateTime());
                log.info("%s provisioning. Current wait time: %s", new Object[]{this.currentlyProvisioning, durSinceLastProvision});
                if (durSinceLastProvision.isLongerThan((ReadableDuration)this.config.getMaxScalingDuration().toStandardDuration())) {
                    log.makeAlert("Worker node provisioning taking too long!", new Object[0]).addData("millisSinceLastProvision", (Object)durSinceLastProvision.getMillis()).addData("provisioningCount", (Object)this.currentlyProvisioning.size()).emit();
                    workerConfig.getAutoScaler().terminateWithIds(Lists.newArrayList(this.currentlyProvisioning));
                    this.currentlyProvisioning.clear();
                }
            }
            return didProvision;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean doTerminate(Collection<RemoteTaskRunnerWorkItem> pendingTasks, Collection<ZkWorker> zkWorkers) {
        Object object = this.lock;
        synchronized (object) {
            WorkerBehaviorConfig workerConfig = (WorkerBehaviorConfig)this.workerConfigRef.get();
            if (workerConfig == null) {
                log.warn("No workerConfig available, cannot terminate workers.", new Object[0]);
                return false;
            }
            boolean didTerminate = false;
            HashSet workerNodeIds = Sets.newHashSet(workerConfig.getAutoScaler().ipToIdLookup(Lists.newArrayList((Iterable)Iterables.transform(zkWorkers, (Function)new Function<ZkWorker, String>(){

                public String apply(ZkWorker input) {
                    return input.getWorker().getIp();
                }
            }))));
            HashSet stillExisting = Sets.newHashSet();
            for (String s : this.currentlyTerminating) {
                if (!workerNodeIds.contains(s)) continue;
                stillExisting.add(s);
            }
            this.currentlyTerminating.clear();
            this.currentlyTerminating.addAll(stillExisting);
            this.updateTargetWorkerCount(workerConfig, pendingTasks, zkWorkers);
            Predicate<ZkWorker> isLazyWorker = SimpleResourceManagementStrategy.createLazyWorkerPredicate(this.config);
            if (this.currentlyTerminating.isEmpty()) {
                int excessWorkers = zkWorkers.size() + this.currentlyProvisioning.size() - this.targetWorkerCount;
                if (excessWorkers > 0) {
                    ImmutableList laziestWorkerIps = FluentIterable.from(zkWorkers).filter(isLazyWorker).limit(excessWorkers).transform((Function)new Function<ZkWorker, String>(){

                        public String apply(ZkWorker zkWorker) {
                            return zkWorker.getWorker().getIp();
                        }
                    }).toList();
                    if (laziestWorkerIps.isEmpty()) {
                        log.info("Wanted to terminate %,d workers, but couldn't find any lazy ones!", new Object[]{excessWorkers});
                    } else {
                        log.info("Terminating %,d workers (wanted %,d): %s", new Object[]{laziestWorkerIps.size(), excessWorkers, Joiner.on((String)", ").join((Iterable)laziestWorkerIps)});
                        AutoScalingData terminated = workerConfig.getAutoScaler().terminate((List<String>)laziestWorkerIps);
                        if (terminated != null) {
                            this.currentlyTerminating.addAll(terminated.getNodeIds());
                            this.lastTerminateTime = new DateTime();
                            this.scalingStats.addTerminateEvent(terminated);
                            didTerminate = true;
                        }
                    }
                }
            } else {
                Duration durSinceLastTerminate = new Duration((ReadableInstant)this.lastTerminateTime, (ReadableInstant)new DateTime());
                log.info("%s terminating. Current wait time: %s", new Object[]{this.currentlyTerminating, durSinceLastTerminate});
                if (durSinceLastTerminate.isLongerThan((ReadableDuration)this.config.getMaxScalingDuration().toStandardDuration())) {
                    log.makeAlert("Worker node termination taking too long!", new Object[0]).addData("millisSinceLastTerminate", (Object)durSinceLastTerminate.getMillis()).addData("terminatingCount", (Object)this.currentlyTerminating.size()).emit();
                    this.currentlyTerminating.clear();
                }
            }
            return didTerminate;
        }
    }

    @Override
    public ScalingStats getStats() {
        return this.scalingStats;
    }

    private static Predicate<ZkWorker> createLazyWorkerPredicate(final SimpleResourceManagementConfig config) {
        final Predicate<ZkWorker> isValidWorker = SimpleResourceManagementStrategy.createValidWorkerPredicate(config);
        return new Predicate<ZkWorker>(){

            public boolean apply(ZkWorker worker) {
                boolean itHasBeenAWhile = System.currentTimeMillis() - worker.getLastCompletedTaskTime().getMillis() >= config.getWorkerIdleTimeout().toStandardDuration().getMillis();
                return worker.getRunningTasks().isEmpty() && (itHasBeenAWhile || !isValidWorker.apply((Object)worker));
            }
        };
    }

    private static Predicate<ZkWorker> createValidWorkerPredicate(final SimpleResourceManagementConfig config) {
        return new Predicate<ZkWorker>(){

            public boolean apply(ZkWorker zkWorker) {
                String minVersion = config.getWorkerVersion();
                if (minVersion == null) {
                    throw new ISE("No minVersion found! It should be set in your runtime properties or configuration database.", new Object[0]);
                }
                return zkWorker.isValidVersion(minVersion);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTargetWorkerCount(WorkerBehaviorConfig workerConfig, Collection<RemoteTaskRunnerWorkItem> pendingTasks, Collection<ZkWorker> zkWorkers) {
        Object object = this.lock;
        synchronized (object) {
            boolean shouldScaleDown;
            Collection validWorkers = Collections2.filter(zkWorkers, SimpleResourceManagementStrategy.createValidWorkerPredicate(this.config));
            Predicate<ZkWorker> isLazyWorker = SimpleResourceManagementStrategy.createLazyWorkerPredicate(this.config);
            int minWorkerCount = workerConfig.getAutoScaler().getMinNumWorkers();
            int maxWorkerCount = workerConfig.getAutoScaler().getMaxNumWorkers();
            if (minWorkerCount > maxWorkerCount) {
                log.error("Huh? minWorkerCount[%d] > maxWorkerCount[%d]. I give up!", new Object[]{minWorkerCount, maxWorkerCount});
                return;
            }
            if (this.targetWorkerCount < 0) {
                this.targetWorkerCount = Math.max(Math.min(zkWorkers.size(), maxWorkerCount), minWorkerCount);
                log.info("Starting with a target of %,d workers (current = %,d, min = %,d, max = %,d).", new Object[]{this.targetWorkerCount, validWorkers.size(), minWorkerCount, maxWorkerCount});
            }
            boolean notTakingActions = this.currentlyProvisioning.isEmpty() && this.currentlyTerminating.isEmpty();
            boolean shouldScaleUp = notTakingActions && validWorkers.size() >= this.targetWorkerCount && this.targetWorkerCount < maxWorkerCount && (this.hasTaskPendingBeyondThreshold(pendingTasks) || this.targetWorkerCount < minWorkerCount);
            boolean bl = shouldScaleDown = notTakingActions && validWorkers.size() == this.targetWorkerCount && this.targetWorkerCount > minWorkerCount && Iterables.any((Iterable)validWorkers, isLazyWorker);
            if (shouldScaleUp) {
                this.targetWorkerCount = Math.max(this.targetWorkerCount + 1, minWorkerCount);
                log.info("I think we should scale up to %,d workers (current = %,d, min = %,d, max = %,d).", new Object[]{this.targetWorkerCount, validWorkers.size(), minWorkerCount, maxWorkerCount});
            } else if (shouldScaleDown) {
                this.targetWorkerCount = Math.min(this.targetWorkerCount - 1, maxWorkerCount);
                log.info("I think we should scale down to %,d workers (current = %,d, min = %,d, max = %,d).", new Object[]{this.targetWorkerCount, validWorkers.size(), minWorkerCount, maxWorkerCount});
            } else {
                log.info("Our target is %,d workers, and I'm okay with that (current = %,d, min = %,d, max = %,d).", new Object[]{this.targetWorkerCount, validWorkers.size(), minWorkerCount, maxWorkerCount});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasTaskPendingBeyondThreshold(Collection<RemoteTaskRunnerWorkItem> pendingTasks) {
        Object object = this.lock;
        synchronized (object) {
            long now = System.currentTimeMillis();
            for (TaskRunnerWorkItem taskRunnerWorkItem : pendingTasks) {
                Duration timeoutDuration;
                Duration durationSinceInsertion = new Duration(taskRunnerWorkItem.getQueueInsertionTime().getMillis(), now);
                if (!durationSinceInsertion.isEqual((ReadableDuration)(timeoutDuration = this.config.getPendingTaskTimeout().toStandardDuration())) && !durationSinceInsertion.isLongerThan((ReadableDuration)timeoutDuration)) continue;
                return true;
            }
            return false;
        }
    }
}

