/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.overlord.setup;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.google.common.primitives.Ints;
import io.druid.indexing.common.task.Task;
import io.druid.indexing.overlord.ImmutableZkWorker;
import io.druid.indexing.overlord.config.RemoteTaskRunnerConfig;
import io.druid.indexing.overlord.setup.WorkerSelectStrategy;
import java.util.Comparator;
import java.util.TreeSet;

public class EqualDistributionWorkerSelectStrategy
implements WorkerSelectStrategy {
    @Override
    public Optional<ImmutableZkWorker> findWorkerForTask(RemoteTaskRunnerConfig config, ImmutableMap<String, ImmutableZkWorker> zkWorkers, Task task) {
        TreeSet sortedWorkers = Sets.newTreeSet((Comparator)new Comparator<ImmutableZkWorker>(){

            @Override
            public int compare(ImmutableZkWorker zkWorker, ImmutableZkWorker zkWorker2) {
                return -Ints.compare((int)zkWorker2.getCurrCapacityUsed(), (int)zkWorker.getCurrCapacityUsed());
            }
        });
        sortedWorkers.addAll(zkWorkers.values());
        String minWorkerVer = config.getMinWorkerVersion();
        for (ImmutableZkWorker zkWorker : sortedWorkers) {
            if (!zkWorker.canRunTask(task) || !zkWorker.isValidVersion(minWorkerVer)) continue;
            return Optional.of((Object)zkWorker);
        }
        return Optional.absent();
    }
}

