/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.worker.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.io.ByteSource;
import com.google.inject.Inject;
import com.metamx.common.logger.Logger;
import io.druid.indexing.overlord.ForkingTaskRunner;
import io.druid.indexing.overlord.TaskRunnerWorkItem;
import io.druid.indexing.worker.Worker;
import io.druid.indexing.worker.WorkerCuratorCoordinator;
import java.io.IOException;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="/druid/worker/v1")
public class WorkerResource {
    private static final Logger log = new Logger(WorkerResource.class);
    private static String DISABLED_VERSION = "";
    private final Worker enabledWorker;
    private final Worker disabledWorker;
    private final WorkerCuratorCoordinator curatorCoordinator;
    private final ForkingTaskRunner taskRunner;

    @Inject
    public WorkerResource(Worker worker, WorkerCuratorCoordinator curatorCoordinator, ForkingTaskRunner taskRunner) throws Exception {
        this.enabledWorker = worker;
        this.disabledWorker = new Worker(worker.getHost(), worker.getIp(), worker.getCapacity(), DISABLED_VERSION);
        this.curatorCoordinator = curatorCoordinator;
        this.taskRunner = taskRunner;
    }

    @POST
    @Path(value="/disable")
    @Produces(value={"application/json"})
    public Response doDisable() {
        try {
            this.curatorCoordinator.updateWorkerAnnouncement(this.disabledWorker);
            return Response.ok((Object)ImmutableMap.of((Object)this.disabledWorker.getHost(), (Object)"disabled")).build();
        }
        catch (Exception e) {
            return Response.serverError().build();
        }
    }

    @POST
    @Path(value="/enable")
    @Produces(value={"application/json"})
    public Response doEnable() {
        try {
            this.curatorCoordinator.updateWorkerAnnouncement(this.enabledWorker);
            return Response.ok((Object)ImmutableMap.of((Object)this.enabledWorker.getHost(), (Object)"enabled")).build();
        }
        catch (Exception e) {
            return Response.serverError().build();
        }
    }

    @GET
    @Path(value="/enabled")
    @Produces(value={"application/json"})
    public Response isEnabled() {
        try {
            Worker theWorker = this.curatorCoordinator.getWorker();
            boolean enabled = !theWorker.getVersion().equalsIgnoreCase(DISABLED_VERSION);
            return Response.ok((Object)ImmutableMap.of((Object)theWorker.getHost(), (Object)enabled)).build();
        }
        catch (Exception e) {
            return Response.serverError().build();
        }
    }

    @GET
    @Path(value="/tasks")
    @Produces(value={"application/json"})
    public Response getTasks() {
        try {
            return Response.ok((Object)Lists.newArrayList((Iterable)Collections2.transform(this.taskRunner.getKnownTasks(), (Function)new Function<TaskRunnerWorkItem, String>(){

                public String apply(TaskRunnerWorkItem input) {
                    return input.getTaskId();
                }
            }))).build();
        }
        catch (Exception e) {
            return Response.serverError().build();
        }
    }

    @POST
    @Path(value="/task/{taskid}/shutdown")
    @Produces(value={"application/json"})
    public Response doShutdown(@PathParam(value="taskid") String taskid) {
        try {
            this.taskRunner.shutdown(taskid);
        }
        catch (Exception e) {
            log.error((Throwable)e, "Failed to issue shutdown for task: %s", new Object[]{taskid});
            return Response.serverError().build();
        }
        return Response.ok((Object)ImmutableMap.of((Object)"task", (Object)taskid)).build();
    }

    @GET
    @Path(value="/task/{taskid}/log")
    @Produces(value={"text/plain"})
    public Response doGetLog(@PathParam(value="taskid") String taskid, @QueryParam(value="offset") @DefaultValue(value="0") long offset) {
        Optional<ByteSource> stream = this.taskRunner.streamTaskLog(taskid, offset);
        if (stream.isPresent()) {
            try {
                return Response.ok((Object)((ByteSource)stream.get()).openStream()).build();
            }
            catch (IOException e) {
                log.warn((Throwable)e, "Failed to read log for task: %s", new Object[]{taskid});
                return Response.serverError().build();
            }
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }
}

