/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.core.handler;

import io.fabric8.maven.core.handler.ContainerHandler;
import io.fabric8.maven.core.handler.DaemonSetHandler;
import io.fabric8.maven.core.handler.DeploymentConfigHandler;
import io.fabric8.maven.core.handler.DeploymentHandler;
import io.fabric8.maven.core.handler.JobHandler;
import io.fabric8.maven.core.handler.NamespaceHandler;
import io.fabric8.maven.core.handler.PodTemplateHandler;
import io.fabric8.maven.core.handler.ProbeHandler;
import io.fabric8.maven.core.handler.ProjectHandler;
import io.fabric8.maven.core.handler.ReplicaSetHandler;
import io.fabric8.maven.core.handler.ReplicationControllerHandler;
import io.fabric8.maven.core.handler.ServiceHandler;
import io.fabric8.maven.core.handler.StatefulSetHandler;
import io.fabric8.maven.core.model.GroupArtifactVersion;
import java.util.Properties;

public class HandlerHub {
    private final PodTemplateHandler podTemplateHandler;

    public HandlerHub(GroupArtifactVersion groupArtifactVersion, Properties configuration) {
        ProbeHandler probeHandler = new ProbeHandler();
        ContainerHandler containerHandler = new ContainerHandler(configuration, groupArtifactVersion, probeHandler);
        this.podTemplateHandler = new PodTemplateHandler(containerHandler);
    }

    public ServiceHandler getServiceHandler() {
        return new ServiceHandler();
    }

    public DeploymentHandler getDeploymentHandler() {
        return new DeploymentHandler(this.podTemplateHandler);
    }

    public DeploymentConfigHandler getDeploymentConfigHandler() {
        return new DeploymentConfigHandler(this.podTemplateHandler);
    }

    public ReplicaSetHandler getReplicaSetHandler() {
        return new ReplicaSetHandler(this.podTemplateHandler);
    }

    public ReplicationControllerHandler getReplicationControllerHandler() {
        return new ReplicationControllerHandler(this.podTemplateHandler);
    }

    public StatefulSetHandler getStatefulSetHandler() {
        return new StatefulSetHandler(this.podTemplateHandler);
    }

    public DaemonSetHandler getDaemonSetHandler() {
        return new DaemonSetHandler(this.podTemplateHandler);
    }

    public JobHandler getJobHandler() {
        return new JobHandler(this.podTemplateHandler);
    }

    public ProjectHandler getProjectHandler() {
        return new ProjectHandler();
    }

    public NamespaceHandler getNamespaceHandler() {
        return new NamespaceHandler();
    }
}

