/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.core.service;

import io.fabric8.maven.core.service.ArtifactResolverService;
import java.io.File;
import java.util.Objects;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.RepositorySystem;

class ArtifactResolverServiceMavenImpl
implements ArtifactResolverService {
    private MavenProject project;
    private RepositorySystem repositorySystem;

    ArtifactResolverServiceMavenImpl(RepositorySystem repositorySystem, MavenProject project) {
        this.repositorySystem = Objects.requireNonNull(repositorySystem, "repositorySystem");
        this.project = Objects.requireNonNull(project, "project");
    }

    @Override
    public File resolveArtifact(String groupId, String artifactId, String version, String type) {
        String canonicalString = groupId + ":" + artifactId + ":" + type + ":" + version;
        Artifact art = this.repositorySystem.createArtifact(groupId, artifactId, version, type);
        ArtifactResolutionRequest request = new ArtifactResolutionRequest().setArtifact(art).setResolveRoot(true).setOffline(false).setRemoteRepositories(this.project.getRemoteArtifactRepositories()).setResolveTransitively(false);
        ArtifactResolutionResult res = this.repositorySystem.resolve(request);
        if (!res.isSuccess()) {
            throw new IllegalStateException("Cannot resolve artifact " + canonicalString);
        }
        for (Artifact artifact : res.getArtifacts()) {
            if (!artifact.getGroupId().equals(groupId) || !artifact.getArtifactId().equals(artifactId) || !artifact.getVersion().equals(version) || !artifact.getType().equals(type)) continue;
            return artifact.getFile();
        }
        throw new IllegalStateException("Cannot find artifact " + canonicalString + " within the resolved resources");
    }
}

