/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven;

import io.fabric8.common.util.Files;
import io.fabric8.common.util.Strings;
import io.fabric8.deployer.dto.DependencyDTO;
import io.fabric8.deployer.dto.ProjectRequirements;
import io.fabric8.maven.Zips;
import java.io.Console;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactCollector;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.dependency.tree.DependencyNode;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilder;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilderException;

public abstract class AbstractProfileMojo
extends AbstractMojo {
    @Parameter(property="profileConfigDir", defaultValue="${basedir}/src/main/fabric8")
    protected File profileConfigDir;
    @Component
    protected MavenProject project;
    @Component
    protected ArtifactCollector artifactCollector;
    @Component
    protected ArtifactFactory artifactFactory;
    @Component
    protected DependencyTreeBuilder dependencyTreeBuilder;
    @Component
    protected ArtifactMetadataSource metadataSource;
    @Parameter(property="localRepository", readonly=true, required=true)
    protected ArtifactRepository localRepository;
    @Parameter(property="project.remoteArtifactRepositories")
    protected List remoteRepositories;
    @Parameter(property="fabric8.scope", defaultValue="compile")
    private String scope;
    @Parameter(property="fabric8.profile")
    private String profile;
    @Parameter(property="fabric8.profileVersion")
    private String version;
    @Parameter(property="fabric8.baseVersion")
    private String baseVersion;
    @Parameter(property="fabric8.parentProfiles")
    private String parentProfiles;
    @Parameter(property="fabric8.bundles")
    private String bundles;
    @Parameter(property="fabric8.features")
    private String features;
    @Parameter(property="fabric8.featureRepos")
    private String featureRepos;
    @Parameter(property="fabric8.minInstanceCount", defaultValue="1")
    private Integer minInstanceCount;
    @Parameter(property="fabric8.includeArtifact", defaultValue="true")
    private boolean includeArtifact;
    @Parameter(property="fabric8.ignoreProject", defaultValue="false")
    private boolean ignoreProject;
    @Parameter(property="fabric8.includeReadMe", defaultValue="true")
    protected boolean includeReadMe;
    @Parameter(property="fabric8.generateSummaryFile", defaultValue="true")
    protected boolean generateSummaryFile;

    protected static boolean isFile(File file) {
        return file != null && file.exists() && file.isFile();
    }

    public static void combineProfileFilesToFolder(MavenProject reactorProject, File buildDir, Log log, String reactorProjectOutputPath) throws IOException {
        File basedir = reactorProject.getBasedir();
        if (!basedir.exists()) {
            log.warn((CharSequence)("No basedir " + basedir.getAbsolutePath() + " for project + " + reactorProject));
            return;
        }
        File outDir = new File(basedir, reactorProjectOutputPath);
        if (!outDir.exists()) {
            log.warn((CharSequence)("No profile output dir at: " + outDir.getAbsolutePath() + " for project + " + reactorProject + " so ignoring this project."));
            return;
        }
        log.info((CharSequence)("Copying profiles from " + outDir.getAbsolutePath() + " into the output directory: " + buildDir));
        AbstractProfileMojo.appendProfileConfigFiles(outDir, buildDir);
    }

    public static void appendProfileConfigFiles(File profileSourceDir, File outputDir) throws IOException {
        File[] files;
        if (profileSourceDir.exists() && profileSourceDir.isDirectory() && (files = profileSourceDir.listFiles()) != null) {
            outputDir.mkdirs();
            for (File file : files) {
                File outFile = new File(outputDir, file.getName());
                if (file.isDirectory()) {
                    AbstractProfileMojo.appendProfileConfigFiles(file, outFile);
                    continue;
                }
                if (outFile.exists() && file.getName().endsWith(".properties")) {
                    System.out.println("Combining properties: file " + file.getAbsolutePath());
                    AbstractProfileMojo.combinePropertiesFiles(file, outFile);
                    continue;
                }
                System.out.println("Copying file " + file.getAbsolutePath());
                Files.copy((File)file, (File)outFile);
            }
        }
    }

    public static void combinePropertiesFiles(File sourceFile, File destFile) throws IOException {
        Properties source = AbstractProfileMojo.loadProperties(sourceFile);
        Properties dest = AbstractProfileMojo.loadProperties(destFile);
        Set<Map.Entry<Object, Object>> entries = source.entrySet();
        for (Map.Entry<Object, Object> entry : entries) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (key == null || value == null) continue;
            String keyText = key.toString();
            String valueText = value.toString();
            String oldValue = dest.getProperty(keyText);
            if (oldValue == null || oldValue.trim().length() == 0) {
                dest.setProperty(keyText, valueText);
                continue;
            }
            if (oldValue.contains(valueText)) continue;
            String newValue = oldValue + " " + valueText;
            dest.setProperty(keyText, newValue);
        }
        dest.store(new FileWriter(destFile), "Generated by fabric8:full-zip plugin at " + new Date());
    }

    private static Properties loadProperties(File file) throws IOException {
        Properties answer = new Properties();
        answer.load(new FileReader(file));
        return answer;
    }

    public boolean isIncludeArtifact() {
        return this.includeArtifact && !"pom".equals(this.project.getPackaging());
    }

    public boolean isIgnoreProject() {
        return this.ignoreProject;
    }

    protected static List<String> parameterToStringList(String parameterValue) {
        ArrayList<String> answer = new ArrayList<String>();
        if (Strings.isNotBlank((String)parameterValue)) {
            String[] split;
            for (String text : split = parameterValue.split("\\s")) {
                if (!Strings.isNotBlank((String)text)) continue;
                answer.add(text);
            }
        }
        return answer;
    }

    protected String readInput(String prompt) {
        Console console = System.console();
        System.out.print(prompt);
        return console.readLine();
    }

    protected String readPassword(String prompt) {
        Console console = System.console();
        System.out.print(prompt);
        char[] pw = console.readPassword();
        return new String(pw);
    }

    protected void configureRequirements(ProjectRequirements requirements) throws MojoExecutionException {
        if (Strings.isNotBlank((String)this.profile)) {
            requirements.setProfileId(this.profile);
        } else {
            requirements.setProfileId(this.project.getGroupId() + "-" + this.project.getArtifactId());
        }
        String description = this.project.getDescription();
        if (Strings.isNotBlank((String)description)) {
            requirements.setDescription(description);
        }
        if (Strings.isNotBlank((String)this.version)) {
            requirements.setVersion(this.version);
        }
        if (Strings.isNotBlank((String)this.baseVersion)) {
            requirements.setBaseVersion(this.baseVersion);
        }
        List<String> bundleList = AbstractProfileMojo.parameterToStringList(this.bundles);
        if (this.parentProfiles == null || this.parentProfiles.length() <= 0) {
            this.parentProfiles = this.defaultParentProfiles(requirements);
        }
        List<String> profileParentList = AbstractProfileMojo.parameterToStringList(this.parentProfiles);
        List<String> featureList = AbstractProfileMojo.parameterToStringList(this.features);
        List<String> featureReposList = AbstractProfileMojo.parameterToStringList(this.featureRepos);
        requirements.setParentProfiles(profileParentList);
        requirements.setBundles(bundleList);
        requirements.setFeatures(featureList);
        requirements.setFeatureRepositories(featureReposList);
        if (this.minInstanceCount != null) {
            requirements.setMinimumInstances(this.minInstanceCount);
        }
    }

    protected String defaultParentProfiles(ProjectRequirements requirements) throws MojoExecutionException {
        String packaging = this.project.getPackaging();
        if (packaging != null) {
            if ("jar".equals(packaging)) {
                ArrayList<File> files = new ArrayList<File>();
                Set<String> classNames = this.findMainClasses(files);
                int classNameSize = classNames.size();
                if (classNameSize > 0 && classNameSize > 1) {
                    this.getLog().warn((CharSequence)("We found more than one executable main: " + classNames));
                }
                ArrayList<URL> urls = new ArrayList<URL>();
                try {
                    for (File file : files) {
                        URL url = file.toURI().toURL();
                        urls.add(url);
                    }
                    return this.resolveProfileFromJars(urls);
                }
                catch (MalformedURLException e) {
                    this.getLog().warn((CharSequence)("Failed to create URLClassLoader from files: " + files));
                    return "containers-java";
                }
            }
            if ("war".equals(packaging)) {
                return "containers-tomcat";
            }
        }
        return "karaf";
    }

    protected String resolveProfileFromJars(List<URL> jars) {
        URLClassLoader classLoader = new URLClassLoader(jars.toArray(new URL[jars.size()]));
        Map<String, String> mainToProfileMap = this.getDefaultClassToProfileMap();
        Set<Map.Entry<String, String>> entries = mainToProfileMap.entrySet();
        for (Map.Entry<String, String> entry : entries) {
            String mainClass = entry.getKey();
            String profileName = entry.getValue();
            if (!this.hasClass(classLoader, mainClass)) continue;
            this.getLog().info((CharSequence)("Found class: " + mainClass + " so defaulting the parent profile: " + profileName));
            return profileName;
        }
        return "containers-java";
    }

    protected Map<String, String> getDefaultClassToProfileMap() {
        LinkedHashMap<String, String> mainToProfileMap = new LinkedHashMap<String, String>();
        mainToProfileMap.put("org.springframework.boot.SpringApplication", "containers-java.spring.boot");
        mainToProfileMap.put("io.fabric8.process.spring.boot.container.FabricSpringApplication", "containers-java.spring.boot");
        mainToProfileMap.put("org.apache.camel.spring.Main", "containers-java.camel.spring");
        mainToProfileMap.put("org.osgi.framework.BundleContext", "containers-java.pojosr");
        mainToProfileMap.put("org.apache.camel.blueprint.ErrorHandlerType", "containers-java.pojosr");
        mainToProfileMap.put("javax.enterprise.context.ApplicationScoped", "containers-java.weld");
        return mainToProfileMap;
    }

    protected boolean hasClass(URLClassLoader classLoader, String className) {
        try {
            classLoader.loadClass(className);
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    protected Set<String> findMainClasses(List<File> files) throws MojoExecutionException {
        HashSet<String> classNames = new HashSet<String>();
        Artifact artifact = this.project.getArtifact();
        if (artifact != null) {
            File artifactFile = artifact.getFile();
            this.addMainClass(classNames, files, artifactFile);
        }
        try {
            for (Object object : this.project.getCompileClasspathElements()) {
                if (object == null) continue;
                String path = object.toString();
                File file = new File(path);
                this.addMainClass(classNames, files, file);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to resolve classpath: " + e, e);
        }
        return classNames;
    }

    protected void addMainClass(Set<String> classNames, List<File> files, File file) {
        if (file != null && file.exists() && file.isFile()) {
            files.add(file);
            try {
                String className;
                Attributes attributes;
                JarFile jarFile = new JarFile(file);
                Manifest manifest = jarFile.getManifest();
                if (manifest != null && (attributes = manifest.getMainAttributes()) != null && (className = attributes.getValue(Attributes.Name.MAIN_CLASS)) != null && className.length() > 0) {
                    this.getLog().debug((CharSequence)("found main class " + className + " in " + file));
                    className = className.trim();
                    if (className.length() > 0) {
                        classNames.add(className);
                    }
                }
            }
            catch (IOException e) {
                this.getLog().warn((CharSequence)("Failed to parse manifest for " + file + ". " + e), (Throwable)e);
            }
        }
    }

    protected void addProjectArtifactBundle(ProjectRequirements requirements) {
        DependencyDTO rootDependency = requirements.getRootDependency();
        if (rootDependency != null) {
            String url = rootDependency.toBundleUrlWithType();
            if (!requirements.getBundles().contains(url)) {
                requirements.getBundles().add(url);
            }
        }
    }

    protected DependencyDTO loadRootDependency() throws DependencyTreeBuilderException {
        ArtifactFilter artifactFilter = this.createResolvingArtifactFilter();
        DependencyNode dependencyNode = this.dependencyTreeBuilder.buildDependencyTree(this.project, this.localRepository, this.artifactFactory, this.metadataSource, artifactFilter, this.artifactCollector);
        return this.buildFrom(dependencyNode);
    }

    private DependencyDTO buildFrom(DependencyNode node) {
        Artifact artifact = node.getArtifact();
        if (artifact != null) {
            DependencyDTO answer = new DependencyDTO();
            answer.setGroupId(artifact.getGroupId());
            answer.setArtifactId(artifact.getArtifactId());
            answer.setVersion(artifact.getVersion());
            answer.setClassifier(artifact.getClassifier());
            String scope = artifact.getScope();
            answer.setScope(scope);
            answer.setType(artifact.getType());
            answer.setOptional(artifact.isOptional());
            String type = answer.getType();
            if (type != null && type.equals("pom")) {
                this.getLog().debug((CharSequence)("Ignoring pom.xml for " + answer));
                return null;
            }
            int state = node.getState();
            if (state != 0) {
                this.getLog().debug((CharSequence)("Ignoring " + node));
                return null;
            }
            if (this.isWarProject() && scope != null && !scope.equals("provided")) {
                this.getLog().debug((CharSequence)("WAR packaging so ignoring non-provided scope " + scope + " for " + node));
                return null;
            }
            List children = node.getChildren();
            for (Object child : children) {
                DependencyDTO childDTO;
                DependencyNode childNode;
                if (!(child instanceof DependencyNode) || (childNode = (DependencyNode)child).getState() != 0 || (childDTO = this.buildFrom(childNode)) == null) continue;
                answer.addChild(childDTO);
            }
            return answer;
        }
        return null;
    }

    protected boolean isWarProject() {
        if (this.project != null) {
            String packaging = this.project.getPackaging();
            return packaging != null && packaging.equals("war");
        }
        return false;
    }

    protected void walkTree(DependencyNode node, int level) {
        if (node == null) {
            this.getLog().warn((CharSequence)"Null node!");
            return;
        }
        this.getLog().info((CharSequence)(this.indent(level) + node.getArtifact()));
        List children = node.getChildren();
        for (Object child : children) {
            if (child instanceof DependencyNode) {
                this.walkTree((DependencyNode)child, level + 1);
                continue;
            }
            this.getLog().warn((CharSequence)("Unknown class " + child.getClass()));
        }
    }

    protected String indent(int level) {
        StringBuilder builder = new StringBuilder();
        while (level-- > 0) {
            builder.append("    ");
        }
        return builder.toString();
    }

    private ArtifactFilter createResolvingArtifactFilter() {
        ScopeArtifactFilter filter;
        if (this.scope != null) {
            this.getLog().debug((CharSequence)("+ Resolving dependency tree for scope '" + this.scope + "'"));
            filter = new ScopeArtifactFilter(this.scope);
        } else {
            filter = null;
        }
        return filter;
    }

    protected void createAggregatedZip(List<MavenProject> reactorProjectList, File projectBaseDir, File projectBuildDir, String reactorProjectOutputPath, File projectOutputFile, boolean includeReadMe, List<MavenProject> pomZipProjects) throws IOException {
        projectBuildDir.mkdirs();
        for (MavenProject reactorProject : reactorProjectList) {
            if (reactorProject.isExecutionRoot()) continue;
            Log log = this.getLog();
            AbstractProfileMojo.combineProfileFilesToFolder(reactorProject, projectBuildDir, log, reactorProjectOutputPath);
        }
        if (includeReadMe) {
            for (MavenProject pomProjects : pomZipProjects) {
                File src = pomProjects.getFile().getParentFile();
                String root = projectBaseDir.getName();
                String relativePath = Files.getRelativePath((File)projectBaseDir, (File)pomProjects.getBasedir());
                relativePath = root + File.separator + relativePath;
                relativePath = AbstractProfileMojo.pathToProfilePath(relativePath);
                File outDir = new File(projectBuildDir, relativePath);
                AbstractProfileMojo.copyReadMe(src, outDir);
            }
        }
        Zips.createZipFile(this.getLog(), projectBuildDir, projectOutputFile);
        String relativePath = Files.getRelativePath((File)projectBaseDir, (File)projectOutputFile);
        while (relativePath.startsWith("/")) {
            relativePath = relativePath.substring(1);
        }
        this.getLog().info((CharSequence)("Created profile zip file: " + relativePath));
    }

    private static String pathToProfilePath(String path) {
        return path.replace('-', '.');
    }

    protected static void copyReadMe(File src, File profileBuildDir) throws IOException {
        File[] files = src.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase(Locale.ENGLISH).startsWith("readme.");
            }
        });
        if (files != null && files.length == 1) {
            File readme = files[0];
            File outFile = new File(profileBuildDir, readme.getName());
            Files.copy((File)readme, (File)outFile);
        }
    }
}

