package io.freefair.gradle.plugins.lombok.tasks;

import lombok.Getter;
import lombok.Setter;
import lombok.SneakyThrows;
import org.codehaus.groovy.runtime.ResourceGroovyMethods;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.StopExecutionException;
import org.gradle.api.tasks.TaskAction;
import org.gradle.internal.deprecation.DeprecationLogger;

import java.io.File;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Map;
import java.util.stream.Stream;

@Getter
@Setter
@Deprecated
public class GenerateLombokConfig extends DefaultTask {

    @OutputFile
    private final RegularFileProperty outputFile = getProject().getObjects().fileProperty();

    @Input
    private final MapProperty<String, String> properties = getProject().getObjects().mapProperty(String.class, String.class);

    public GenerateLombokConfig() {
        DeprecationLogger.deprecateTaskType(GenerateLombokConfig.class, "generateLombokConfig")
                .willBeRemovedInGradle9()
                .undocumented()
                .nagUser();

        outputFile.set(getProject().file("lombok.config"));
        onlyIf(t -> getProperties().isPresent() && !getProperties().get().isEmpty());
    }

    @TaskAction
    @SneakyThrows
    public void generateLombokConfig() {
        File file = outputFile.getAsFile().get();

        if (file.isFile()) {
            try (Stream<String> lines = Files.lines(file.toPath(), StandardCharsets.ISO_8859_1)) {
                if (lines.noneMatch(line -> line.startsWith("#") && line.contains("io.freefair.lombok"))) {
                    String message = file + " already exists and was not generated by this task";
                    getLogger().warn(message);
                    throw new StopExecutionException(message);
                }
            }
        }

        try (PrintWriter writer = ResourceGroovyMethods.newPrintWriter(file, "ISO-8859-1")) {
            writer.println("# This file is generated by the 'io.freefair.lombok' Gradle plugin");
            properties.get().entrySet().stream()
                    .sorted(Map.Entry.comparingByKey(String.CASE_INSENSITIVE_ORDER))
                    .forEach(entry ->
                            writer.println(entry.getKey() + " = " + entry.getValue())
                    );
        }
    }
}
