/*
 * Decompiled with CFR 0.152.
 */
package org.ddr.image.heif;

import com.drew.imaging.FileType;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.exif.ExifIFD0Directory;
import com.drew.metadata.exif.ExifSubIFDDirectory;
import com.drew.metadata.heif.HeifDirectory;
import java.awt.Dimension;
import org.ddr.image.ImageType;
import org.ddr.image.MetadataReader;

public class HeifMetadataReader
implements MetadataReader {
    @Override
    public boolean canRead(FileType type) {
        return type == FileType.Heif;
    }

    @Override
    public ImageType getType(Metadata metadata) {
        return ImageType.JPG;
    }

    @Override
    public Dimension getDimension(Metadata metadata) {
        Integer width = null;
        Integer height = null;
        Boolean rotated = null;
        for (Directory directory : metadata.getDirectories()) {
            Integer r;
            if (directory instanceof HeifDirectory) {
                r = directory.getInteger(6);
                if (r == null) continue;
                rotated = r % 2 == 1;
                continue;
            }
            if (directory instanceof ExifIFD0Directory) {
                if (rotated != null || (r = directory.getInteger(274)) == null) continue;
                rotated = r > 4;
                continue;
            }
            if (!(directory instanceof ExifSubIFDDirectory)) continue;
            width = directory.getInteger(40962);
            height = directory.getInteger(40963);
        }
        if (width != null && height != null) {
            if (Boolean.TRUE.equals(rotated)) {
                return new Dimension(height, width);
            }
            return new Dimension(width, height);
        }
        return null;
    }
}

