/*
 * Decompiled with CFR 0.152.
 */
package org.ddr.poi.html.util;

import java.util.Map;
import java.util.Objects;
import org.ddr.poi.html.util.CSSLength;
import org.ddr.poi.html.util.CSSLengthUnit;

public class SpanWidth
extends CSSLength {
    private final int span;
    private final int column;
    private final CSSLength[] lengths;
    private final boolean explicitWidth;

    public SpanWidth(CSSLength length, int column, int span, boolean explicitWidth) {
        super(length.getValue(), length.getUnit());
        this.column = column;
        this.span = span;
        this.lengths = new CSSLength[span];
        this.explicitWidth = explicitWidth;
    }

    public void setLength(Map<Integer, CSSLength> map) {
        if (!this.isValid()) {
            for (int i = 0; i < this.span; ++i) {
                map.putIfAbsent(this.column + i, CSSLength.INVALID);
            }
            return;
        }
        int invalidCount = 0;
        boolean percent = this.isPercent();
        double total = percent ? this.getValue() : this.unitValue();
        CSSLengthUnit unit = percent ? CSSLengthUnit.PERCENT : CSSLengthUnit.EMU;
        for (int i = 0; i < this.span; ++i) {
            CSSLength length;
            Integer index = this.column + i;
            this.lengths[i] = length = map.getOrDefault(index, CSSLength.INVALID);
            if (length.isValid()) {
                if (percent && length.isPercent()) {
                    total -= length.getValue();
                    continue;
                }
                if (!percent && !length.isPercent()) {
                    total -= length.unitValue();
                    continue;
                }
                this.lengths[i] = CSSLength.INVALID;
                ++invalidCount;
                continue;
            }
            ++invalidCount;
        }
        if (invalidCount > 0) {
            CSSLength length = new CSSLength(total / (double)invalidCount, unit);
            for (int i = 0; i < this.span; ++i) {
                if (this.lengths[i].isValid()) continue;
                map.compute(this.column + i, (key, value) -> {
                    if (value == null || !value.isValid()) {
                        return length;
                    }
                    if (this.explicitWidth ^ percent) {
                        return length;
                    }
                    return value;
                });
            }
        }
    }

    public int getSpan() {
        return this.span;
    }

    public int getColumn() {
        return this.column;
    }

    public CSSLength[] getLengths() {
        return this.lengths;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SpanWidth spanWidth = (SpanWidth)o;
        return this.span == spanWidth.span && this.column == spanWidth.column && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.column, this.span);
    }
}

