/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.util.postman;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import io.github.microcks.domain.Exchange;
import io.github.microcks.domain.Header;
import io.github.microcks.domain.Operation;
import io.github.microcks.domain.Parameter;
import io.github.microcks.domain.Request;
import io.github.microcks.domain.RequestResponsePair;
import io.github.microcks.domain.Resource;
import io.github.microcks.domain.ResourceType;
import io.github.microcks.domain.Response;
import io.github.microcks.domain.Service;
import io.github.microcks.domain.ServiceType;
import io.github.microcks.util.DispatchCriteriaHelper;
import io.github.microcks.util.MockRepositoryImportException;
import io.github.microcks.util.MockRepositoryImporter;
import io.github.microcks.util.URIBuilder;
import io.github.microcks.util.postman.PostmanUtil;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostmanCollectionImporter
implements MockRepositoryImporter {
    private static final Logger log = LoggerFactory.getLogger(PostmanCollectionImporter.class);
    public static final String SERVICE_VERSION_PROPERTY = "version";
    private static final String REQUEST_NODE = "request";
    private static final String QUERY_NODE = "query";
    private static final String VARIABLE_NODE = "variable";
    private static final String GRAPHQL_NODE = "graphql";
    private static final String VARIABLES_NODE = "variables";
    private ObjectMapper mapper;
    private JsonNode collection;
    private String collectionContent;
    private boolean isV2Collection = false;

    protected PostmanCollectionImporter() {
    }

    public PostmanCollectionImporter(String collectionFilePath) throws IOException {
        try {
            byte[] jsonBytes = Files.readAllBytes(Paths.get(collectionFilePath, new String[0]));
            this.collectionContent = new String(jsonBytes, StandardCharsets.UTF_8);
            this.mapper = new ObjectMapper();
            this.collection = this.mapper.readTree(jsonBytes);
        }
        catch (Exception e) {
            log.error("Exception while parsing Postman collection file " + collectionFilePath, (Throwable)e);
            throw new IOException("Postman collection file parsing error");
        }
    }

    protected void setCollection(JsonNode collection) {
        this.collection = collection;
    }

    protected void setCollectionContent(String collectionContent) {
        this.collectionContent = collectionContent;
    }

    @Override
    public List<Service> getServiceDefinitions() throws MockRepositoryImportException {
        ArrayList<Service> result = new ArrayList<Service>();
        Service service = new Service();
        if (!this.collection.has("info")) {
            throw new MockRepositoryImportException("Only Postman v2 Collection are supported.");
        }
        this.isV2Collection = true;
        this.fillServiceDefinition(service);
        try {
            service.setOperations(this.extractOperations());
        }
        catch (Throwable t) {
            log.error("Runtime exception while extracting Operations for {}", (Object)service.getName());
            throw new MockRepositoryImportException("Runtime exception for " + service.getName() + ": " + t.getMessage());
        }
        result.add(service);
        return result;
    }

    private void fillServiceDefinition(Service service) throws MockRepositoryImportException {
        service.setName(this.collection.path("info").path("name").asText());
        service.setType(ServiceType.REST);
        String version = null;
        if (this.collection.path("info").has(SERVICE_VERSION_PROPERTY)) {
            version = this.collection.path("info").path(SERVICE_VERSION_PROPERTY).asText();
        } else {
            String description = this.collection.path("info").path("description").asText();
            if (description != null && description.indexOf("version=") != -1) {
                if ((description = description.substring(description.indexOf("version="))).indexOf(32) > -1) {
                    description = description.substring(0, description.indexOf(32));
                }
                if (description.split("=").length > 1) {
                    version = description.split("=")[1];
                }
            }
        }
        if (version == null) {
            log.error("Version property is missing in Collection. Use either 'version' for v2.1 Collection or 'version=x.y - something' description syntax.");
            throw new MockRepositoryImportException("Version property is missing in Collection description");
        }
        service.setVersion(version);
    }

    @Override
    public List<Resource> getResourceDefinitions(Service service) {
        ArrayList<Resource> results = new ArrayList<Resource>();
        String name = service.getName() + "-" + service.getVersion() + ".json";
        Resource resource = new Resource();
        resource.setName(name);
        resource.setType(ResourceType.POSTMAN_COLLECTION);
        resource.setContent(this.collectionContent);
        results.add(resource);
        return results;
    }

    @Override
    public List<Exchange> getMessageDefinitions(Service service, Operation operation) throws MockRepositoryImportException {
        if (this.isV2Collection) {
            return this.getMessageDefinitionsV2(service, operation);
        }
        throw new MockRepositoryImportException("Only Postman v2 Collection are supported.");
    }

    private List<Exchange> getMessageDefinitionsV2(Service service, Operation operation) {
        HashMap<Request, Response> result = new HashMap<Request, Response>();
        Iterator items = this.collection.path("item").elements();
        while (items.hasNext()) {
            JsonNode item = (JsonNode)items.next();
            result.putAll(this.getMessageDefinitionsV2("", item, operation));
        }
        return result.entrySet().stream().map(entry -> new RequestResponsePair((Request)entry.getKey(), (Response)entry.getValue())).collect(Collectors.toList());
    }

    private Map<Request, Response> getMessageDefinitionsV2(String folderName, JsonNode itemNode, Operation operation) {
        HashMap<Request, Response> result;
        block14: {
            block13: {
                log.debug("Extracting message definitions in folder {}", (Object)folderName);
                result = new HashMap<Request, Response>();
                String itemNodeName = itemNode.path("name").asText();
                if (itemNode.has(REQUEST_NODE)) break block13;
                Iterator items = itemNode.path("item").elements();
                while (items.hasNext()) {
                    JsonNode item = (JsonNode)items.next();
                    result.putAll(this.getMessageDefinitionsV2(folderName + "/" + itemNodeName, item, operation));
                }
                break block14;
            }
            String operationName = PostmanCollectionImporter.buildOperationName(itemNode, folderName);
            if (!PostmanUtil.areOperationsEquivalent(operation.getName(), operationName)) break block14;
            DispatchCriteriaHelper.DispatcherDetails details = DispatchCriteriaHelper.extractDispatcherWithRules(operation);
            String rootDispatcher = details.rootDispatcher();
            String rootDispatcherRules = details.rootDispatcherRules();
            Iterator responses = itemNode.path("response").elements();
            while (responses.hasNext()) {
                JsonNode responseNode = (JsonNode)responses.next();
                JsonNode requestNode = responseNode.path("originalRequest");
                Object dispatchCriteria = null;
                String requestUrl = requestNode.path("url").path("raw").asText();
                if ("URI_PARAMS".equals(rootDispatcher)) {
                    dispatchCriteria = DispatchCriteriaHelper.extractFromURIParams(operation.getDispatcherRules(), requestUrl);
                    operation.addResourcePath(this.extractResourcePath(requestUrl, null));
                } else if ("URI_PARTS".equals(rootDispatcher)) {
                    parts = this.buildRequestParts(requestNode);
                    dispatchCriteria = DispatchCriteriaHelper.buildFromPartsMap(rootDispatcherRules, parts);
                    resourcePath = this.extractResourcePath(requestUrl, null);
                    operation.addResourcePath(URIBuilder.buildURIFromPattern(resourcePath, parts));
                } else if ("URI_ELEMENTS".equals(rootDispatcher)) {
                    parts = this.buildRequestParts(requestNode);
                    dispatchCriteria = DispatchCriteriaHelper.buildFromPartsMap(rootDispatcherRules, parts);
                    dispatchCriteria = (String)dispatchCriteria + DispatchCriteriaHelper.extractFromURIParams(rootDispatcherRules, requestUrl);
                    resourcePath = this.extractResourcePath(requestUrl, null);
                    operation.addResourcePath(URIBuilder.buildURIFromPattern(resourcePath, parts));
                } else if ("QUERY_ARGS".equals(rootDispatcher)) {
                    String variables;
                    if (requestNode.path("body").has(GRAPHQL_NODE)) {
                        variables = requestNode.path("body").path(GRAPHQL_NODE).path(VARIABLES_NODE).asText();
                        dispatchCriteria = this.extractQueryArgsCriteria(rootDispatcherRules, variables);
                    }
                    if (requestNode.path("body").has("raw")) {
                        variables = requestNode.path("body").path("raw").asText();
                        dispatchCriteria = this.extractQueryArgsCriteria(rootDispatcherRules, variables);
                    }
                } else if (requestUrl != null && !requestUrl.isEmpty()) {
                    operation.addResourcePath(this.extractResourcePath(requestUrl, null));
                    log.debug("Added operation generic resource path: {}", (Object)operation.getResourcePaths());
                }
                Request request = this.buildRequest(requestNode, responseNode.path("name").asText());
                Response response = this.buildResponse(responseNode, (String)dispatchCriteria);
                result.put(request, response);
            }
        }
        return result;
    }

    private Request buildRequest(JsonNode requestNode, String name) {
        Request request = new Request();
        request.setName(name);
        if (this.isV2Collection) {
            Parameter param;
            request.setHeaders(this.buildHeaders(requestNode.path("header")));
            if (requestNode.has("body") && requestNode.path("body").has("raw")) {
                request.setContent(requestNode.path("body").path("raw").asText());
            } else if (requestNode.has("body") && requestNode.path("body").has(GRAPHQL_NODE)) {
                String query = requestNode.path("body").path(GRAPHQL_NODE).path(QUERY_NODE).asText();
                String variables = requestNode.path("body").path(GRAPHQL_NODE).path(VARIABLES_NODE).asText();
                StringBuilder requestContent = new StringBuilder("{\"query\": \"").append(query.replace("\n", "\\n")).append("\"");
                try {
                    JsonNode variablesNode = this.mapper.readTree(variables);
                    if (variablesNode.isObject() && !variablesNode.isEmpty()) {
                        requestContent.append(", \"variables\": ").append(variables);
                    }
                }
                catch (JsonProcessingException jpe) {
                    log.warn("Json processing excpetion while parsing GraphQL variables, ignoring them: {}", (Object)jpe.getMessage());
                }
                requestContent.append("}");
                request.setContent(requestContent.toString());
            }
            if (requestNode.path("url").has(VARIABLE_NODE)) {
                JsonNode variablesNode = requestNode.path("url").path(VARIABLE_NODE);
                for (JsonNode variableNode : variablesNode) {
                    param = new Parameter();
                    param.setName(variableNode.path("key").asText());
                    param.setValue(variableNode.path("value").asText());
                    request.addQueryParameter(param);
                }
            }
            if (requestNode.path("url").has(QUERY_NODE)) {
                JsonNode queryNode = requestNode.path("url").path(QUERY_NODE);
                for (JsonNode variableNode : queryNode) {
                    param = new Parameter();
                    param.setName(variableNode.path("key").asText());
                    param.setValue(variableNode.path("value").asText());
                    request.addQueryParameter(param);
                }
            }
        } else {
            request.setHeaders(this.buildHeaders(requestNode.path("headers")));
        }
        return request;
    }

    private Map<String, String> buildRequestParts(JsonNode requestNode) {
        HashMap<String, String> parts = new HashMap<String, String>();
        if (requestNode.has("url") && requestNode.path("url").has(VARIABLE_NODE)) {
            Iterator variables = requestNode.path("url").path(VARIABLE_NODE).elements();
            while (variables.hasNext()) {
                JsonNode variable = (JsonNode)variables.next();
                parts.put(variable.path("key").asText(), variable.path("value").asText());
            }
        }
        return parts;
    }

    private String extractQueryArgsCriteria(String dispatcherRules, String variables) {
        String dispatchCriteria = "";
        try {
            Map paramsMap = (Map)this.mapper.readValue(variables, (JavaType)TypeFactory.defaultInstance().constructMapType(TreeMap.class, String.class, String.class));
            dispatchCriteria = DispatchCriteriaHelper.extractFromParamMap(dispatcherRules, paramsMap);
        }
        catch (Exception e) {
            log.error("Exception while extracting dispatch criteria from JSON body: {}", (Object)e.getMessage());
        }
        return dispatchCriteria;
    }

    private Response buildResponse(JsonNode responseNode, String dispatchCriteria) {
        Response response = new Response();
        response.setName(responseNode.path("name").asText());
        if (this.isV2Collection) {
            response.setStatus(responseNode.path("code").asText("200"));
            response.setHeaders(this.buildHeaders(responseNode.path("header")));
            response.setContent(responseNode.path("body").asText(""));
        } else {
            response.setStatus(responseNode.path("responseCode").path("code").asText());
            response.setHeaders(this.buildHeaders(responseNode.path("headers")));
            response.setContent(responseNode.path("text").asText());
        }
        if (response.getHeaders() != null) {
            for (Header header : response.getHeaders()) {
                if (!header.getName().equalsIgnoreCase("Content-Type")) continue;
                response.setMediaType(header.getValues().toArray(new String[0])[0]);
            }
        }
        if (!this.isV2Collection && response.getMediaType() == null && "json".equals(responseNode.path("language").asText())) {
            response.setMediaType("application/json");
        }
        if (this.isV2Collection && response.getMediaType() == null) {
            if ("json".equals(responseNode.path("_postman_previewlanguage").asText())) {
                response.setMediaType("application/json");
            } else if ("xml".equals(responseNode.path("_postman_previewlanguage").asText())) {
                response.setMediaType("text/xml");
            }
        }
        response.setDispatchCriteria(dispatchCriteria);
        return response;
    }

    private Set<Header> buildHeaders(JsonNode headerNode) {
        if (headerNode == null || headerNode.size() == 0) {
            return null;
        }
        HashSet<Header> headers = new HashSet<Header>();
        Iterator items = headerNode.elements();
        while (items.hasNext()) {
            JsonNode item = (JsonNode)items.next();
            Header header = new Header();
            header.setName(item.path("key").asText());
            HashSet<String> values = new HashSet<String>();
            values.add(item.path("value").asText());
            header.setValues(values);
            headers.add(header);
        }
        return headers;
    }

    private List<Operation> extractOperations() throws MockRepositoryImportException {
        if (this.isV2Collection) {
            return this.extractOperationsV2();
        }
        throw new MockRepositoryImportException("Only Postman v2 Collection are supported.");
    }

    private List<Operation> extractOperationsV2() {
        HashMap<String, Operation> collectedOperations = new HashMap<String, Operation>();
        Iterator items = this.collection.path("item").elements();
        while (items.hasNext()) {
            JsonNode item = (JsonNode)items.next();
            this.extractOperationV2("", item, collectedOperations);
        }
        return new ArrayList<Operation>(collectedOperations.values());
    }

    private void extractOperationV2(String folderName, JsonNode itemNode, Map<String, Operation> collectedOperations) {
        log.debug("Extracting operation in folder {}", (Object)folderName);
        String itemNodeName = itemNode.path("name").asText();
        if (!itemNode.has(REQUEST_NODE)) {
            Iterator items = itemNode.path("item").elements();
            while (items.hasNext()) {
                JsonNode item = (JsonNode)items.next();
                this.extractOperationV2(folderName + "/" + itemNodeName, item, collectedOperations);
            }
        } else {
            String operationName = PostmanCollectionImporter.buildOperationName(itemNode, folderName);
            Operation operation = collectedOperations.get(operationName);
            String url = itemNode.path(REQUEST_NODE).path("url").asText("");
            if ("".equals(url)) {
                url = itemNode.path(REQUEST_NODE).path("url").path("raw").asText("");
            }
            if (url.contains(folderName + "/")) {
                url = PostmanCollectionImporter.removeProtocolAndHostPort(url);
            }
            if (operation == null) {
                operation = new Operation();
                operation.setName(operationName);
                operation.setMethod(itemNode.path(REQUEST_NODE).path("method").asText());
                if (PostmanCollectionImporter.urlHasParameters(url) && PostmanCollectionImporter.urlHasParts(url)) {
                    operation.setDispatcherRules(DispatchCriteriaHelper.extractPartsFromURIPattern(url) + " ?? " + DispatchCriteriaHelper.extractParamsFromURI(url));
                    operation.setDispatcher("URI_ELEMENTS");
                } else if (PostmanCollectionImporter.urlHasParameters(url)) {
                    operation.setDispatcherRules(DispatchCriteriaHelper.extractParamsFromURI(url));
                    operation.setDispatcher("URI_PARAMS");
                    operation.addResourcePath(this.extractResourcePath(url, null));
                } else if (PostmanCollectionImporter.urlHasParts(url)) {
                    operation.setDispatcherRules(DispatchCriteriaHelper.extractPartsFromURIPattern(url));
                    operation.setDispatcher("URI_PARTS");
                } else {
                    operation.addResourcePath(this.extractResourcePath(url, null));
                    log.debug("Added operation generic resource path: {}", (Object)operation.getResourcePaths());
                }
            }
            collectedOperations.put(operationName, operation);
        }
    }

    public static String buildOperationName(JsonNode operationNode, String folderName) {
        String url = operationNode.path(REQUEST_NODE).path("url").asText("");
        if ("".equals(url)) {
            url = operationNode.path(REQUEST_NODE).path("url").path("raw").asText();
        }
        if (url.indexOf(63) != -1) {
            url = url.substring(0, url.indexOf(63));
        }
        url = PostmanCollectionImporter.removeProtocolAndHostPort(url);
        return operationNode.path(REQUEST_NODE).path("method").asText() + " " + url;
    }

    private String extractResourcePath(String url, String operationNameRadix) {
        String result = PostmanCollectionImporter.removeProtocolAndHostPort(url);
        if (result.indexOf(63) != -1) {
            result = result.substring(0, result.indexOf(63));
        }
        if (operationNameRadix != null && result.contains(operationNameRadix)) {
            result = result.substring(result.indexOf(operationNameRadix));
        }
        if (result.endsWith("/")) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    private static boolean urlHasParameters(String url) {
        return url.indexOf(63) != -1 && url.indexOf(61) != -1;
    }

    private static boolean urlHasParts(String url) {
        return url.indexOf("/:") != -1;
    }

    private static String removeProtocolAndHostPort(String url) {
        if (url.startsWith("https://")) {
            url = url.substring("https://".length());
        }
        if (url.startsWith("http://")) {
            url = url.substring("http://".length());
        }
        if (url.indexOf(47) != -1) {
            url = url.substring(url.indexOf(47));
        }
        return url;
    }
}

