/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.util;

import io.github.microcks.domain.Secret;
import io.github.microcks.util.HTTPDownloader;
import io.github.microcks.util.RelativeReferenceURLBuilder;
import io.github.microcks.util.SimpleReferenceURLBuilder;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReferenceResolver {
    private static final Logger log = LoggerFactory.getLogger(ReferenceResolver.class);
    private String baseRepositoryUrl;
    private final Secret repositorySecret;
    private final boolean disableSSLValidation;
    private boolean cleanResolvedFiles = true;
    private RelativeReferenceURLBuilder urlBuilder;
    private Map<String, File> resolvedReferences = new HashMap<String, File>();
    private Map<String, File> relativeResolvedReferences = new HashMap<String, File>();

    public ReferenceResolver(String baseRepositoryUrl, Secret repositorySecret, boolean disableSSLValidation) {
        this.setBaseRepositoryUrl(baseRepositoryUrl);
        this.repositorySecret = repositorySecret;
        this.disableSSLValidation = disableSSLValidation;
        this.urlBuilder = new SimpleReferenceURLBuilder();
    }

    public ReferenceResolver(String baseRepositoryUrl, Secret repositorySecret, boolean disableSSLValidation, RelativeReferenceURLBuilder urlBuilder) {
        this.setBaseRepositoryUrl(baseRepositoryUrl);
        this.repositorySecret = repositorySecret;
        this.disableSSLValidation = disableSSLValidation;
        this.urlBuilder = urlBuilder;
    }

    public String getBaseRepositoryUrl() {
        return this.baseRepositoryUrl;
    }

    public void setBaseRepositoryUrl(String baseRepositoryUrl) {
        this.baseRepositoryUrl = baseRepositoryUrl.endsWith("/") ? baseRepositoryUrl.substring(0, baseRepositoryUrl.length() - 1) : baseRepositoryUrl;
    }

    public boolean isCleanResolvedFiles() {
        return this.cleanResolvedFiles;
    }

    public void setCleanResolvedFiles(boolean cleanResolvedFiles) {
        this.cleanResolvedFiles = cleanResolvedFiles;
    }

    public String getReferenceURL(String referenceRelativePath) {
        String remoteUrl = referenceRelativePath;
        if (!referenceRelativePath.startsWith("http")) {
            remoteUrl = this.urlBuilder.buildRemoteURL(this.baseRepositoryUrl, referenceRelativePath);
        }
        return remoteUrl;
    }

    public String getReferenceContent(String relativePath, Charset encoding) throws IOException {
        String remoteUrl = this.getReferenceURL(relativePath);
        File referenceFile = this.resolvedReferences.get(remoteUrl);
        if (referenceFile == null) {
            log.info("Downloading a reference file at {}", (Object)remoteUrl);
            if (remoteUrl.startsWith("http")) {
                referenceFile = HTTPDownloader.handleHTTPDownloadToFile(remoteUrl, this.repositorySecret, this.disableSSLValidation);
            } else {
                if (remoteUrl.startsWith("file://")) {
                    remoteUrl = remoteUrl.substring("file://".length());
                }
                log.debug("Reading local file {}", (Object)remoteUrl);
                referenceFile = new File(remoteUrl);
            }
            this.resolvedReferences.put(remoteUrl, referenceFile);
        }
        this.relativeResolvedReferences.put(relativePath, referenceFile);
        return Files.readString(referenceFile.toPath(), encoding);
    }

    public Map<String, File> getResolvedReferences() {
        return this.resolvedReferences;
    }

    public Map<String, File> getRelativeResolvedReferences() {
        return this.relativeResolvedReferences;
    }

    public void cleanResolvedReferences() {
        if (this.cleanResolvedFiles) {
            for (File referenceFile : this.resolvedReferences.values()) {
                referenceFile.delete();
            }
        }
        this.resolvedReferences.clear();
        this.relativeResolvedReferences.clear();
    }
}

