/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.util;

import java.util.Arrays;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SafeLogger {
    private final Logger log;

    private SafeLogger(Logger log) {
        this.log = log;
    }

    public static SafeLogger getLogger(Class<?> clazz) {
        return new SafeLogger(LoggerFactory.getLogger(clazz));
    }

    public boolean isDebugEnabled() {
        return this.log.isDebugEnabled();
    }

    public void debug(String message) {
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.encode(message));
        }
    }

    public void debug(String format, Object arg) {
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.encode(format), this.encode(arg));
        }
    }

    public void debug(String format, Object arg1, Object arg2) {
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.encode(format), this.encode(arg1), this.encode(arg2));
        }
    }

    public void debug(String format, Object ... arguments) {
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.encode(format), this.encode(arguments));
        }
    }

    public boolean isInfoEnabled() {
        return this.log.isInfoEnabled();
    }

    public void info(String message) {
        if (this.log.isInfoEnabled()) {
            this.log.info(this.encode(message));
        }
    }

    public void info(String format, Object arg) {
        if (this.log.isInfoEnabled()) {
            this.log.info(this.encode(format), this.encode(arg));
        }
    }

    public void info(String format, Object arg1, Object arg2) {
        if (this.log.isInfoEnabled()) {
            this.log.info(this.encode(format), this.encode(arg1), this.encode(arg2));
        }
    }

    public void info(String format, Object ... args) {
        if (this.log.isInfoEnabled()) {
            this.log.info(this.encode(format), this.encode(args));
        }
    }

    public boolean isWarnEnabled() {
        return this.log.isWarnEnabled();
    }

    public void warn(String message, Throwable t) {
        if (this.log.isWarnEnabled()) {
            this.log.warn(this.encode(message), t);
        }
    }

    public boolean isErrorEnabled() {
        return this.log.isErrorEnabled();
    }

    public void error(String message) {
        if (this.log.isErrorEnabled()) {
            this.log.error(this.encode(message));
        }
    }

    public void error(String message, Throwable t) {
        if (this.log.isErrorEnabled()) {
            this.log.error(this.encode(message), t);
        }
    }

    public void error(String format, Object arg) {
        if (this.log.isErrorEnabled()) {
            this.log.error(this.encode(format), this.encode(arg));
        }
    }

    public void error(String format, Object arg1, Object arg2) {
        if (this.log.isErrorEnabled()) {
            this.log.error(this.encode(format), this.encode(arg1), this.encode(arg2));
        }
    }

    private String encode(String message) {
        return message.replaceAll("[\n\r]", "_");
    }

    private Object encode(Object argument) {
        if (argument instanceof String) {
            String stringArg = (String)argument;
            return this.encode(stringArg);
        }
        return argument;
    }

    private Object[] encode(Object ... arguments) {
        return ((Stream)Arrays.stream(arguments).sequential()).map(this::encode).toArray();
    }
}

