/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.util.grpc;

import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.TypeRegistry;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.services.BinaryLogProvider;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;

public class GrpcUtil {
    private GrpcUtil() {
    }

    public static Descriptors.MethodDescriptor findMethodDescriptor(String base64ProtobufDescriptor, String serviceName, String methodName) throws InvalidProtocolBufferException, Descriptors.DescriptorValidationException {
        String shortServiceName = serviceName;
        if (serviceName.contains(".")) {
            shortServiceName = serviceName.substring(serviceName.lastIndexOf(".") + 1);
        }
        Descriptors.FileDescriptor fd = GrpcUtil.findFileDescriptorBySymbol(base64ProtobufDescriptor, shortServiceName);
        Descriptors.ServiceDescriptor sd = fd.findServiceByName(shortServiceName);
        return sd.findMethodByName(methodName);
    }

    public static DescriptorProtos.FileDescriptorSet getFileDescriptorSet(String base64ProtobufDescriptor) throws InvalidProtocolBufferException {
        byte[] decodedBinaryPB = Base64.getDecoder().decode(base64ProtobufDescriptor.getBytes(StandardCharsets.UTF_8));
        return DescriptorProtos.FileDescriptorSet.parseFrom((byte[])decodedBinaryPB);
    }

    public static Descriptors.FileDescriptor findFileDescriptorBySymbol(String base64ProtobufDescriptor, String symbol) throws InvalidProtocolBufferException, Descriptors.DescriptorValidationException {
        DescriptorProtos.FileDescriptorSet fds = GrpcUtil.getFileDescriptorSet(base64ProtobufDescriptor);
        if (fds.getFileCount() > 1) {
            ArrayList<Descriptors.FileDescriptor> dependencies = new ArrayList<Descriptors.FileDescriptor>();
            for (int i = 0; i < fds.getFileCount(); ++i) {
                Descriptors.FileDescriptor fd = Descriptors.FileDescriptor.buildFrom((DescriptorProtos.FileDescriptorProto)fds.getFile(i), (Descriptors.FileDescriptor[])dependencies.toArray(new Descriptors.FileDescriptor[dependencies.size()]), (boolean)true);
                dependencies.add(fd);
                if (fd.findServiceByName(symbol) == null && fd.findMessageTypeByName(symbol) == null && fd.findExtensionByName(symbol) == null) continue;
                return fd;
            }
        }
        return Descriptors.FileDescriptor.buildFrom((DescriptorProtos.FileDescriptorProto)fds.getFile(0), (Descriptors.FileDescriptor[])new Descriptors.FileDescriptor[0], (boolean)true);
    }

    public static TypeRegistry buildTypeRegistry(String base64ProtobufDescriptor) throws InvalidProtocolBufferException, Descriptors.DescriptorValidationException {
        DescriptorProtos.FileDescriptorSet fds = GrpcUtil.getFileDescriptorSet(base64ProtobufDescriptor);
        TypeRegistry.Builder registryBuilder = TypeRegistry.newBuilder();
        ArrayList<Descriptors.FileDescriptor> dependencies = new ArrayList<Descriptors.FileDescriptor>();
        for (int i = 0; i < fds.getFileCount(); ++i) {
            Descriptors.FileDescriptor fd = Descriptors.FileDescriptor.buildFrom((DescriptorProtos.FileDescriptorProto)fds.getFile(i), (Descriptors.FileDescriptor[])dependencies.toArray(new Descriptors.FileDescriptor[dependencies.size()]), (boolean)true);
            dependencies.add(fd);
            registryBuilder.add((Iterable)fd.getMessageTypes());
        }
        return registryBuilder.build();
    }

    public static MethodDescriptor<byte[], byte[]> buildGenericUnaryMethodDescriptor(String fullMethodName) {
        return MethodDescriptor.newBuilder((MethodDescriptor.Marshaller)BinaryLogProvider.BYTEARRAY_MARSHALLER, (MethodDescriptor.Marshaller)BinaryLogProvider.BYTEARRAY_MARSHALLER).setType(MethodDescriptor.MethodType.UNARY).setFullMethodName(fullMethodName).build();
    }
}

