/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.util.metadata;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import io.github.microcks.domain.EventMessage;
import io.github.microcks.domain.Exchange;
import io.github.microcks.domain.Header;
import io.github.microcks.domain.Message;
import io.github.microcks.domain.Operation;
import io.github.microcks.domain.Parameter;
import io.github.microcks.domain.Request;
import io.github.microcks.domain.RequestResponsePair;
import io.github.microcks.domain.Resource;
import io.github.microcks.domain.Response;
import io.github.microcks.domain.Service;
import io.github.microcks.domain.ServiceType;
import io.github.microcks.domain.UnidirectionalEvent;
import io.github.microcks.util.DispatchCriteriaHelper;
import io.github.microcks.util.MockRepositoryImportException;
import io.github.microcks.util.MockRepositoryImporter;
import io.github.microcks.util.URIBuilder;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExamplesImporter
implements MockRepositoryImporter {
    private static final Logger log = LoggerFactory.getLogger(ExamplesImporter.class);
    private static final String REQUEST_NODE = "request";
    private static final String RESPONSE_NODE = "response";
    private static final String PARAMETERS_NODE = "parameters";
    private static final String HEADERS_NODE = "headers";
    private static final String BODY_NODE = "body";
    private static final String PAYLOAD_NODE = "payload";
    private final ObjectMapper mapper;
    private final JsonNode spec;

    public ExamplesImporter(String specificationFilePath) throws IOException {
        try {
            byte[] bytes = Files.readAllBytes(Paths.get(specificationFilePath, new String[0]));
            String specContent = new String(bytes, StandardCharsets.UTF_8);
            this.mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
            this.spec = this.mapper.readTree(specContent.getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            log.error("Exception while parsing APIMetadata specification file " + specificationFilePath, (Throwable)e);
            throw new IOException("APIMetadata spec file parsing error");
        }
    }

    @Override
    public List<Service> getServiceDefinitions() throws MockRepositoryImportException {
        ArrayList<Service> result = new ArrayList<Service>();
        Service service = new Service();
        JsonNode metadataNode = this.spec.get("metadata");
        if (metadataNode == null) {
            log.error("Missing mandatory metadata in {}", (Object)this.spec.asText());
            throw new MockRepositoryImportException("Mandatory metadata property is missing in APIMetadata");
        }
        service.setName(metadataNode.path("name").asText());
        service.setVersion(metadataNode.path("version").asText());
        service.setOperations(this.extractOperations());
        result.add(service);
        return result;
    }

    @Override
    public List<Resource> getResourceDefinitions(Service service) throws MockRepositoryImportException {
        return Collections.emptyList();
    }

    @Override
    public List<Exchange> getMessageDefinitions(Service service, Operation operation) throws MockRepositoryImportException {
        ArrayList<Exchange> result = new ArrayList<Exchange>();
        Iterator operations = this.spec.path("operations").fields();
        while (operations.hasNext()) {
            Map.Entry operationEntry = (Map.Entry)operations.next();
            if (!operation.getName().equals(operationEntry.getKey())) continue;
            Iterator examples = ((JsonNode)operationEntry.getValue()).fields();
            while (examples.hasNext()) {
                Map.Entry exampleEntry = (Map.Entry)examples.next();
                result.add(this.extractExchange(service, operation, (String)exampleEntry.getKey(), (JsonNode)exampleEntry.getValue()));
            }
        }
        return result;
    }

    private List<Operation> extractOperations() {
        ArrayList<Operation> results = new ArrayList<Operation>();
        Iterator operations = this.spec.path("operations").fields();
        while (operations.hasNext()) {
            Map.Entry operation = (Map.Entry)operations.next();
            Operation op = new Operation();
            op.setName((String)operation.getKey());
            results.add(op);
        }
        return results;
    }

    private Exchange extractExchange(Service service, Operation operation, String exampleName, JsonNode exampleNode) {
        Object exchange = ServiceType.EVENT.equals((Object)service.getType()) ? this.extractUnidirectionalEvent(exampleName, exampleNode) : this.extractRequestResponsePair(service, operation, exampleName, exampleNode);
        return exchange;
    }

    private UnidirectionalEvent extractUnidirectionalEvent(String exampleName, JsonNode exampleNode) {
        if (exampleNode.has("eventMessage")) {
            JsonNode eventNode = exampleNode.get("eventMessage");
            EventMessage event = new EventMessage();
            event.setName(exampleName);
            if (eventNode.has(HEADERS_NODE)) {
                this.completeWithHeaders((Message)event, eventNode.get(HEADERS_NODE));
            }
            event.setContent(this.getSerializedValue(eventNode.get(PAYLOAD_NODE)));
            return new UnidirectionalEvent(event);
        }
        return null;
    }

    private RequestResponsePair extractRequestResponsePair(Service service, Operation operation, String exampleName, JsonNode exampleNode) {
        if (exampleNode.has(REQUEST_NODE) && exampleNode.has(RESPONSE_NODE)) {
            JsonNode requestNode = exampleNode.get(REQUEST_NODE);
            JsonNode responseNode = exampleNode.get(RESPONSE_NODE);
            Request request = new Request();
            request.setName(exampleName);
            request.setContent(this.getSerializedValue(requestNode.get(BODY_NODE)));
            Multimap<String, String> parameters = null;
            if (requestNode.has(PARAMETERS_NODE)) {
                parameters = this.completeWithParameters(request, requestNode.get(PARAMETERS_NODE));
            }
            if (requestNode.has(HEADERS_NODE)) {
                this.completeWithHeaders((Message)request, requestNode.get(HEADERS_NODE));
            }
            Response response = new Response();
            response.setName(exampleName);
            if (responseNode.has(HEADERS_NODE)) {
                this.completeWithHeaders((Message)response, responseNode.get(HEADERS_NODE));
            }
            if (responseNode.has("mediaType")) {
                String mediaType = responseNode.get("mediaType").asText();
                response.setMediaType(mediaType);
            }
            if (responseNode.has("status")) {
                String status = responseNode.get("status").asText();
                response.setStatus(status);
                if (!status.startsWith("2") || !status.startsWith("3")) {
                    response.setFault(true);
                }
            }
            response.setContent(this.getSerializedValue(responseNode.get(BODY_NODE)));
            DispatchCriteriaHelper.DispatcherDetails details = DispatchCriteriaHelper.extractDispatcherWithRules(operation);
            this.completeDispatchCriteriaAndResourcePaths(service, operation, details.rootDispatcher(), details.rootDispatcherRules(), parameters, requestNode, responseNode, request, response);
            return new RequestResponsePair(request, response);
        }
        return null;
    }

    private Multimap<String, String> completeWithParameters(Request request, JsonNode parametersNode) {
        ArrayListMultimap result = ArrayListMultimap.create();
        Iterator parameters = parametersNode.fields();
        while (parameters.hasNext()) {
            Map.Entry parameterNode = (Map.Entry)parameters.next();
            Parameter parameter = new Parameter();
            parameter.setName((String)parameterNode.getKey());
            parameter.setValue(this.getSerializedValue((JsonNode)parameterNode.getValue()));
            request.addQueryParameter(parameter);
            if (((JsonNode)parameterNode.getValue()).isArray()) {
                for (Object current : (JsonNode)parameterNode.getValue()) {
                    result.put((Object)((String)parameterNode.getKey()), (Object)this.getSerializedValue((JsonNode)current));
                }
                continue;
            }
            if (((JsonNode)parameterNode.getValue()).isObject()) {
                Iterator fieldsIterator = ((JsonNode)parameterNode.getValue()).fields();
                while (fieldsIterator.hasNext()) {
                    Object current;
                    current = (Map.Entry)fieldsIterator.next();
                    result.put((Object)((String)current.getKey()), (Object)this.getSerializedValue((JsonNode)current.getValue()));
                }
                continue;
            }
            result.put((Object)((String)parameterNode.getKey()), (Object)this.getSerializedValue((JsonNode)parameterNode.getValue()));
        }
        return result;
    }

    private void completeWithHeaders(Message message, JsonNode headersNode) {
        Iterator headers = headersNode.fields();
        while (headers.hasNext()) {
            Map.Entry headerNode = (Map.Entry)headers.next();
            Header header = new Header();
            header.setName((String)headerNode.getKey());
            Set values = Arrays.stream(this.getSerializedValue((JsonNode)headerNode.getValue()).split(",")).map(String::trim).collect(Collectors.toSet());
            header.setValues(values);
            message.addHeader(header);
        }
    }

    private void completeDispatchCriteriaAndResourcePaths(Service service, Operation operation, String rootDispatcher, String rootDispatcherRules, Multimap<String, String> parameters, JsonNode requestNode, JsonNode responseNode, Request request, Response response) {
        String resourcePathPattern;
        Object dispatchCriteria = null;
        String string = resourcePathPattern = operation.getName().contains(" ") ? operation.getName().split(" ")[1] : operation.getName();
        if ("URI_PARAMS".equals(rootDispatcher)) {
            dispatchCriteria = DispatchCriteriaHelper.buildFromParamsMap(rootDispatcherRules, parameters);
            operation.addResourcePath(resourcePathPattern);
        } else if ("URI_PARTS".equals(rootDispatcher)) {
            dispatchCriteria = DispatchCriteriaHelper.buildFromPartsMap(rootDispatcherRules, parameters);
            String resourcePath = URIBuilder.buildURIFromPattern(resourcePathPattern, parameters);
            operation.addResourcePath(resourcePath);
        } else if ("URI_ELEMENTS".equals(rootDispatcher)) {
            Multimap pathParameters = Multimaps.filterEntries(parameters, entry -> operation.getName().contains("/{" + (String)entry.getKey() + "}") || operation.getName().contains("/:" + (String)entry.getKey()));
            Multimap queryParameters = Multimaps.filterEntries(parameters, entry -> !pathParameters.containsKey(entry.getKey()));
            dispatchCriteria = DispatchCriteriaHelper.buildFromPartsMap(rootDispatcherRules, (Multimap<String, String>)pathParameters);
            dispatchCriteria = (String)dispatchCriteria + DispatchCriteriaHelper.buildFromParamsMap(rootDispatcherRules, (Multimap<String, String>)queryParameters);
            String resourcePath = URIBuilder.buildURIFromPattern(resourcePathPattern, parameters);
            operation.addResourcePath(resourcePath);
        } else if ("QUERY_ARGS".equals(rootDispatcher)) {
            if (ServiceType.GRAPHQL.equals((Object)service.getType()) && requestNode.has(BODY_NODE)) {
                JsonNode variables = requestNode.get(BODY_NODE).path("variables");
                dispatchCriteria = this.extractQueryArgsCriteria(rootDispatcherRules, variables);
            } else if (ServiceType.GRPC.equals((Object)service.getType())) {
                dispatchCriteria = this.extractQueryArgsCriteria(rootDispatcherRules, request.getContent());
            }
        } else if (responseNode.has("dispatchCriteria")) {
            dispatchCriteria = responseNode.get("dispatchCriteria").asText();
        }
        operation.addResourcePath(resourcePathPattern);
        response.setDispatchCriteria((String)dispatchCriteria);
    }

    private String extractQueryArgsCriteria(String dispatcherRules, JsonNode variables) {
        String dispatchCriteria = "";
        try {
            Map paramsMap = (Map)this.mapper.convertValue((Object)variables, (JavaType)TypeFactory.defaultInstance().constructMapType(TreeMap.class, String.class, String.class));
            dispatchCriteria = DispatchCriteriaHelper.extractFromParamMap(dispatcherRules, paramsMap);
        }
        catch (Exception e) {
            log.error("Exception while converting dispatch criteria from JSON body: {}", (Object)e.getMessage());
        }
        return dispatchCriteria;
    }

    private String extractQueryArgsCriteria(String dispatcherRules, String variables) {
        String dispatchCriteria = "";
        try {
            Map paramsMap = (Map)this.mapper.readValue(variables, (JavaType)TypeFactory.defaultInstance().constructMapType(TreeMap.class, String.class, String.class));
            dispatchCriteria = DispatchCriteriaHelper.extractFromParamMap(dispatcherRules, paramsMap);
        }
        catch (Exception e) {
            log.error("Exception while extracting dispatch criteria from JSON body: {}", (Object)e.getMessage());
        }
        return dispatchCriteria;
    }

    private String getSerializedValue(JsonNode contentNode) {
        if (contentNode != null) {
            if (contentNode.getNodeType() == JsonNodeType.ARRAY || contentNode.getNodeType() == JsonNodeType.OBJECT) {
                return contentNode.toString();
            }
            return contentNode.asText();
        }
        return null;
    }
}

