/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.util.soapui;

import io.github.microcks.util.WritableNamespaceContext;
import io.github.microcks.util.soapui.SoapUIXPathBuilder;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XmlHolder
implements Map<String, Object> {
    private static Logger log = LoggerFactory.getLogger(XmlHolder.class);
    private Element xmlObject;
    private Map<String, String> declaredNamespaces;
    private XPath xpath;

    public XmlHolder(String xml) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newDefaultInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = factory.newDocumentBuilder();
        this.xmlObject = documentBuilder.parse(new InputSource(new StringReader(xml))).getDocumentElement();
        this.xpath = XPathFactory.newInstance().newXPath();
        this.updateXPathNamespaces(this.readXPathNamespaces());
    }

    private void updateXPathNamespaces(Map<String, String> declaredNamespaces) {
        WritableNamespaceContext nsContext = new WritableNamespaceContext();
        for (Map.Entry<String, String> entry : declaredNamespaces.entrySet()) {
            nsContext.addNamespaceURI(entry.getKey(), entry.getValue());
        }
        this.xpath.setNamespaceContext(nsContext);
    }

    private Map<String, String> readXPathNamespaces() {
        HashMap<String, String> namespaces = new HashMap<String, String>();
        XmlHolder.addNamespacesToMap(this.xmlObject, namespaces);
        return namespaces;
    }

    private static void addNamespacesToMap(Node node, Map<String, String> namespaces) {
        NamedNodeMap attributes = node.getAttributes();
        if (attributes != null) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                Node attribute = attributes.item(i);
                if (attribute.getNodeType() != 2 || attribute.getNamespaceURI() == null) continue;
                namespaces.put(XmlHolder.getLocalPart(attribute.getNodeName()), attribute.getNodeValue());
            }
        }
        NodeList child = node.getChildNodes();
        for (int i = 0; i < child.getLength(); ++i) {
            XmlHolder.addNamespacesToMap(child.item(i), namespaces);
        }
    }

    private static String getLocalPart(String localPart) {
        localPart = localPart.substring(localPart.indexOf(":") + 1);
        return localPart;
    }

    private XPathExpression compileXPath(String xpathExpression) throws XPathExpressionException {
        if (xpathExpression.trim().startsWith("declare namespace")) {
            return SoapUIXPathBuilder.buildXPathMatcherFromRules(xpathExpression);
        }
        return this.xpath.compile(xpathExpression);
    }

    public String getXml() throws Exception {
        TransformerFactory transformerFactory = TransformerFactory.newDefaultInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        StringWriter out = new StringWriter();
        transformer.transform(new DOMSource(this.xmlObject), new StreamResult(out));
        return ((Object)out).toString();
    }

    public Map<String, String> getNamespaces() {
        if (this.declaredNamespaces == null) {
            this.declaredNamespaces = new HashMap<String, String>();
        }
        return this.declaredNamespaces;
    }

    public void declareNamespace(String prefix, String uri) {
        if (this.declaredNamespaces == null) {
            this.declaredNamespaces = new HashMap<String, String>();
        }
        this.declaredNamespaces.put(prefix, uri);
        this.updateXPathNamespaces(this.declaredNamespaces);
    }

    public String getNodeValue(String xpathExpression) throws Exception {
        XPathExpression expression = this.compileXPath(xpathExpression);
        return expression.evaluate(this.xmlObject);
    }

    public String[] getNodeValues(String xpathExpression) throws Exception {
        XPathExpression expression = this.compileXPath(xpathExpression);
        NodeList nodeList = (NodeList)expression.evaluate(this.xmlObject, XPathConstants.NODESET);
        String[] results = new String[nodeList.getLength()];
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            results[i] = node.getTextContent();
        }
        return results;
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean containsKey(Object key) {
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        return false;
    }

    @Override
    public Object get(Object key) {
        String str = key.toString();
        try {
            if (str.equals("xml") || str.equals("prettyXml")) {
                return this.getXml();
            }
            if (str.equals("namespaces")) {
                return this.getNamespaces();
            }
            String[] nodeValues = this.getNodeValues(str);
            return nodeValues != null && nodeValues.length == 1 ? nodeValues[0] : nodeValues;
        }
        catch (Exception e) {
            log.error("Exception while getting key {}", key, (Object)e);
            return null;
        }
    }

    @Override
    public Object put(String key, Object value) {
        return null;
    }

    @Override
    public Object remove(Object key) {
        return null;
    }

    @Override
    public void putAll(Map<? extends String, ?> m) {
        for (Map.Entry<String, ?> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
    }

    @Override
    public Set<String> keySet() {
        return null;
    }

    @Override
    public Collection<Object> values() {
        return null;
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return null;
    }
}

