/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.web;

import io.github.microcks.domain.GenericResource;
import io.github.microcks.domain.Operation;
import io.github.microcks.domain.Service;
import io.github.microcks.domain.ServiceType;
import io.github.microcks.event.MockInvocationEvent;
import io.github.microcks.repository.GenericResourceRepository;
import io.github.microcks.repository.ServiceRepository;
import io.github.microcks.util.SafeLogger;
import io.github.microcks.util.el.EvaluableRequest;
import io.github.microcks.util.el.TemplateEngine;
import io.github.microcks.util.el.TemplateEngineFactory;
import io.github.microcks.web.MockControllerCommons;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.bson.Document;
import org.bson.json.JsonParseException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriUtils;

@RestController
@RequestMapping(value={"/dynarest"})
public class DynamicMockRestController {
    private static final SafeLogger log = SafeLogger.getLogger(DynamicMockRestController.class);
    public static final String ID_FIELD = "id";
    private final ServiceRepository serviceRepository;
    private final GenericResourceRepository genericResourceRepository;
    private final ApplicationContext applicationContext;
    @Value(value="${mocks.enable-invocation-stats}")
    private final Boolean enableInvocationStats = null;

    public DynamicMockRestController(ServiceRepository serviceRepository, GenericResourceRepository genericResourceRepository, ApplicationContext applicationContext) {
        this.serviceRepository = serviceRepository;
        this.genericResourceRepository = genericResourceRepository;
        this.applicationContext = applicationContext;
    }

    @PostMapping(value={"/{service}/{version}/{resource}"}, produces={"application/json"})
    public ResponseEntity<String> createResource(@PathVariable(value="service") String serviceName, @PathVariable(value="version") String version, @PathVariable(value="resource") String resource, @RequestParam(value="delay", required=false) Long delay, @RequestBody(required=true) String body, HttpServletRequest request) {
        log.debug("Creating a new resource '{}' for service '{}-{}'", resource, serviceName, version);
        long startTime = System.currentTimeMillis();
        serviceName = this.sanitizeServiceName(serviceName);
        MockContext mockContext = this.getMockContext(serviceName, version, "POST /" + resource);
        if (mockContext != null) {
            Document document = null;
            GenericResource genericResource = null;
            try {
                document = Document.parse((String)body);
                genericResource = new GenericResource();
                genericResource.setServiceId(mockContext.service.getId());
                genericResource.setPayload(document);
                genericResource = (GenericResource)this.genericResourceRepository.save(genericResource);
            }
            catch (JsonParseException jpe) {
                return new ResponseEntity((HttpStatusCode)HttpStatus.UNPROCESSABLE_ENTITY);
            }
            document.append(ID_FIELD, (Object)genericResource.getId());
            this.waitForDelay(startTime, delay, mockContext);
            return new ResponseEntity((Object)document.toJson(), (HttpStatusCode)HttpStatus.CREATED);
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.BAD_REQUEST);
    }

    @GetMapping(value={"/{service}/{version}/{resource}"}, produces={"application/json"})
    public ResponseEntity<String> findResources(@PathVariable(value="service") String serviceName, @PathVariable(value="version") String version, @PathVariable(value="resource") String resource, @RequestParam(value="page", required=false, defaultValue="0") int page, @RequestParam(value="size", required=false, defaultValue="20") int size, @RequestParam(value="delay", required=false) Long delay, @RequestBody(required=false) String body, HttpServletRequest request) {
        log.debug("Find resources '{}' for service '{}-{}'", resource, serviceName, version);
        long startTime = System.currentTimeMillis();
        serviceName = this.sanitizeServiceName(serviceName);
        String requestURI = request.getRequestURI();
        String serviceAndVersion = "/" + UriUtils.encodeFragment((String)serviceName, (String)"UTF-8") + "/" + version;
        String resourcePath = requestURI.substring(requestURI.indexOf(serviceAndVersion) + serviceAndVersion.length());
        MockContext mockContext = this.getMockContext(serviceName, version, "GET /" + resource);
        if (mockContext != null) {
            List<GenericResource> genericResources = null;
            genericResources = body == null ? this.genericResourceRepository.findByServiceId(mockContext.service.getId(), (Pageable)PageRequest.of((int)page, (int)size)) : this.genericResourceRepository.findByServiceIdAndJSONQuery(mockContext.service.getId(), body);
            EvaluableRequest evaluableRequest = MockControllerCommons.buildEvaluableRequest(body, resourcePath, request);
            TemplateEngine engine = TemplateEngineFactory.getTemplateEngine();
            List<String> resources = genericResources.stream().map(genericResource -> MockControllerCommons.renderResponseContent(evaluableRequest, engine, this.transformToResourceJSON((GenericResource)genericResource))).collect(Collectors.toList());
            this.waitForDelay(startTime, delay, mockContext);
            MockControllerCommons.waitForDelay(startTime, delay);
            return new ResponseEntity((Object)this.formatToJSONArray(resources), (HttpStatusCode)HttpStatus.OK);
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.BAD_REQUEST);
    }

    @GetMapping(value={"/{service}/{version}/{resource}/{resourceId}"}, produces={"application/json"})
    public ResponseEntity<String> getResource(@PathVariable(value="service") String serviceName, @PathVariable(value="version") String version, @PathVariable(value="resource") String resource, @PathVariable(value="resourceId") String resourceId, @RequestParam(value="delay", required=false) Long delay, HttpServletRequest request) {
        log.debug("Get resource '{}:{}' for service '{}-{}'", resource, resourceId, serviceName, version);
        long startTime = System.currentTimeMillis();
        serviceName = this.sanitizeServiceName(serviceName);
        String requestURI = request.getRequestURI();
        String serviceAndVersion = "/" + UriUtils.encodeFragment((String)serviceName, (String)"UTF-8") + "/" + version;
        String resourcePath = requestURI.substring(requestURI.indexOf(serviceAndVersion) + serviceAndVersion.length());
        MockContext mockContext = this.getMockContext(serviceName, version, "GET /" + resource + "/:id");
        if (mockContext != null) {
            GenericResource genericResource = this.genericResourceRepository.findById(resourceId).orElse(null);
            this.waitForDelay(startTime, delay, mockContext);
            if (genericResource != null) {
                EvaluableRequest evaluableRequest = MockControllerCommons.buildEvaluableRequest(null, resourcePath, request);
                TemplateEngine engine = TemplateEngineFactory.getTemplateEngine();
                return new ResponseEntity((Object)MockControllerCommons.renderResponseContent(evaluableRequest, engine, this.transformToResourceJSON(genericResource)), (HttpStatusCode)HttpStatus.OK);
            }
            return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.BAD_REQUEST);
    }

    @PutMapping(value={"/{service}/{version}/{resource}/{resourceId}"}, produces={"application/json"})
    public ResponseEntity<String> updateResource(@PathVariable(value="service") String serviceName, @PathVariable(value="version") String version, @PathVariable(value="resource") String resource, @PathVariable(value="resourceId") String resourceId, @RequestParam(value="delay", required=false) Long delay, @RequestBody(required=true) String body, HttpServletRequest request) {
        log.debug("Update resource '{}:{}' for service '{}-{}'", resource, resourceId, serviceName, version);
        long startTime = System.currentTimeMillis();
        serviceName = this.sanitizeServiceName(serviceName);
        MockContext mockContext = this.getMockContext(serviceName, version, "PUT /" + resource + "/:id");
        if (mockContext != null) {
            GenericResource genericResource = this.genericResourceRepository.findById(resourceId).orElse(null);
            if (genericResource != null) {
                Document document = null;
                try {
                    document = Document.parse((String)body);
                    document.remove((Object)ID_FIELD);
                    genericResource.setPayload(document);
                    this.genericResourceRepository.save(genericResource);
                }
                catch (JsonParseException jpe) {
                    return new ResponseEntity((HttpStatusCode)HttpStatus.UNPROCESSABLE_ENTITY);
                }
                this.waitForDelay(startTime, delay, mockContext);
                return new ResponseEntity((Object)this.transformToResourceJSON(genericResource), (HttpStatusCode)HttpStatus.OK);
            }
            this.waitForDelay(startTime, delay, mockContext);
            return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.BAD_REQUEST);
    }

    @DeleteMapping(value={"/{service}/{version}/{resource}/{resourceId}"})
    public ResponseEntity<String> deleteResource(@PathVariable(value="service") String serviceName, @PathVariable(value="version") String version, @PathVariable(value="resource") String resource, @PathVariable(value="resourceId") String resourceId, @RequestParam(value="delay", required=false) Long delay) {
        log.debug("Update resource '{}:{}' for service '{}-{}'", resource, resourceId, serviceName, version);
        long startTime = System.currentTimeMillis();
        serviceName = this.sanitizeServiceName(serviceName);
        MockContext mockContext = this.getMockContext(serviceName, version, "DELETE /" + resource + "/:id");
        if (mockContext != null) {
            this.genericResourceRepository.deleteById(resourceId);
            this.waitForDelay(startTime, delay, mockContext);
            return new ResponseEntity((HttpStatusCode)HttpStatus.NO_CONTENT);
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.BAD_REQUEST);
    }

    private String sanitizeServiceName(String serviceName) {
        if (serviceName.contains("+")) {
            return serviceName.replace('+', ' ');
        }
        return serviceName;
    }

    private MockContext getMockContext(String serviceName, String version, String operationName) {
        Service service = this.serviceRepository.findByNameAndVersion(serviceName, version);
        if (service != null && ServiceType.GENERIC_REST.equals((Object)service.getType())) {
            for (Operation operation : service.getOperations()) {
                if (!operationName.equals(operation.getName())) continue;
                return new MockContext(service, operation);
            }
        }
        return null;
    }

    private String transformToResourceJSON(GenericResource genericResource) {
        Document document = genericResource.getPayload();
        document.append(ID_FIELD, (Object)genericResource.getId());
        return document.toJson();
    }

    private String formatToJSONArray(List<String> resources) {
        StringBuilder builder = new StringBuilder("[");
        for (int i = 0; i < resources.size(); ++i) {
            builder.append(resources.get(i));
            if (i >= resources.size() - 1) continue;
            builder.append(", ");
        }
        return builder.append("]").toString();
    }

    private void waitForDelay(Long since, Long delay, MockContext mockContext) {
        if (delay == null && mockContext.operation.getDefaultDelay() != null) {
            delay = mockContext.operation.getDefaultDelay();
        }
        MockControllerCommons.waitForDelay(since, delay);
        if (Boolean.TRUE.equals(this.enableInvocationStats)) {
            MockInvocationEvent event = new MockInvocationEvent(this, mockContext.service.getName(), mockContext.service.getVersion(), "DynamicMockRestController", new Date(since), since - System.currentTimeMillis());
            this.applicationContext.publishEvent((ApplicationEvent)event);
            log.debug("Mock invocation event has been published");
        }
    }

    private class MockContext {
        public Service service;
        public Operation operation;

        public MockContext(Service service, Operation operation) {
            this.service = service;
            this.operation = operation;
        }
    }
}

