/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.web;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.TypeRegistry;
import com.google.protobuf.util.JsonFormat;
import io.github.microcks.domain.Operation;
import io.github.microcks.domain.Resource;
import io.github.microcks.domain.ResourceType;
import io.github.microcks.domain.Response;
import io.github.microcks.domain.Service;
import io.github.microcks.repository.ResourceRepository;
import io.github.microcks.repository.ResponseRepository;
import io.github.microcks.repository.ServiceRepository;
import io.github.microcks.repository.ServiceStateRepository;
import io.github.microcks.service.ServiceStateStore;
import io.github.microcks.util.DispatchCriteriaHelper;
import io.github.microcks.util.IdBuilder;
import io.github.microcks.util.dispatcher.FallbackSpecification;
import io.github.microcks.util.dispatcher.JsonEvaluationSpecification;
import io.github.microcks.util.dispatcher.JsonExpressionEvaluator;
import io.github.microcks.util.dispatcher.JsonMappingException;
import io.github.microcks.util.grpc.GrpcUtil;
import io.github.microcks.util.script.ScriptEngineBinder;
import io.github.microcks.web.DispatchContext;
import io.github.microcks.web.MockControllerCommons;
import io.grpc.ServerCallHandler;
import io.grpc.Status;
import io.grpc.stub.ServerCalls;
import io.grpc.stub.StreamObserver;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class GrpcServerCallHandler {
    private static final Logger log = LoggerFactory.getLogger(GrpcServerCallHandler.class);
    private final ServiceRepository serviceRepository;
    private final ServiceStateRepository serviceStateRepository;
    private final ResourceRepository resourceRepository;
    private final ResponseRepository responseRepository;
    private final ApplicationContext applicationContext;
    private final ObjectMapper mapper = new ObjectMapper();
    @Value(value="${mocks.enable-invocation-stats}")
    private Boolean enableInvocationStats;

    public GrpcServerCallHandler(ServiceRepository serviceRepository, ServiceStateRepository serviceStateRepository, ResourceRepository resourceRepository, ResponseRepository responseRepository, ApplicationContext applicationContext) {
        this.serviceRepository = serviceRepository;
        this.serviceStateRepository = serviceStateRepository;
        this.resourceRepository = resourceRepository;
        this.responseRepository = responseRepository;
        this.applicationContext = applicationContext;
    }

    public ServerCallHandler<byte[], byte[]> getUnaryServerCallHandler(String fullMethodName) {
        return ServerCalls.asyncUnaryCall((ServerCalls.UnaryMethod)new MockedUnaryMethod(fullMethodName));
    }

    protected class MockedUnaryMethod
    implements ServerCalls.UnaryMethod<byte[], byte[]> {
        private String fullMethodName;
        private String serviceName;
        private String serviceVersion;
        private String operationName;

        public MockedUnaryMethod(String fullMethodName) {
            this.fullMethodName = fullMethodName;
            this.operationName = fullMethodName.substring(fullMethodName.indexOf("/") + 1);
            this.serviceName = fullMethodName.substring(0, fullMethodName.indexOf("/"));
            String packageName = fullMethodName.substring(0, fullMethodName.lastIndexOf("."));
            String[] parts = packageName.split("\\.");
            this.serviceVersion = parts.length > 2 ? parts[parts.length - 1] : packageName;
        }

        public void invoke(byte[] bytes, StreamObserver<byte[]> streamObserver) {
            log.info("Servicing mock response for service [{}, {}] and method {}", new Object[]{this.serviceName, this.serviceVersion, this.operationName});
            long startTime = System.currentTimeMillis();
            try {
                Service service = GrpcServerCallHandler.this.serviceRepository.findByNameAndVersion(this.serviceName, this.serviceVersion);
                if (service == null) {
                    log.debug("No GRPC Service def found for [{}, {}]", (Object)this.serviceName, (Object)this.serviceVersion);
                    streamObserver.onError((Throwable)Status.UNIMPLEMENTED.withDescription("No GRPC Service def found for " + this.fullMethodName).asException());
                    return;
                }
                Operation grpcOperation = null;
                for (Operation operation : service.getOperations()) {
                    if (!operation.getName().equals(this.operationName)) continue;
                    grpcOperation = operation;
                    break;
                }
                if (grpcOperation != null) {
                    List<Resource> resources;
                    log.debug("Found a valid operation {} with rules: {}", (Object)grpcOperation.getName(), (Object)grpcOperation.getDispatcherRules());
                    String dispatcher = grpcOperation.getDispatcher();
                    String dispatcherRules = grpcOperation.getDispatcherRules();
                    FallbackSpecification fallback = MockControllerCommons.getFallbackIfAny(grpcOperation);
                    if (fallback != null) {
                        dispatcher = fallback.getDispatcher();
                        dispatcherRules = fallback.getDispatcherRules();
                    }
                    if ((resources = GrpcServerCallHandler.this.resourceRepository.findByServiceIdAndType(service.getId(), ResourceType.PROTOBUF_DESCRIPTOR)) == null || resources.size() != 1) {
                        log.error("Did not found any pre-processed Protobuf binary descriptor...");
                        streamObserver.onError((Throwable)Status.FAILED_PRECONDITION.withDescription("No pre-processed Protobuf binary descriptor found").asException());
                        return;
                    }
                    Resource pbResource = resources.get(0);
                    Descriptors.MethodDescriptor md = GrpcUtil.findMethodDescriptor(pbResource.getContent(), this.serviceName, this.operationName);
                    TypeRegistry registry = GrpcUtil.buildTypeRegistry(pbResource.getContent());
                    DynamicMessage inMsg = DynamicMessage.parseFrom((Descriptors.Descriptor)md.getInputType(), (byte[])bytes);
                    String jsonBody = JsonFormat.printer().usingTypeRegistry(registry).print((MessageOrBuilder)inMsg);
                    log.debug("Request body: {}", (Object)jsonBody);
                    DispatchContext dispatchContext = this.computeDispatchCriteria(service, dispatcher, dispatcherRules, jsonBody);
                    log.debug("Dispatch criteria for finding response is {}", (Object)dispatchContext.dispatchCriteria());
                    List<Response> responses = this.findCandidateResponses(service, grpcOperation, dispatchContext, fallback);
                    if (!responses.isEmpty()) {
                        this.manageResponseTransmission(streamObserver, service, grpcOperation, md, registry, dispatchContext, jsonBody, responses.get(0), startTime);
                    } else {
                        log.info("No appropriate response found for this input {}, returning an error", (Object)jsonBody);
                        streamObserver.onError((Throwable)Status.NOT_FOUND.withDescription("No response found for the GRPC input request").asException());
                    }
                } else {
                    log.debug("No valid operation found for [{}, {}] and {}", new Object[]{this.serviceName, this.serviceVersion, this.operationName});
                    streamObserver.onError((Throwable)Status.UNIMPLEMENTED.withDescription("No valid operation found for " + this.fullMethodName).asException());
                }
            }
            catch (Exception t) {
                log.error("Unexpected throwable during GRPC input request processing", (Throwable)t);
                streamObserver.onError((Throwable)Status.UNKNOWN.withDescription("Unexpected throwable during GRPC input request processing").withCause((Throwable)t).asException());
            }
        }

        private DispatchContext computeDispatchCriteria(Service service, String dispatcher, String dispatcherRules, String jsonBody) {
            String dispatchCriteria = null;
            HashMap<String, Object> requestContext = null;
            if (dispatcher != null) {
                switch (dispatcher) {
                    case "QUERY_ARGS": {
                        try {
                            Map paramsMap = (Map)GrpcServerCallHandler.this.mapper.readValue(jsonBody, (JavaType)TypeFactory.defaultInstance().constructMapType(TreeMap.class, String.class, String.class));
                            dispatchCriteria = DispatchCriteriaHelper.extractFromParamMap(dispatcherRules, paramsMap);
                        }
                        catch (JsonProcessingException jpe) {
                            log.error("Incoming body cannot be parsed as JSON", (Throwable)jpe);
                        }
                        break;
                    }
                    case "JSON_BODY": {
                        try {
                            JsonEvaluationSpecification specification = JsonEvaluationSpecification.buildFromJsonString(dispatcherRules);
                            dispatchCriteria = JsonExpressionEvaluator.evaluate(jsonBody, specification);
                        }
                        catch (JsonMappingException jme) {
                            log.error("Dispatching rules of operation cannot be interpreted as JsonEvaluationSpecification", (Throwable)jme);
                        }
                        break;
                    }
                    case "SCRIPT": {
                        ScriptEngineManager sem = new ScriptEngineManager();
                        requestContext = new HashMap<String, Object>();
                        try {
                            ScriptEngine se = sem.getEngineByExtension("groovy");
                            ScriptEngineBinder.bindEnvironment(se, jsonBody, requestContext, new ServiceStateStore(GrpcServerCallHandler.this.serviceStateRepository, service.getId()));
                            dispatchCriteria = (String)se.eval(dispatcherRules);
                        }
                        catch (Exception e) {
                            log.error("Error during Script evaluation", (Throwable)e);
                        }
                        break;
                    }
                }
            }
            return new DispatchContext(dispatchCriteria, requestContext);
        }

        private List<Response> findCandidateResponses(Service service, Operation grpcOperation, DispatchContext dispatchContext, FallbackSpecification fallback) {
            List<Response> responses = GrpcServerCallHandler.this.responseRepository.findByOperationIdAndDispatchCriteria(IdBuilder.buildOperationId((Service)service, (Operation)grpcOperation), dispatchContext.dispatchCriteria());
            if (responses.isEmpty()) {
                responses = GrpcServerCallHandler.this.responseRepository.findByOperationIdAndName(IdBuilder.buildOperationId((Service)service, (Operation)grpcOperation), dispatchContext.dispatchCriteria());
            }
            if (responses.isEmpty() && fallback != null) {
                responses = GrpcServerCallHandler.this.responseRepository.findByOperationIdAndName(IdBuilder.buildOperationId((Service)service, (Operation)grpcOperation), fallback.getFallback());
            }
            if (responses.isEmpty()) {
                log.debug("No responses found so far, tempting with just bare operationId...");
                responses = GrpcServerCallHandler.this.responseRepository.findByOperationId(IdBuilder.buildOperationId((Service)service, (Operation)grpcOperation));
            }
            return responses;
        }

        private void manageResponseTransmission(StreamObserver<byte[]> streamObserver, Service service, Operation grpcOperation, Descriptors.MethodDescriptor md, TypeRegistry registry, DispatchContext dispatchContext, String requestJsonBody, Response response, long startTime) throws InvalidProtocolBufferException {
            DynamicMessage.Builder outBuilder = DynamicMessage.newBuilder((Descriptors.Descriptor)md.getOutputType());
            String responseContent = MockControllerCommons.renderResponseContent(requestJsonBody, dispatchContext.requestContext(), response);
            JsonFormat.parser().usingTypeRegistry(registry).merge(responseContent, (Message.Builder)outBuilder);
            DynamicMessage outMsg = outBuilder.build();
            if (grpcOperation.getDefaultDelay() != null) {
                MockControllerCommons.waitForDelay(startTime, grpcOperation.getDefaultDelay());
            }
            if (Boolean.TRUE.equals(GrpcServerCallHandler.this.enableInvocationStats)) {
                MockControllerCommons.publishMockInvocation(GrpcServerCallHandler.this.applicationContext, this, service, response, startTime);
            }
            streamObserver.onNext((Object)outMsg.toByteArray());
            streamObserver.onCompleted();
        }
    }
}

