/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.web;

import io.github.microcks.domain.DailyStatistic;
import io.github.microcks.domain.TestConformanceMetric;
import io.github.microcks.domain.WeightedMetricValue;
import io.github.microcks.repository.CustomDailyStatisticRepository;
import io.github.microcks.repository.DailyStatisticRepository;
import io.github.microcks.repository.TestConformanceMetricRepository;
import io.github.microcks.repository.TestResultRepository;
import io.github.microcks.util.SafeLogger;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
public class MetricsController {
    private static final SafeLogger log = SafeLogger.getLogger(MetricsController.class);
    private final DailyStatisticRepository invocationsRepository;
    private final TestConformanceMetricRepository metricRepository;
    private final TestResultRepository testResultRepository;

    public MetricsController(DailyStatisticRepository invocationsRepository, TestConformanceMetricRepository metricRepository, TestResultRepository testResultRepository) {
        this.invocationsRepository = invocationsRepository;
        this.metricRepository = metricRepository;
        this.testResultRepository = testResultRepository;
    }

    @GetMapping(value={"/metrics/invocations/global"})
    public DailyStatistic getInvocationStatGlobal(@RequestParam(value="day", required=false) String day) {
        log.debug("Getting invocations stats for day {}", (Object)day);
        if (day == null) {
            day = this.getTodaysDate();
        }
        return this.invocationsRepository.aggregateDailyStatistics(day);
    }

    @GetMapping(value={"/metrics/invocations/top"})
    public List<DailyStatistic> getInvocationTopStats(@RequestParam(value="day", required=false) String day, @RequestParam(value="limit", required=false, defaultValue="20") Integer limit) {
        log.debug("Getting top {} invocations stats for day {}", (Object)limit, (Object)day);
        if (day == null) {
            day = this.getTodaysDate();
        }
        return this.invocationsRepository.findTopStatistics(day, limit);
    }

    @GetMapping(value={"/metrics/invocations/{service}/{version}"})
    public DailyStatistic getInvocationStatForService(@PathVariable(value="service") String serviceName, @PathVariable(value="version") String serviceVersion, @RequestParam(value="day", required=false) String day) {
        List<DailyStatistic> statistics;
        log.debug("Getting invocations stats for service [{}, {}] and day {}", serviceName, serviceVersion, day);
        if (day == null) {
            day = this.getTodaysDate();
        }
        if (!(statistics = this.invocationsRepository.findByDayAndServiceNameAndServiceVersion(day, serviceName, serviceVersion)).isEmpty()) {
            return statistics.get(0);
        }
        return null;
    }

    @GetMapping(value={"/metrics/invocations/global/latest"})
    public Map<String, Long> getLatestInvocationStatGlobal(@RequestParam(value="limit", required=false, defaultValue="20") Integer limit) {
        log.debug("Getting invocations stats for last {} days", (Object)limit);
        String day = this.getTodaysDate();
        String dayBefore = this.getPastDateAsString(limit);
        TreeMap<String, Long> invocations = new TreeMap<String, Long>();
        List results = this.invocationsRepository.aggregateDailyStatistics(dayBefore, day);
        for (CustomDailyStatisticRepository.InvocationCount count : results) {
            invocations.put(count.getDay(), count.getNumber());
        }
        return invocations;
    }

    @GetMapping(value={"/metrics/conformance/aggregate"})
    public List<WeightedMetricValue> getAggregatedTestCoverageMetrics() {
        log.debug("Computing TestConformanceMetric aggregates");
        return this.metricRepository.aggregateTestConformanceMetric();
    }

    @GetMapping(value={"/metrics/conformance/service/{serviceId:.+}"})
    public TestConformanceMetric getTestConformanceMetric(@PathVariable(value="serviceId") String serviceId) {
        log.debug("Retrieving TestConformanceMetric for service with id {}", (Object)serviceId);
        return this.metricRepository.findByServiceId(serviceId);
    }

    @GetMapping(value={"/metrics/tests/latest"})
    public List<TestResultSummary> getLatestTestResults(@RequestParam(value="limit", required=false, defaultValue="7") Integer limit) {
        log.debug("Getting tests trend for last {} days", (Object)limit);
        Date lastDate = this.getPastDate(limit);
        return this.testResultRepository.findAllWithTestDateAfter(lastDate).stream().map(res -> new TestResultSummary(res.getId(), res.getTestDate(), res.getServiceId(), res.isSuccess())).collect(Collectors.toList());
    }

    private String getTodaysDate() {
        Calendar calendar = Calendar.getInstance();
        int month = calendar.get(2) + 1;
        String monthStr = (month < 10 ? "0" : "") + String.valueOf(month);
        int dayOfMonth = calendar.get(5);
        String dayOfMonthStr = (dayOfMonth < 10 ? "0" : "") + String.valueOf(dayOfMonth);
        return String.valueOf(calendar.get(1)) + monthStr + dayOfMonthStr;
    }

    private Date getPastDate(Integer daysBack) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(6, -daysBack.intValue());
        return calendar.getTime();
    }

    private String getPastDateAsString(Integer daysBack) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(6, -daysBack.intValue());
        int month = calendar.get(2) + 1;
        String monthStr = (month < 10 ? "0" : "") + month;
        int dayOfMonth = calendar.get(5);
        String dayOfMonthStr = (dayOfMonth < 10 ? "0" : "") + dayOfMonth;
        return calendar.get(1) + monthStr + dayOfMonthStr;
    }

    public static class TestResultSummary {
        String id;
        Date testDate;
        String serviceId;
        boolean success;

        public TestResultSummary(String id, Date testDate, String serviceId, boolean success) {
            this.id = id;
            this.testDate = testDate;
            this.serviceId = serviceId;
            this.success = success;
        }

        public String getId() {
            return this.id;
        }

        public Date getTestDate() {
            return this.testDate;
        }

        public String getServiceId() {
            return this.serviceId;
        }

        public boolean isSuccess() {
            return this.success;
        }
    }
}

