/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.web;

import com.fasterxml.jackson.databind.JsonNode;
import io.github.microcks.domain.GenericResource;
import io.github.microcks.domain.Operation;
import io.github.microcks.domain.Resource;
import io.github.microcks.domain.Service;
import io.github.microcks.domain.ServiceType;
import io.github.microcks.repository.GenericResourceRepository;
import io.github.microcks.repository.ResourceRepository;
import io.github.microcks.repository.ServiceRepository;
import io.github.microcks.util.ResourceUtil;
import io.github.microcks.util.SafeLogger;
import io.github.microcks.util.openapi.OpenAPISchemaBuilder;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Optional;
import org.bson.Document;
import org.springframework.http.ContentDisposition;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
public class ResourceController {
    private static final SafeLogger log = SafeLogger.getLogger(ResourceController.class);
    private static final String SWAGGER_20 = "swagger_20";
    private static final String OPENAPI_30 = "openapi_30";
    private final ResourceRepository resourceRepository;
    private final ServiceRepository serviceRepository;
    private final GenericResourceRepository genericResourceRepository;

    public ResourceController(ResourceRepository resourceRepository, ServiceRepository serviceRepository, GenericResourceRepository genericResourceRepository) {
        this.resourceRepository = resourceRepository;
        this.serviceRepository = serviceRepository;
        this.genericResourceRepository = genericResourceRepository;
    }

    @GetMapping(value={"/resources/{name}"})
    public ResponseEntity<Object> getResourceByName(@PathVariable(value="name") String name, HttpServletRequest request) {
        name = URLDecoder.decode(name, StandardCharsets.UTF_8);
        log.info("Requesting resource named {}", (Object)name);
        List<Resource> resources = this.resourceRepository.findByName(name);
        if (!resources.isEmpty()) {
            Optional<Resource> resourceOpt = resources.stream().filter(Resource::isMainArtifact).findFirst();
            return resourceOpt.map(this::responseWithResource).orElseGet(() -> new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND));
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    @GetMapping(value={"/resources/id/{id}"})
    public ResponseEntity<Object> getResourceById(@PathVariable(value="id") String id, HttpServletRequest request) {
        log.info("Requesting resource with id {}", (Object)id);
        Optional resourceOpt = this.resourceRepository.findById(id);
        return resourceOpt.map(this::responseWithResource).orElseGet(() -> new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND));
    }

    @GetMapping(value={"/resources/service/{serviceId}"})
    public List<Resource> getServiceResources(@PathVariable(value="serviceId") String serviceId) {
        log.debug("Request resources for service {}", (Object)serviceId);
        return this.resourceRepository.findByServiceId(serviceId);
    }

    @GetMapping(value={"/resources/{serviceId}/{resourceType}"})
    public ResponseEntity<byte[]> getServiceResource(@PathVariable(value="serviceId") String serviceId, @PathVariable(value="resourceType") String resourceType, HttpServletResponse response) {
        log.info("Requesting {} resource for service {}", (Object)resourceType, (Object)serviceId);
        Service service = this.serviceRepository.findById(serviceId).orElse(null);
        if (service != null && ServiceType.GENERIC_REST.equals((Object)service.getType())) {
            JsonNode referenceSchema = null;
            List<GenericResource> genericResources = this.genericResourceRepository.findReferencesByServiceId(serviceId);
            if (genericResources != null && !genericResources.isEmpty()) {
                try {
                    Document reference = genericResources.get(0).getPayload();
                    reference.append("id", (Object)genericResources.get(0).getId());
                    referenceSchema = OpenAPISchemaBuilder.buildTypeSchemaFromJson((String)reference.toJson());
                }
                catch (Exception e) {
                    log.warn("Exception while building reference schema", e);
                }
            }
            InputStream stream = null;
            String resource = this.findResource(service);
            HttpHeaders headers = new HttpHeaders();
            String templatePath = null;
            if (SWAGGER_20.equals(resourceType)) {
                templatePath = "templates/swagger-2.0.yaml";
            } else if (OPENAPI_30.equals(resourceType)) {
                templatePath = "templates/openapi-3.0.yaml";
            }
            try {
                stream = ResourceUtil.getClasspathResource(templatePath);
            }
            catch (IOException e) {
                log.error("IOException while reading {} template: {}", templatePath, e.getMessage());
            }
            headers.set("Content-Type", "text/yaml");
            if (stream != null) {
                String result = ResourceUtil.replaceTemplatesInSpecStream(stream, service, resource, referenceSchema, null);
                return new ResponseEntity((Object)result.getBytes(), (MultiValueMap)headers, (HttpStatusCode)HttpStatus.OK);
            }
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.BAD_REQUEST);
    }

    private ResponseEntity<Object> responseWithResource(Resource resource) {
        String extension = resource.getName().substring(resource.getName().lastIndexOf(46));
        HttpHeaders headers = new HttpHeaders();
        if (".json".equals(extension)) {
            headers.setContentType(MediaType.APPLICATION_JSON);
        } else if (".yaml".equals(extension) || ".yml".equals(extension)) {
            headers.set("Content-Type", "text/yaml");
            headers.setContentDisposition(ContentDisposition.builder((String)"inline").filename(resource.getName()).build());
        } else if (".wsdl".equals(extension) || ".xsd".equals(extension)) {
            headers.setContentType(MediaType.TEXT_XML);
        } else if (".avsc".equals(extension)) {
            headers.setContentType(MediaType.APPLICATION_JSON);
        }
        return new ResponseEntity((Object)resource.getContent(), (MultiValueMap)headers, (HttpStatusCode)HttpStatus.OK);
    }

    private String findResource(Service service) {
        for (Operation operation : service.getOperations()) {
            if (!operation.getName().startsWith("GET /") || operation.getName().endsWith("/:id")) continue;
            return operation.getName().substring("GET /".length());
        }
        return null;
    }
}

