/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.web;

import io.github.microcks.domain.Metadata;
import io.github.microcks.domain.Operation;
import io.github.microcks.domain.RequestResponsePair;
import io.github.microcks.domain.Service;
import io.github.microcks.domain.ServiceType;
import io.github.microcks.domain.ServiceView;
import io.github.microcks.domain.UnidirectionalEvent;
import io.github.microcks.repository.CustomServiceRepository;
import io.github.microcks.repository.ServiceRepository;
import io.github.microcks.security.UserInfo;
import io.github.microcks.service.MessageService;
import io.github.microcks.service.ServiceService;
import io.github.microcks.util.EntityAlreadyExistsException;
import io.github.microcks.util.IdBuilder;
import io.github.microcks.util.SafeLogger;
import io.github.microcks.web.dto.GenericResourceServiceDTO;
import io.github.microcks.web.dto.OperationOverrideDTO;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
public class ServiceController {
    private static final SafeLogger log = SafeLogger.getLogger(ServiceController.class);
    private final ServiceService serviceService;
    private final ServiceRepository serviceRepository;
    private final MessageService messageService;

    public ServiceController(ServiceService serviceService, ServiceRepository serviceRepository, MessageService messageService) {
        this.serviceService = serviceService;
        this.serviceRepository = serviceRepository;
        this.messageService = messageService;
    }

    @GetMapping(value={"/services"})
    public List<Service> listServices(@RequestParam(value="page", required=false, defaultValue="0") int page, @RequestParam(value="size", required=false, defaultValue="20") int size) {
        log.debug("Getting service list for page {} and size {}", (Object)page, (Object)size);
        return this.serviceRepository.findAll((Pageable)PageRequest.of((int)page, (int)size, (Sort)Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"name", "version"}))).getContent();
    }

    @GetMapping(value={"/services/search"})
    public List<Service> searchServices(@RequestParam Map<String, String> queryMap) {
        String name = null;
        HashMap<String, String> labels = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : queryMap.entrySet()) {
            if ("name".equals(entry.getKey())) {
                name = entry.getValue();
                continue;
            }
            if (!entry.getKey().startsWith("labels.")) continue;
            labels.put(entry.getKey().substring(entry.getKey().indexOf(46) + 1), entry.getValue());
        }
        if (labels.isEmpty()) {
            log.debug("Searching services corresponding to name {}", (Object)name);
            return this.serviceRepository.findByNameLike(name);
        }
        if (name == null || name.trim().isEmpty()) {
            log.debug("Searching services corresponding to labels {}", (Object)labels);
            return this.serviceRepository.findByLabels(labels);
        }
        log.debug("Searching services corresponding to name {} and labels {}", (Object)name, (Object)labels);
        return this.serviceRepository.findByLabelsAndNameLike(labels, name);
    }

    @GetMapping(value={"/services/count"})
    public Map<String, Long> countServices() {
        log.debug("Counting services...");
        HashMap<String, Long> counter = new HashMap<String, Long>();
        counter.put("counter", this.serviceRepository.count());
        return counter;
    }

    @GetMapping(value={"/services/map"})
    public Map<String, Integer> getServicesMap() {
        log.debug("Counting services by type...");
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        List results = this.serviceRepository.countServicesByType();
        for (CustomServiceRepository.ServiceCount count : results) {
            map.put(count.getType(), count.getNumber());
        }
        return map;
    }

    @GetMapping(value={"/services/labels"})
    public Map<String, String[]> getServicesLabels() {
        log.debug("Retrieving available services labels...");
        HashMap<String, String[]> labelValues = new HashMap<String, String[]>();
        List results = this.serviceRepository.listLabels();
        for (CustomServiceRepository.LabelValues values : results) {
            labelValues.put(values.getKey(), values.getValues());
        }
        return labelValues;
    }

    @GetMapping(value={"/services/{id:.+}"}, produces={"application/json"})
    public ResponseEntity<?> getService(@PathVariable(value="id") String serviceId, @RequestParam(value="messages", required=false, defaultValue="true") boolean messages) {
        log.debug("Retrieving service with id {}", (Object)serviceId);
        Service service = null;
        if (serviceId.contains(":")) {
            String name = serviceId.substring(0, serviceId.indexOf(58));
            String version = serviceId.substring(serviceId.indexOf(58) + 1);
            if (name.contains("+")) {
                name = name.replace('+', ' ');
            }
            service = this.serviceRepository.findByNameAndVersion(name, version);
        } else {
            service = this.serviceRepository.findById(serviceId).orElse(null);
        }
        if (messages) {
            HashMap<String, List<Object>> messagesMap = new HashMap<String, List<Object>>();
            for (Operation operation : service.getOperations()) {
                if (service.getType() == ServiceType.EVENT || service.getType() == ServiceType.GENERIC_EVENT) {
                    List<UnidirectionalEvent> events = this.messageService.getEventByOperation(IdBuilder.buildOperationId((Service)service, (Operation)operation));
                    messagesMap.put(operation.getName(), events);
                    continue;
                }
                List<RequestResponsePair> pairs = this.messageService.getRequestResponseByOperation(IdBuilder.buildOperationId((Service)service, (Operation)operation));
                messagesMap.put(operation.getName(), pairs);
            }
            return new ResponseEntity((Object)new ServiceView(service, messagesMap), (HttpStatusCode)HttpStatus.OK);
        }
        return new ResponseEntity((Object)service, (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/services/generic"})
    public ResponseEntity<Service> createGenericResourceService(@RequestBody GenericResourceServiceDTO serviceDTO) {
        log.debug("Creating a new Service '{}-{}' for generic resource '{}'", serviceDTO.getName(), serviceDTO.getVersion(), serviceDTO.getResource());
        try {
            Service service = this.serviceService.createGenericResourceService(serviceDTO.getName(), serviceDTO.getVersion(), serviceDTO.getResource(), serviceDTO.getReferencePayload());
            return new ResponseEntity((Object)service, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (EntityAlreadyExistsException eaee) {
            log.error("Service '{}-{} already exists'", serviceDTO.getName(), serviceDTO.getVersion());
            return new ResponseEntity((HttpStatusCode)HttpStatus.CONFLICT);
        }
    }

    @PostMapping(value={"/services/generic/event"})
    public ResponseEntity<Service> createGenericEventService(@RequestBody GenericResourceServiceDTO serviceDTO) {
        log.debug("Creating a new Service '{}-{}' for generic resource '{}'", serviceDTO.getName(), serviceDTO.getVersion(), serviceDTO.getResource());
        try {
            Service service = this.serviceService.createGenericEventService(serviceDTO.getName(), serviceDTO.getVersion(), serviceDTO.getResource(), serviceDTO.getReferencePayload());
            return new ResponseEntity((Object)service, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (EntityAlreadyExistsException eaee) {
            log.error("Service '{}-{} already exists'", serviceDTO.getName(), serviceDTO.getVersion());
            return new ResponseEntity((HttpStatusCode)HttpStatus.CONFLICT);
        }
    }

    @PutMapping(value={"/services/{id}/metadata"})
    public ResponseEntity<?> updateMetadata(@PathVariable(value="id") String serviceId, @RequestBody Metadata metadata, UserInfo userInfo) {
        log.debug("Updating the metadata of service {}", (Object)serviceId);
        boolean result = this.serviceService.updateMetadata(serviceId, metadata, userInfo);
        if (result) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.OK);
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.FORBIDDEN);
    }

    @PutMapping(value={"/services/{id}/operation"})
    public ResponseEntity<?> overrideServiceOperation(@PathVariable(value="id") String serviceId, @RequestParam(value="operationName") String operationName, @RequestBody OperationOverrideDTO operationOverride, UserInfo userInfo) {
        log.debug("Updating operation {} of service {}", (Object)operationName, (Object)serviceId);
        log.debug("ParameterConstraints?: {}", (Object)operationOverride.getParameterConstraints());
        boolean result = this.serviceService.updateOperation(serviceId, operationName, operationOverride.getDispatcher(), operationOverride.getDispatcherRules(), operationOverride.getDefaultDelay(), operationOverride.getParameterConstraints(), userInfo);
        if (result) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.OK);
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.FORBIDDEN);
    }

    @DeleteMapping(value={"/services/{id}"})
    public ResponseEntity<String> deleteService(@PathVariable(value="id") String serviceId, UserInfo userInfo) {
        log.debug("Removing service with id {}", (Object)serviceId);
        boolean result = this.serviceService.deleteService(serviceId, userInfo);
        if (result) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.OK);
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.FORBIDDEN);
    }
}

