/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.web;

import io.github.microcks.domain.Secret;
import io.github.microcks.domain.Service;
import io.github.microcks.repository.SecretRepository;
import io.github.microcks.service.ArtifactInfo;
import io.github.microcks.service.ServiceService;
import io.github.microcks.util.HTTPDownloader;
import io.github.microcks.util.MockRepositoryImportException;
import io.github.microcks.util.ReferenceResolver;
import io.github.microcks.util.RelativeReferenceURLBuilderFactory;
import io.github.microcks.util.SafeLogger;
import io.github.microcks.util.SimpleReferenceURLBuilder;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Paths;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api"})
public class UploadArtifactController {
    private static final SafeLogger log = SafeLogger.getLogger(UploadArtifactController.class);
    private final ServiceService serviceService;
    private final SecretRepository secretRepository;
    @Value(value="${default-artifacts-repository.url:#{null}}")
    private Optional<String> defaultArtifactsRepositoryUrl;

    public UploadArtifactController(ServiceService serviceService, SecretRepository secretRepository) {
        this.serviceService = serviceService;
        this.secretRepository = secretRepository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"/artifact/download"})
    public ResponseEntity<String> importArtifact(@RequestParam(value="url", required=true) String url, @RequestParam(value="mainArtifact", defaultValue="true") boolean mainArtifact, @RequestParam(value="secretName", required=false) String secretName) {
        if (!url.isEmpty()) {
            List<Service> services = null;
            Secret secret = null;
            if (secretName != null) {
                secret = this.secretRepository.findByName(secretName).stream().findFirst().orElse(null);
                log.debug("Secret {} was requested. Have we found it? {}", (Object)secretName, (Object)(secret != null ? 1 : 0));
            }
            File localFile = null;
            try {
                HTTPDownloader.FileAndHeaders fileAndHeaders = HTTPDownloader.handleHTTPDownloadToFileAndHeaders(url, secret, true);
                localFile = fileAndHeaders.getLocalFile();
                services = this.serviceService.importServiceDefinition(localFile, new ReferenceResolver(url, secret, true, RelativeReferenceURLBuilderFactory.getRelativeReferenceURLBuilder(fileAndHeaders.getResponseHeaders())), new ArtifactInfo(url, mainArtifact));
            }
            catch (IOException ioe) {
                log.error("Exception while retrieving remote item {}", url, ioe);
                ResponseEntity responseEntity = new ResponseEntity((Object)"Exception while retrieving remote item", (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
                return responseEntity;
            }
            catch (MockRepositoryImportException mrie) {
                log.error("Exception while reading remote item {}", url, mrie);
                ResponseEntity responseEntity = new ResponseEntity((Object)mrie.getMessage(), (HttpStatusCode)HttpStatus.BAD_REQUEST);
                return responseEntity;
            }
            finally {
                if (localFile != null) {
                    localFile.delete();
                }
            }
            if (services != null && !services.isEmpty()) {
                return new ResponseEntity((Object)("{\"name\": \"" + services.get(0).getName() + ":" + services.get(0).getVersion() + "\"}"), (HttpStatusCode)HttpStatus.CREATED);
            }
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NO_CONTENT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"/artifact/upload"})
    public ResponseEntity<String> importArtifact(@RequestParam(value="file") MultipartFile file, @RequestParam(value="mainArtifact", defaultValue="true") boolean mainArtifact) {
        if (!file.isEmpty()) {
            log.debug("Content type of {} is {}", (Object)file.getOriginalFilename(), (Object)file.getContentType());
            List<Service> services = null;
            String localFile = null;
            try {
                localFile = System.getProperty("java.io.tmpdir") + "/microcks-" + System.currentTimeMillis() + ".artifact";
                try (ReadableByteChannel rbc = Channels.newChannel(file.getInputStream());
                     FileOutputStream fos = new FileOutputStream(localFile);){
                    fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
                }
                ReferenceResolver referenceResolver = this.getDefaultReferenceResolver(file.getOriginalFilename());
                services = this.serviceService.importServiceDefinition(new File(localFile), referenceResolver, new ArtifactInfo(file.getOriginalFilename(), mainArtifact));
            }
            catch (IOException ioe) {
                log.error("Exception while writing uploaded item {}", file.getOriginalFilename(), ioe);
                ResponseEntity responseEntity = new ResponseEntity((Object)"Exception while writing uploaded item", (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
                return responseEntity;
            }
            catch (MockRepositoryImportException mrie) {
                log.error("Exception while reading uploaded item {}", file.getOriginalFilename(), mrie);
                ResponseEntity responseEntity = new ResponseEntity((Object)mrie.getMessage(), (HttpStatusCode)HttpStatus.BAD_REQUEST);
                return responseEntity;
            }
            finally {
                if (localFile != null) {
                    Paths.get(localFile, new String[0]).toFile().delete();
                }
            }
            if (services != null && !services.isEmpty()) {
                return new ResponseEntity((Object)(services.get(0).getName() + ":" + services.get(0).getVersion()), (HttpStatusCode)HttpStatus.CREATED);
            }
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NO_CONTENT);
    }

    private ReferenceResolver getDefaultReferenceResolver(String fileName) {
        log.debug("defaultArtifactsRepositoryUrl is {}", (Object)this.defaultArtifactsRepositoryUrl);
        if (this.defaultArtifactsRepositoryUrl.isPresent()) {
            String repositoryUrl = this.defaultArtifactsRepositoryUrl.get();
            String baseRepositoryUrl = repositoryUrl.endsWith("/") ? repositoryUrl + fileName : repositoryUrl + "/" + fileName;
            ReferenceResolver resolver = new ReferenceResolver(baseRepositoryUrl, null, true, new SimpleReferenceURLBuilder());
            if (!repositoryUrl.startsWith("http")) {
                resolver.setCleanResolvedFiles(false);
            }
            return resolver;
        }
        return null;
    }
}

