/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.service;

import io.github.microcks.domain.ImportJob;
import io.github.microcks.domain.Operation;
import io.github.microcks.domain.Request;
import io.github.microcks.domain.Response;
import io.github.microcks.domain.Secret;
import io.github.microcks.domain.Service;
import io.github.microcks.domain.TestCaseResult;
import io.github.microcks.domain.TestResult;
import io.github.microcks.domain.TestReturn;
import io.github.microcks.domain.TestRunnerType;
import io.github.microcks.domain.TestStepResult;
import io.github.microcks.repository.ImportJobRepository;
import io.github.microcks.repository.RequestRepository;
import io.github.microcks.repository.ResourceRepository;
import io.github.microcks.repository.ResponseRepository;
import io.github.microcks.repository.SecretRepository;
import io.github.microcks.repository.TestResultRepository;
import io.github.microcks.util.HTTPDownloader;
import io.github.microcks.util.IdBuilder;
import io.github.microcks.util.asyncapi.AsyncAPITestRunner;
import io.github.microcks.util.graphql.GraphQLTestRunner;
import io.github.microcks.util.grpc.GrpcTestRunner;
import io.github.microcks.util.openapi.OpenAPITestRunner;
import io.github.microcks.util.postman.PostmanTestStepsRunner;
import io.github.microcks.util.soapui.SoapUITestStepsRunner;
import io.github.microcks.util.test.AbstractTestRunner;
import io.github.microcks.util.test.HttpTestRunner;
import io.github.microcks.util.test.SoapHttpTestRunner;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.security.KeyStore;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.client.HttpClient;
import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.apache.http.ssl.SSLContexts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.scheduling.annotation.Async;

@org.springframework.stereotype.Service
public class TestRunnerService {
    private static Logger log = LoggerFactory.getLogger(TestRunnerService.class);
    private static final String BEGIN_CERTIFICATE = "-----BEGIN CERTIFICATE-----";
    private static final String END_CERTIFICATE = "-----END CERTIFICATE-----";
    @Autowired
    private ResourceRepository resourceRepository;
    @Autowired
    private RequestRepository requestRepository;
    @Autowired
    private ResponseRepository responseRepository;
    @Autowired
    private TestResultRepository testResultRepository;
    @Autowired
    private ImportJobRepository jobRepository;
    @Autowired
    private SecretRepository secretRepository;
    @Value(value="${tests-callback.url}")
    private final String testsCallbackUrl;
    @Value(value="${postman-runner.url}")
    private final String postmanRunnerUrl;
    @Value(value="${async-minion.url}")
    private final String asyncMinionUrl;
    @Value(value="${validation.resourceUrl}")
    private final String validationResourceUrl;

    public TestRunnerService() {
        this.testsCallbackUrl = null;
        this.postmanRunnerUrl = null;
        this.asyncMinionUrl = null;
        this.validationResourceUrl = null;
    }

    @Async
    public CompletableFuture<TestResult> launchTestsInternal(TestResult testResult, Service service, TestRunnerType runnerType) {
        AbstractTestRunner<HttpMethod> testRunner;
        List<TestResult> older = this.testResultRepository.findByServiceId(service.getId(), (Pageable)PageRequest.of((int)0, (int)2, (Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"testNumber"}));
        if (older != null && !older.isEmpty() && older.get(0).getTestNumber() != null) {
            testResult.setTestNumber(Long.valueOf(older.get(0).getTestNumber() + 1L));
        } else {
            testResult.setTestNumber(Long.valueOf(1L));
        }
        Secret secret = null;
        if (testResult.getSecretRef() != null) {
            secret = this.secretRepository.findById(testResult.getSecretRef().getSecretId()).orElse(null);
            log.debug("Using a secret to test endpoint? '{}'", (Object)(secret != null ? secret.getName() : "none"));
        }
        if ((testRunner = this.retrieveRunner(runnerType, secret, testResult.getTimeout(), service.getId())) == null) {
            testResult.setSuccess(false);
            testResult.setInProgress(false);
            testResult.setElapsedTime(0L);
            this.testResultRepository.save(testResult);
            return CompletableFuture.completedFuture(testResult);
        }
        for (TestCaseResult testCaseResult : testResult.getTestCaseResults()) {
            Operation operation = service.getOperations().stream().filter(o -> o.getName().equals(testCaseResult.getOperationName())).findFirst().get();
            String testCaseId = IdBuilder.buildTestCaseId((TestResult)testResult, (Operation)operation);
            List<Request> requests = this.requestRepository.findByOperationId(IdBuilder.buildOperationId((Service)service, (Operation)operation));
            requests = this.cloneRequestsForTestCase(requests, testCaseId);
            ArrayList<TestReturn> results = new ArrayList();
            try {
                HttpMethod method = testRunner.buildMethod(operation.getMethod());
                results = testRunner.runTest(service, operation, testResult, requests, testResult.getTestedEndpoint(), method);
            }
            catch (URISyntaxException use) {
                log.error("URISyntaxException on endpoint {}, aborting current tests", (Object)testResult.getTestedEndpoint(), (Object)use);
                testCaseResult.setSuccess(false);
                testCaseResult.setElapsedTime(0L);
                this.testResultRepository.save(testResult);
                break;
            }
            catch (Throwable t) {
                log.error("Throwable while testing operation {}", (Object)operation.getName(), (Object)t);
            }
            if (results == null) {
                testCaseResult.setSuccess(false);
                testCaseResult.setElapsedTime(0L);
                this.testResultRepository.save(testResult);
                continue;
            }
            if (results.isEmpty()) continue;
            this.updateTestCaseResultWithReturns(testCaseResult, results, testCaseId);
            this.testResultRepository.save(testResult);
        }
        this.updateTestResult(testResult);
        return CompletableFuture.completedFuture(testResult);
    }

    private void updateTestCaseResultWithReturns(TestCaseResult testCaseResult, List<TestReturn> testReturns, String testCaseId) {
        boolean successFlag = true;
        long caseElapsedTime = 0L;
        ArrayList<Response> responses = new ArrayList<Response>();
        ArrayList<Request> actualRequests = new ArrayList<Request>();
        for (TestReturn testReturn : testReturns) {
            caseElapsedTime += testReturn.getElapsedTime();
            TestStepResult testStepResult = testReturn.buildTestStepResult();
            if (!testStepResult.isSuccess()) {
                successFlag = false;
            }
            testReturn.getResponse().setTestCaseId(testCaseId);
            testReturn.getRequest().setTestCaseId(testCaseId);
            responses.add(testReturn.getResponse());
            actualRequests.add(testReturn.getRequest());
            testCaseResult.getTestStepResults().add(testStepResult);
        }
        log.debug("Saving {} responses with testCaseId {}", (Object)responses.size(), (Object)testCaseId);
        this.responseRepository.saveAll(responses);
        for (int i = 0; i < actualRequests.size(); ++i) {
            ((Request)actualRequests.get(i)).setResponseId(((Response)responses.get(i)).getId());
        }
        log.debug("Saving {} requests with testCaseId {}", (Object)responses.size(), (Object)testCaseId);
        this.requestRepository.saveAll(actualRequests);
        if (testCaseResult.getTestStepResults().size() > 0) {
            testCaseResult.setSuccess(successFlag);
        }
        testCaseResult.setElapsedTime(caseElapsedTime);
    }

    private void updateTestResult(TestResult testResult) {
        log.debug("Updating total testResult");
        boolean globalSuccessFlag = true;
        boolean globalProgressFlag = false;
        long totalElapsedTime = 0L;
        for (TestCaseResult testCaseResult : testResult.getTestCaseResults()) {
            totalElapsedTime += testCaseResult.getElapsedTime();
            if (!testCaseResult.isSuccess()) {
                globalSuccessFlag = false;
            }
            if (testCaseResult.getElapsedTime() != -1L) continue;
            log.debug("testCaseResult.elapsedTime is -1, set globalProgressFlag to true");
            globalProgressFlag = true;
        }
        testResult.setSuccess(globalSuccessFlag);
        testResult.setInProgress(globalProgressFlag);
        testResult.setElapsedTime(totalElapsedTime);
        this.testResultRepository.save(testResult);
    }

    private List<Request> cloneRequestsForTestCase(List<Request> requests, String testCaseId) {
        ArrayList<Request> result = new ArrayList<Request>();
        for (Request request : requests) {
            Request clone = new Request();
            clone.setName(request.getName());
            clone.setContent(request.getContent());
            clone.setHeaders(request.getHeaders());
            clone.setQueryParameters(request.getQueryParameters());
            clone.setResponseId(request.getResponseId());
            clone.setTestCaseId(testCaseId);
            result.add(clone);
        }
        return result;
    }

    private AbstractTestRunner<HttpMethod> retrieveRunner(TestRunnerType runnerType, Secret secret, Long runnerTimeout, String serviceId) {
        SSLContext sslContext = null;
        try {
            if (secret != null && secret.getCaCertPem() != null) {
                log.debug("Test Secret contains a CA Cert, installing certificate into SSLContext");
                sslContext = SSLContexts.custom().loadTrustMaterial(this.buildCustomCaCertTruststore(secret.getCaCertPem()), null).build();
            } else {
                log.debug("No Test Secret or no CA Cert found, installing accept everything strategy");
                sslContext = SSLContexts.custom().loadTrustMaterial(null, (cert, authType) -> true).build();
            }
        }
        catch (Exception e) {
            log.error("Exception while building SSLContext with acceptingTrustStrategy", (Throwable)e);
            return null;
        }
        SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        Registry socketFactoryRegistry = RegistryBuilder.create().register("https", (Object)sslsf).register("http", (Object)new PlainConnectionSocketFactory()).build();
        BasicHttpClientConnectionManager connectionManager = new BasicHttpClientConnectionManager((Lookup)socketFactoryRegistry);
        CloseableHttpClient httpClient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).setConnectionManager((HttpClientConnectionManager)connectionManager).build();
        HttpComponentsClientHttpRequestFactory factory = new HttpComponentsClientHttpRequestFactory((HttpClient)httpClient);
        factory.setConnectTimeout(200);
        factory.setReadTimeout(runnerTimeout.intValue());
        switch (runnerType) {
            case SOAP_HTTP: {
                SoapHttpTestRunner soapRunner = new SoapHttpTestRunner();
                soapRunner.setClientHttpRequestFactory((ClientHttpRequestFactory)factory);
                soapRunner.setResourceUrl(this.validationResourceUrl);
                soapRunner.setSecret(secret);
                return soapRunner;
            }
            case OPEN_API_SCHEMA: {
                OpenAPITestRunner openApiRunner = new OpenAPITestRunner(this.resourceRepository, this.responseRepository, true);
                openApiRunner.setClientHttpRequestFactory((ClientHttpRequestFactory)factory);
                openApiRunner.setResourceUrl(this.validationResourceUrl);
                openApiRunner.setSecret(secret);
                return openApiRunner;
            }
            case ASYNC_API_SCHEMA: {
                AsyncAPITestRunner asyncApiRunner = new AsyncAPITestRunner(this.resourceRepository, this.secretRepository);
                asyncApiRunner.setClientHttpRequestFactory((ClientHttpRequestFactory)factory);
                asyncApiRunner.setAsyncMinionUrl(this.asyncMinionUrl);
                return asyncApiRunner;
            }
            case GRPC_PROTOBUF: {
                GrpcTestRunner grpcRunner = new GrpcTestRunner(this.resourceRepository);
                grpcRunner.setSecret(secret);
                grpcRunner.setTimeout(runnerTimeout);
                return grpcRunner;
            }
            case GRAPHQL_SCHEMA: {
                GraphQLTestRunner graphqlRunner = new GraphQLTestRunner(this.resourceRepository);
                graphqlRunner.setClientHttpRequestFactory((ClientHttpRequestFactory)factory);
                graphqlRunner.setSecret(secret);
                return graphqlRunner;
            }
            case SOAP_UI: {
                List<ImportJob> jobs = this.jobRepository.findByServiceRefId(serviceId);
                if (jobs != null && !jobs.isEmpty()) {
                    try {
                        String projectFile = this.handleJobRepositoryDownloadToFile(jobs.get(0));
                        SoapUITestStepsRunner soapUIRunner = new SoapUITestStepsRunner(projectFile);
                        return soapUIRunner;
                    }
                    catch (IOException ioe) {
                        log.error("IOException while downloading {}", (Object)jobs.get(0).getRepositoryUrl());
                        return null;
                    }
                }
            }
            case POSTMAN: {
                List<ImportJob> jobs = this.jobRepository.findByServiceRefId(serviceId);
                if (jobs == null || jobs.isEmpty()) break;
                try {
                    String collectionFile = this.handleJobRepositoryDownloadToFile(jobs.get(0));
                    PostmanTestStepsRunner postmanRunner = new PostmanTestStepsRunner(collectionFile);
                    postmanRunner.setClientHttpRequestFactory((ClientHttpRequestFactory)factory);
                    postmanRunner.setTestsCallbackUrl(this.testsCallbackUrl);
                    postmanRunner.setPostmanRunnerUrl(this.postmanRunnerUrl);
                    return postmanRunner;
                }
                catch (IOException ioe) {
                    log.error("IOException while downloading {}", (Object)jobs.get(0).getRepositoryUrl());
                    return null;
                }
            }
        }
        HttpTestRunner httpRunner = new HttpTestRunner();
        httpRunner.setClientHttpRequestFactory((ClientHttpRequestFactory)factory);
        httpRunner.setSecret(secret);
        return httpRunner;
    }

    private KeyStore buildCustomCaCertTruststore(String caCertPem) throws Exception {
        String strippedPem = caCertPem.replaceAll(BEGIN_CERTIFICATE, "").replaceAll(END_CERTIFICATE, "");
        ByteArrayInputStream is = new ByteArrayInputStream(Base64.decodeBase64((String)strippedPem));
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        X509Certificate caCert = (X509Certificate)cf.generateCertificate(is);
        KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
        ks.load(null);
        ks.setCertificateEntry("caCert", caCert);
        return ks;
    }

    private String handleJobRepositoryDownloadToFile(ImportJob job) throws IOException {
        Secret jobSecret = null;
        if (job.getSecretRef() != null) {
            log.debug("Retrieving secret {} for job {}", (Object)job.getSecretRef().getName(), (Object)job.getName());
            jobSecret = this.secretRepository.findById(job.getSecretRef().getSecretId()).orElse(null);
        }
        File localFile = HTTPDownloader.handleHTTPDownloadToFile(job.getRepositoryUrl(), jobSecret, job.isRepositoryDisableSSLValidation());
        return localFile.getAbsolutePath();
    }
}

