/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.util;

import io.github.microcks.util.GitLabReferenceURLBuilder;
import io.github.microcks.util.RelativeReferenceURLBuilder;
import io.github.microcks.util.SimpleReferenceURLBuilder;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RelativeReferenceURLBuilderFactory {
    private static Logger log = LoggerFactory.getLogger(RelativeReferenceURLBuilderFactory.class);

    public static RelativeReferenceURLBuilder getRelativeReferenceURLBuilder(Map<String, List<String>> baseFileProperties) {
        if (baseFileProperties != null && baseFileProperties.containsKey("X-Gitlab-File-Name")) {
            log.debug("Found a GitLab File specific header, returning a GitLabReferenceURLBuilder");
            return new GitLabReferenceURLBuilder();
        }
        log.debug("Returning a SimpleReferenceURLBuilder");
        return new SimpleReferenceURLBuilder();
    }
}

